/*
 * Decompiled with CFR 0.152.
 */
package latitude.application;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import latitude.data.csv.CSVFile;
import latitude.data.gtfs.GTFSAlterationProxy;
import latitude.framework.LatitudeConsoleApplication;
import latitude.utils.DateUtils;
import latitude.utils.ListUtils;
import latitude.utils.OptionsUtils;
import latitude.utils.StringUtils;

public class Alterate
extends LatitudeConsoleApplication {
    public static void usage() {
        log.info("USAGE: java /path/to/goauld.jar <origine-gtfs-path> <destination-gtfs-path>");
        log.info("Options are:");
        log.info("  --help\t\t\t\t\tDisplay this usage");
        log.info("  --dissolve-route\t\t\t\tDissolve route ids by route short name and agency id");
        log.info("  --update-stop-name <path-to-csv-dictionary>\tUpdate stop names using a CSV dictionary with columns: \"stop_id\" and \"remplacement\"");
        log.info("  --repair-unnamed-stops <alternative-name>\tName unnamed stops with alternative name");
        log.info("  --agency-filter <agency-name>\t\t\tKeep only agencies containing <agency-name>");
        log.info("  --route-id-filter <route-id-name or list separated by ;> <starts-with=true or false>\tKeep only lines with route_id equals (or starting with) to the given list ids");
        log.info("  --generate-transfers <distanceMax=250> <speed=1.2>\tGenerate a transfers.txt file");
        log.info("  --generate-default-colors <route-color=000000> <route-text-color=ffffff>\tGenerate default colors");
        log.info("  --geo-filter <path-to-geojson>\t\tFilter data with a polygon geojson keeping only routes contained in the geojson");
        log.info("  --repair-unnamed-routes <alternative-name-prefix>\tName unnamed routes with alternative name prefix");
        log.info("  --set-starting-date <starting-date=today>\tSet the starting date, format: yyyyMMdd");
        log.info("  --add-parent-station-suffixe <suffixe>\tAdd a suffixe to parent station stop_id");
    }

    public static void main(String[] argsc) {
        block54: {
            log.info("   ___            _      _     _ \r\n  / _ \\___   __ _( )   _| | __| |\r\n / /_\\/ _ \\ / _` |/ | | | |/ _` |\r\n/ /_\\\\ (_) | (_| || |_| | | (_| |\r\n\\____/\\___/ \\__,_| \\__,_|_|\\__,_|\r\n                                 ");
            List<String> args = ListUtils.arrayToList(argsc);
            if (args.size() >= 1 && args.get(0).startsWith(Alterate.class.getCanonicalName())) {
                args.remove(0);
            }
            try {
                if (args.size() < 2) {
                    Alterate.usage();
                    break block54;
                }
                String input = args.get(0);
                String output = args.get(1);
                log.info("Alterating GTFS " + input + " to " + output);
                GTFSAlterationProxy gtfsAlterationProxy = new GTFSAlterationProxy(input, output);
                int a = 2;
                while (a < args.size()) {
                    List<String> params = OptionsUtils.getParams(args, a);
                    switch (args.get(a)) {
                        case "--help": {
                            Alterate.usage();
                            break;
                        }
                        case "--dissolve-route": {
                            log.info("Dissolving routes by route_short_name");
                            gtfsAlterationProxy.dissolveRouteIdsByRouteShortName(true);
                            break;
                        }
                        case "--update-stop-name": {
                            log.info("Loading alternative stop name dictionary");
                            if (params.size() < 1) {
                                log.error("No dictionary");
                                break;
                            }
                            HashMap<String, String> stopNameMap = new HashMap<String, String>();
                            CSVFile stopNameCSVFile = new CSVFile(params.get(0));
                            stopNameCSVFile.read(false);
                            if (!stopNameCSVFile.isNull()) {
                                while (stopNameCSVFile.next()) {
                                    stopNameMap.put(stopNameCSVFile.getAttrValue("stop_id"), stopNameCSVFile.getAttrValue("remplacement"));
                                }
                            }
                            log.info("Applying dictionary");
                            gtfsAlterationProxy.applyStopNameDictionary(stopNameMap);
                            break;
                        }
                        case "--repair-unnamed-stops": {
                            log.info("Repairing unnamed stops");
                            if (params.size() < 1) {
                                log.error("No alternative name");
                                break;
                            }
                            String alternativeName = params.get(0);
                            gtfsAlterationProxy.repairUnnamedStops(alternativeName);
                            break;
                        }
                        case "--repair-unnamed-routes": {
                            log.info("Repairing unnamed routes");
                            if (params.size() < 1) {
                                log.error("No alternative name");
                                break;
                            }
                            String alternativeRouteNamePrefix = params.get(0);
                            gtfsAlterationProxy.repairUnnamedRoutes(alternativeRouteNamePrefix);
                            break;
                        }
                        case "--agency-filter": {
                            if (params.size() < 1) {
                                log.error("No agency_name filter");
                                break;
                            }
                            String agencyFilter = params.get(0);
                            log.info("Filtering agencies by agency_name=" + agencyFilter);
                            gtfsAlterationProxy.filterByAgencyName(agencyFilter);
                            break;
                        }
                        case "--route-id-filter": {
                            if (params.size() < 1) {
                                log.error("No route_id filter");
                                break;
                            }
                            String routeIdFilter = params.get(0);
                            boolean startsWith = Boolean.valueOf(args.get(a + 2));
                            log.info("Filtering routes by route_id" + (startsWith ? " starting with " : "=") + routeIdFilter);
                            gtfsAlterationProxy.filterByRouteId(routeIdFilter, startsWith);
                            break;
                        }
                        case "--generate-transfers": {
                            double distanceMax = params.size() >= 1 ? Double.parseDouble(params.get(0)) : 250.0;
                            double speed = params.size() >= 2 ? Double.parseDouble(params.get(1)) : 1.2;
                            log.info("Generating transfers distanceMax=" + distanceMax + "m speed=" + speed + " m/s");
                            gtfsAlterationProxy.generateTransfers(distanceMax, speed);
                            break;
                        }
                        case "--generate-default-colors": {
                            String defaultRouteColor = params.size() >= 1 ? params.get(0) : "000000";
                            String defaultRouteTextColor = params.size() >= 2 ? params.get(1) : "ffffff";
                            log.info("Generating colors " + defaultRouteColor + " " + defaultRouteTextColor);
                            gtfsAlterationProxy.generateDefaultColors(defaultRouteColor, defaultRouteTextColor);
                            break;
                        }
                        case "--geo-filter": {
                            if (params.size() < 1) {
                                log.error("No geojson path");
                                break;
                            }
                            String geojsonPath = params.get(0);
                            log.info("Filtering by geojson " + geojsonPath);
                            gtfsAlterationProxy.filterByGeojson(geojsonPath);
                            break;
                        }
                        case "--set-starting-date": {
                            String format = "yyyyMMdd";
                            Date startingDate = params.size() >= 1 ? DateUtils.parseDate(params.get(0), format) : new Date();
                            log.info("Setting starting date to " + DateUtils.getDateWithFormat(format, startingDate));
                            gtfsAlterationProxy.setStartingDate(startingDate);
                            break;
                        }
                        case "--add-parent-station-suffixe": {
                            if (params.size() < 1) {
                                log.error("No suffixe");
                                break;
                            }
                            String suffixe = params.get(0);
                            suffixe = StringUtils.makeSafeForGDBFieldName(suffixe);
                            log.info("Adding parent station suffixe " + suffixe);
                            gtfsAlterationProxy.addParentStationSuffixe(suffixe);
                        }
                    }
                    ++a;
                }
                gtfsAlterationProxy.saveOutputGTFS(false);
                log.info("Termin\u00e9");
            }
            catch (Exception e) {
                log.ex(e);
            }
        }
    }
}

