/*
 * Decompiled with CFR 0.152.
 */
package latitude.application;

import java.io.File;
import java.util.List;
import latitude.command.CommandProxy;
import latitude.data.geojson.GeoJSONFeatureBeanJTS;
import latitude.data.geojson.GeoJSONReaderJTS;
import latitude.data.gtfs.GTFSAlterationProxy;
import latitude.data.gtfs.GTFSFileWriterProxy;
import latitude.data.gtfs.GTFSMergeProxy;
import latitude.data.gtfs.bean.GTFSDatasetBean;
import latitude.framework.LatitudeConsoleApplication;
import latitude.utils.FileUtils;
import latitude.utils.StringUtils;
import latitude.utils.ZipUtils;

public class UpdateRhonexpressGTFS
extends LatitudeConsoleApplication {
    public static String tclGTFSUrl = "https://download.data.grandlyon.com/files/rdata/tcl_sytral.tcltheorique/GTFS_TCL.ZIP";
    public static String rxGTFSUrl = "https://download.data.grandlyon.com/files/rdata/rx_rhonexpress.rxtheorique/GTFS_RX.ZIP";
    public static String[] geojsonUrls = new String[]{"https://download.data.grandlyon.com/wfs/rdata?SERVICE=WFS&VERSION=2.0.0&request=GetFeature&typename=tcl_sytral.tcllignebus&outputFormat=application/json;%20subtype=geojson&SRSNAME=EPSG:4326&startIndex=0&count=1000", "https://download.data.grandlyon.com/wfs/rdata?SERVICE=WFS&VERSION=2.0.0&request=GetFeature&typename=tcl_sytral.tcllignetram&outputFormat=application/json;%20subtype=geojson&SRSNAME=EPSG:4326&startIndex=0&count=1000", "https://download.data.grandlyon.com/wfs/rdata?SERVICE=WFS&VERSION=2.0.0&outputformat=GEOJSON&maxfeatures=30&request=GetFeature&typename=tcl_sytral.tcllignemf_2_0_0", "https://download.data.grandlyon.com/wfs/rdata?SERVICE=WFS&VERSION=2.0.0&outputformat=GEOJSON&maxfeatures=30&request=GetFeature&typename=rx_rhonexpress.rxligne"};
    public static String routeShortNameProperty = "ligne";
    public static String directionIdProperty = "sens";

    public static void main(String[] args) {
        block18: {
            try {
                if (args.length < 2) {
                    log.info("USAGE: UpdateRhonexpressGTFS <destination-gtfs-path> <gtfs-zip-name-without-extension>");
                    log.info("Error codes :");
                    log.info("0 = good");
                    log.info("1 = usage");
                    log.info("2 = downloading");
                    log.info("3 = merging");
                    log.info("4 = adding shapes");
                    log.info("5 = writing final gtfs");
                    log.info("6 = cleaning");
                    System.exit(1);
                    break block18;
                }
                String destPath = args[0];
                String mergedName = args[1];
                new File(destPath).mkdirs();
                String tclGTFSPath = String.valueOf(destPath) + "/TCL";
                String rxGTFSPath = String.valueOf(destPath) + "/RX";
                String mergedGTFSPath = String.valueOf(destPath) + "/MERGED";
                String tclZipFilePath = String.valueOf(destPath) + "/TCL.zip";
                String rxZipFilePath = String.valueOf(destPath) + "/RX.zip";
                String mergedZipFilePath = String.valueOf(destPath) + "/" + mergedName + ".zip";
                CommandProxy commandProxy = new CommandProxy(log);
                GeoJSONReaderJTS geoJSONReader = new GeoJSONReaderJTS();
                try {
                    commandProxy.curl(tclGTFSUrl, tclZipFilePath);
                    ZipUtils.unzip(tclZipFilePath, tclGTFSPath);
                    commandProxy.curl(rxGTFSUrl, rxZipFilePath);
                    ZipUtils.unzip(rxZipFilePath, rxGTFSPath);
                }
                catch (Exception e) {
                    log.ex(e);
                    System.exit(2);
                }
                GTFSDatasetBean mergedDatasetBean = null;
                try {
                    GTFSMergeProxy gtfsMergeProxy = new GTFSMergeProxy(log);
                    mergedDatasetBean = gtfsMergeProxy.merge(rxGTFSPath, tclGTFSPath, true);
                }
                catch (Exception e) {
                    log.ex(e);
                    System.exit(3);
                }
                try {
                    log.info("Ajout des trac\u00e9s");
                    GTFSAlterationProxy gtfsAlterationProxy = new GTFSAlterationProxy(mergedDatasetBean, mergedGTFSPath);
                    String[] stringArray = geojsonUrls;
                    int n = geojsonUrls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String geojsonUrl = stringArray[n2];
                        String geojsonPath = String.valueOf(destPath) + "/" + StringUtils.generateUUID() + ".geojson";
                        commandProxy.curl(geojsonUrl, geojsonPath);
                        List<GeoJSONFeatureBeanJTS> features = geoJSONReader.readGeoJSON(new File(geojsonPath));
                        gtfsAlterationProxy.addShapeFromGeoJSON(features, routeShortNameProperty, directionIdProperty);
                        ++n2;
                    }
                }
                catch (Exception e) {
                    log.ex(e);
                    System.exit(4);
                }
                try {
                    log.info("Ecriture du GTFS");
                    GTFSFileWriterProxy writeProxy = new GTFSFileWriterProxy(log, mergedGTFSPath);
                    writeProxy.writeGTFSDataset(mergedDatasetBean, false);
                    ZipUtils.zip(mergedGTFSPath, mergedZipFilePath);
                }
                catch (Exception e) {
                    log.ex(e);
                    System.exit(5);
                }
                try {
                    log.info("M\u00e9nage");
                    if (new File(tclGTFSPath).exists()) {
                        FileUtils.deleteFolder(new File(tclGTFSPath));
                    }
                    if (new File(rxGTFSPath).exists()) {
                        FileUtils.deleteFolder(new File(rxGTFSPath));
                    }
                    if (new File(mergedGTFSPath).exists()) {
                        FileUtils.deleteFolder(new File(mergedGTFSPath));
                    }
                    List<String> geojsons = FileUtils.getFilenamesFromFolder(destPath, "geojson", true);
                    for (String geojson : geojsons) {
                        new File(geojson).delete();
                    }
                }
                catch (Exception e) {
                    log.ex(e);
                    System.exit(6);
                }
                log.info("Termin\u00e9");
                System.exit(0);
            }
            catch (Exception e) {
                log.ex(e);
            }
        }
    }
}

