/*
 * Decompiled with CFR 0.152.
 */
package latitude.client.idfm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import latitude.client.idfm.IDFMIlicoAdminLineBean;
import latitude.client.idfm.IDFMIlicoCommercialLineBean;
import latitude.command.CommandProxy;
import latitude.data.xml.XMLNodeList;
import latitude.data.xml.XMLUtils;
import latitude.framework.LatitudeException;
import latitude.framework.LatitudeLogger;
import latitude.framework.LatitudeProxy;
import latitude.utils.DateUtils;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class IDFMIlicoProxy
extends LatitudeProxy {
    public Map<String, IDFMIlicoAdminLineBean> adminLineMap;
    public Map<String, List<IDFMIlicoAdminLineBean>> contratMap;
    public Map<String, String> lineColorMap;
    public Map<String, String> textColorMap;
    private static String urlBase = "https://ilico.iledefrance-mobilites.fr/rest/v2/la/";

    public IDFMIlicoProxy(LatitudeLogger log, String ilicoDate) throws LatitudeException, ParseException, IOException {
        Object lineBean;
        String name;
        String id;
        log.info("Interrogation du webservice Ilico");
        String url = String.valueOf(urlBase) + "getlist/0/bus/0/xml";
        String ilicoResponseFilePath = "c:/temp/ilico-" + (ilicoDate == null ? DateUtils.getDateWithFormat("yyyy-MM-dd") : ilicoDate) + ".xml";
        CommandProxy commandProxy = new CommandProxy(log);
        if (!new File(ilicoResponseFilePath).exists()) {
            commandProxy.curl(url, ilicoResponseFilePath);
        }
        this.adminLineMap = new LinkedHashMap<String, IDFMIlicoAdminLineBean>();
        this.contratMap = new LinkedHashMap<String, List<IDFMIlicoAdminLineBean>>();
        HashMap<String, String> responsabilityMap = new HashMap<String, String>();
        HashMap<String, String> schematicMapMap = new HashMap<String, String>();
        HashMap<String, String> operatorMap = new HashMap<String, String>();
        HashMap<String, String> networkMap = new HashMap<String, String>();
        HashMap<String, Object> commercialLineMap = new HashMap<String, Object>();
        Document doc = XMLUtils.fileToDocument(new File(ilicoResponseFilePath));
        XMLNodeList frames = new XMLNodeList(doc.getElementsByTagName("GeneralFrame"));
        if (frames.size() != 2) {
            throw new LatitudeException("erreur ilico");
        }
        Node frame0 = frames.get(0);
        Node frame1 = frames.get(1);
        Node members0 = frame0.getChildNodes().item(1);
        Node members1 = frame1.getChildNodes().item(1);
        List<Node> responsabilitySet = XMLUtils.getChildsByName(members0, "ResponsibilitySet");
        List<Node> schematicMap = XMLUtils.getChildsByName(members0, "SchematicMap");
        List<Node> operator = XMLUtils.getChildsByName(members0, "Operator");
        List<Node> lines = XMLUtils.getChildsByName(members1, "Line");
        List<Node> groupOfLines = XMLUtils.getChildsByName(members1, "GroupOfLines");
        List<Node> networks = XMLUtils.getChildsByName(members1, "Network");
        for (Node responsability : responsabilitySet) {
            id = responsability.getAttributes().getNamedItem("id").getNodeValue();
            name = XMLUtils.getChildByName(responsability, "Name").getTextContent();
            responsabilityMap.put(id, name);
        }
        for (Node schematic : schematicMap) {
            String idrefligc = schematic.getAttributes().getNamedItem("id").getNodeValue().replace("FR1:SchematicMap:", "").replace(":LOC", "");
            String imageUri = XMLUtils.getChildByName(schematic, "ImageUri").getTextContent();
            if (imageUri.length() <= 0) continue;
            schematicMapMap.put(idrefligc, imageUri);
        }
        for (Node oper : operator) {
            id = oper.getAttributes().getNamedItem("id").getNodeValue();
            name = XMLUtils.getChildByName(oper, "Name").getTextContent();
            operatorMap.put(id, name);
        }
        for (Node netw : networks) {
            id = netw.getAttributes().getNamedItem("id").getNodeValue();
            name = XMLUtils.getChildByName(netw, "Name").getTextContent();
            networkMap.put(id, name);
        }
        for (Node line : lines) {
            Node altPresentation;
            lineBean = new IDFMIlicoCommercialLineBean();
            ((IDFMIlicoCommercialLineBean)lineBean).idRefLigC = line.getAttributes().getNamedItem("id").getNodeValue().replace("FR1:Line:", "").replace(":", "");
            ((IDFMIlicoCommercialLineBean)lineBean).shortName = XMLUtils.getChildByName(line, "ShortName").getTextContent();
            ((IDFMIlicoCommercialLineBean)lineBean).name = XMLUtils.getChildByName(line, "Name").getTextContent();
            ((IDFMIlicoCommercialLineBean)lineBean).codeTechnique = XMLUtils.getChildByName(line, "PrivateCode").getTextContent();
            ((IDFMIlicoCommercialLineBean)lineBean).mode = XMLUtils.getChildByName(line, "TransportMode").getTextContent();
            ((IDFMIlicoCommercialLineBean)lineBean).active = line.getAttributes().getNamedItem("status").getNodeValue().equals("active");
            Node operatorRef = XMLUtils.getChildByName(line, "OperatorRef");
            if (operatorRef != null) {
                String ref = operatorRef.getAttributes().getNamedItem("ref").getNodeValue();
                ((IDFMIlicoCommercialLineBean)lineBean).operator = (String)operatorMap.get(ref);
            } else {
                ((IDFMIlicoCommercialLineBean)lineBean).operator = "";
            }
            Node representedRef = XMLUtils.getChildByName(line, "RepresentedByGroupRef");
            if (representedRef != null) {
                String ref = representedRef.getAttributes().getNamedItem("ref").getNodeValue();
                ((IDFMIlicoCommercialLineBean)lineBean).network = (String)networkMap.get(ref);
            } else {
                ((IDFMIlicoCommercialLineBean)lineBean).network = "";
            }
            ((IDFMIlicoCommercialLineBean)lineBean).schematicMapUrl = (String)schematicMapMap.get(((IDFMIlicoCommercialLineBean)lineBean).idRefLigC);
            Node presentation = XMLUtils.getChildByName(line, "Presentation");
            if (presentation != null) {
                ((IDFMIlicoCommercialLineBean)lineBean).colorHexa = XMLUtils.getChildByName(presentation, "Colour").getTextContent();
                ((IDFMIlicoCommercialLineBean)lineBean).colorText = XMLUtils.getChildByName(presentation, "TextColour").getTextContent();
            }
            if ((altPresentation = XMLUtils.getChildByName(line, "AlternativePresentation")) != null) {
                ((IDFMIlicoCommercialLineBean)lineBean).colorCMYK = XMLUtils.getChildByName(altPresentation, "ColourName").getTextContent();
            }
            commercialLineMap.put(((IDFMIlicoCommercialLineBean)lineBean).idRefLigC, lineBean);
        }
        for (Node group : groupOfLines) {
            lineBean = new IDFMIlicoAdminLineBean();
            ((IDFMIlicoAdminLineBean)lineBean).idRefLigA = group.getAttributes().getNamedItem("id").getNodeValue().replace("FR1:GroupOfLines:", "").replace(":", "");
            ((IDFMIlicoAdminLineBean)lineBean).codeAdministratif = XMLUtils.getChildByName(group, "PrivateCode").getTextContent();
            ((IDFMIlicoAdminLineBean)lineBean).nom = XMLUtils.getChildByName(group, "Name").getTextContent();
            ((IDFMIlicoAdminLineBean)lineBean).mode = XMLUtils.getChildByName(group, "TransportMode").getTextContent();
            ((IDFMIlicoAdminLineBean)lineBean).active = group.getAttributes().getNamedItem("status").getNodeValue().equals("active");
            String contratId = group.getAttributes().getNamedItem("responsibilitySetRef").getNodeValue();
            ((IDFMIlicoAdminLineBean)lineBean).contrat = (String)responsabilityMap.get(contratId);
            Node lineMembers = XMLUtils.getChildByName(group, "members");
            if (lineMembers != null) {
                List<Node> lineRefs = XMLUtils.getChildsByName(lineMembers, "LineRef");
                for (Node lineRef : lineRefs) {
                    String idrefligc = lineRef.getAttributes().getNamedItem("ref").getNodeValue().replace("FR1:Line:", "").replace(":", "");
                    ((IDFMIlicoAdminLineBean)lineBean).commercialLines.add((IDFMIlicoCommercialLineBean)commercialLineMap.get(idrefligc));
                }
            }
            this.adminLineMap.put(((IDFMIlicoAdminLineBean)lineBean).idRefLigA, (IDFMIlicoAdminLineBean)lineBean);
            if (!this.contratMap.containsKey(((IDFMIlicoAdminLineBean)lineBean).contrat)) {
                this.contratMap.put(((IDFMIlicoAdminLineBean)lineBean).contrat, new ArrayList());
            }
            this.contratMap.get(((IDFMIlicoAdminLineBean)lineBean).contrat).add((IDFMIlicoAdminLineBean)lineBean);
        }
    }

    public static String codize(String code) {
        if (code.length() == 6) {
            code = "000" + code;
        }
        if (code.length() == 7) {
            code = "00" + code;
        }
        if (code.length() == 8) {
            code = "0" + code;
        }
        return code;
    }

    public Set<String> getAdminIds() {
        LinkedHashSet<String> adminIds = new LinkedHashSet<String>();
        for (Map.Entry<String, IDFMIlicoAdminLineBean> entry : this.adminLineMap.entrySet()) {
            adminIds.add(entry.getValue().codeAdministratif);
        }
        return adminIds;
    }

    public IDFMIlicoAdminLineBean getActiveAdminLine(String codeAdministratif) {
        for (Map.Entry<String, IDFMIlicoAdminLineBean> entry : this.adminLineMap.entrySet()) {
            IDFMIlicoAdminLineBean adminLineBean = entry.getValue();
            if (!adminLineBean.active || !adminLineBean.codeAdministratif.equals(codeAdministratif) || adminLineBean.commercialLines.size() <= 0) continue;
            return adminLineBean;
        }
        return null;
    }

    public String getAdminIdForComId(String comId) {
        for (Map.Entry<String, IDFMIlicoAdminLineBean> adminEntry : this.adminLineMap.entrySet()) {
            for (IDFMIlicoCommercialLineBean comLineBean : adminEntry.getValue().commercialLines) {
                if (!comLineBean.codeTechnique.equals(comId)) continue;
                return adminEntry.getValue().codeAdministratif;
            }
        }
        return null;
    }

    public void loadColorMaps() {
        this.lineColorMap = new HashMap<String, String>();
        this.textColorMap = new HashMap<String, String>();
        for (Map.Entry<String, IDFMIlicoAdminLineBean> adminEntry : this.adminLineMap.entrySet()) {
            for (IDFMIlicoCommercialLineBean comLineBean : adminEntry.getValue().commercialLines) {
                this.lineColorMap.put(comLineBean.codeTechnique, comLineBean.colorCMYK.replace("CMYK:", "").replace(" ", "/"));
                String textColor = comLineBean.colorText.equals("000000") ? "0/0/0/0" : "0/0/0/100";
                this.textColorMap.put(comLineBean.codeTechnique, textColor);
            }
        }
    }
}

