/*
 * Decompiled with CFR 0.152.
 */
package latitude.command;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import latitude.framework.LatitudeException;
import latitude.framework.LatitudeLogger;
import latitude.framework.LatitudeProxy;
import latitude.utils.StringUtils;

public class CommandProxy
extends LatitudeProxy {
    public static String argumentSeparator = "|";
    public static String argumentSeparator2 = "\u00a4";
    public static String argumentSeparator3 = "\u00b6";
    public static String argumentSeparator4 = "\u00a7";
    public static String alternativeApplicationJarPath = null;

    public CommandProxy(LatitudeLogger log) {
        this.log = log;
    }

    public String launchLatitudeApplication(String latitudeApplicationClass, String[] parameters, int xmxValue) throws LatitudeException {
        int np = 0;
        if (parameters != null) {
            np = parameters.length;
        }
        int nCmds = 4 + np + (xmxValue > 0 ? 1 : 0);
        String[] cmds = new String[nCmds];
        int p = -1;
        cmds[++p] = config.get("java6.runtime.exe");
        if (xmxValue > 0) {
            cmds[++p] = "-Xmx" + xmxValue + "m";
        }
        cmds[++p] = "-cp";
        cmds[++p] = alternativeApplicationJarPath == null ? config.get("latitude.application.jar.path") : alternativeApplicationJarPath;
        cmds[++p] = "latitude.application." + latitudeApplicationClass;
        if (np > 0) {
            String[] stringArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                cmds[++p] = parameter;
                ++n2;
            }
        }
        return this.executeCommand(cmds);
    }

    public String curl(String downloadURL, String downloadedFilePath) throws LatitudeException {
        return this.curl(downloadURL, downloadedFilePath, new ArrayList<String>());
    }

    public String curl(String downloadURL, String downloadedFilePath, List<String> params) throws LatitudeException {
        String[] command = new String[4 + params.size()];
        int i = 0;
        command[i] = "curl";
        ++i;
        Iterator<String> iterator = params.iterator();
        while (iterator.hasNext()) {
            String param;
            command[i] = param = iterator.next();
            ++i;
        }
        command[i] = "\"" + downloadURL + "\"";
        command[++i] = "-o";
        command[++i] = downloadedFilePath;
        ++i;
        return this.executeCommand(command);
    }

    public String executeCommand(String[] command) throws LatitudeException {
        this.logCommand(command);
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(true);
        try {
            String line;
            Process process = pb.start();
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream(), StringUtils.ISO8859));
            String result = "";
            while ((line = in.readLine()) != null) {
                if (this.log != null) {
                    this.log.info("\t" + line);
                }
                result = String.valueOf(result) + (result.length() > 0 ? "\n" : "") + line;
            }
            return result;
        }
        catch (IOException e) {
            throw new LatitudeException("Erreur lors de l'ex\u00e9cution de la commande : " + e.getMessage());
        }
    }

    public boolean isProcessRunning(String serviceName) throws Exception {
        String line;
        Process p = Runtime.getRuntime().exec("tasklist");
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = reader.readLine()) != null) {
            if (!line.contains(serviceName)) continue;
            return true;
        }
        return false;
    }

    public void killProcess(String serviceName) throws Exception {
        Runtime.getRuntime().exec("taskkill /IM \"" + serviceName + "\"");
    }

    public void executeCommandInSeparateProcess(String[] command) throws IOException {
        this.logCommand(command);
        String[] cmds = new String[3 + command.length];
        cmds[0] = "cmd.exe";
        cmds[1] = "/c";
        cmds[2] = "start";
        int i = 0;
        while (i < command.length) {
            cmds[3 + i] = command[i];
            ++i;
        }
        Runtime.getRuntime().exec(cmds);
    }

    public static void openFileWithDefaultApplication(String filePath) throws IOException {
        File file = new File(filePath);
        CommandProxy.openFileWithDefaultApplication(file);
    }

    public static void openFileWithDefaultApplication(File file) throws IOException {
        Desktop.getDesktop().open(file);
    }

    private void logCommand(String[] command) {
        if (this.log != null) {
            String logCommand = "Executing";
            String[] stringArray = command;
            int n = command.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                logCommand = !c.contains("\"") && c.contains(" ") ? String.valueOf(logCommand) + " \"" + c + "\"" : String.valueOf(logCommand) + " " + c;
                ++n2;
            }
            this.log.info(logCommand);
        }
    }
}

