/*
 * Decompiled with CFR 0.152.
 */
package latitude.data.autoroute;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import latitude.client.idfm.IDFMIlicoAdminLineBean;
import latitude.client.idfm.IDFMIlicoCommercialLineBean;
import latitude.data.autoroute.AutorouteProxyResult;
import latitude.data.csv.CSVFile;
import latitude.data.geojson.GeoJSONFeatureBeanJTS;
import latitude.data.geojson.GeoJSONReaderJTS;
import latitude.data.gtfs.GTFSFileReaderProxy;
import latitude.data.gtfs.GTFSFileWriterProxy;
import latitude.data.gtfs.bean.GTFSDatasetBean;
import latitude.data.gtfs.bean.GTFSRouteBean;
import latitude.data.gtfs.bean.GTFSShapeBean;
import latitude.data.gtfs.bean.GTFSShapePointBean;
import latitude.data.gtfs.bean.GTFSStopBean;
import latitude.data.gtfs.bean.GTFSStopTimeBean;
import latitude.data.gtfs.bean.GTFSTripBean;
import latitude.data.gtfs.bean.GTFSTripStopTimeBean;
import latitude.framework.LatitudeException;
import latitude.framework.LatitudeLogger;
import latitude.framework.LatitudeProxy;
import latitude.utils.DateUtils;
import latitude.utils.FileUtils;
import latitude.utils.ListUtils;
import latitude.utils.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public class AutorouteProxy
extends LatitudeProxy {
    private String gtfsPath;
    private GTFSDatasetBean gtfsDatasetBean;

    public AutorouteProxy(LatitudeLogger log, String gtfsPath) throws LatitudeException, IOException {
        this.log = log;
        this.gtfsPath = gtfsPath;
        GTFSFileReaderProxy gtfsFileReaderProxy = new GTFSFileReaderProxy(log, this.gtfsPath);
        this.gtfsDatasetBean = gtfsFileReaderProxy.loadGTFSDataset();
    }

    public void convertGTFSToAutoroute(String autoroutePath) throws LatitudeException, IOException {
        int devis = 0;
        int totalNLines = 0;
        int totalNSubLines = 0;
        ArrayList<JSONObject> lineObjects = new ArrayList<JSONObject>();
        CSVFile reportFile = new CSVFile();
        reportFile.addColumn("reseau");
        reportFile.addColumn("route_id");
        reportFile.addColumn("nom");
        reportFile.addColumn("sous_lignes");
        for (Map.Entry<String, GTFSRouteBean> routeEntry : this.gtfsDatasetBean.gtfsRouteMap.entrySet()) {
            GTFSRouteBean routeBean = routeEntry.getValue();
            String routeId = routeBean.routeId;
            if (routeBean.routeType != 3 && routeBean.routeType != 0) continue;
            String linePath = String.valueOf(autoroutePath) + "/" + StringUtils.makeSafeForFilename(routeId, false);
            new File(linePath).mkdirs();
            HashMap<String, String> stopSequenceDictionary = new HashMap<String, String>();
            JSONArray forwardArray = new JSONArray();
            JSONArray backwardArray = new JSONArray();
            JSONObject stopSequencesObject = new JSONObject();
            JSONObject tripIdsObject = new JSONObject();
            for (Map.Entry<String, GTFSTripBean> tripEntry : this.gtfsDatasetBean.gtfsTripMap.entrySet()) {
                String tripId;
                GTFSStopTimeBean stopTimeBean;
                GTFSTripBean tripBean = tripEntry.getValue();
                if (!tripBean.routeId.equals(routeId) || (stopTimeBean = this.gtfsDatasetBean.gtfsStopTimeMap.get(tripId = tripBean.tripId)) == null) continue;
                List<GTFSTripStopTimeBean> gtfsTripStopTimes = stopTimeBean.gtfsTripStopTimes;
                ArrayList<String> stopIds = new ArrayList<String>();
                for (GTFSTripStopTimeBean tripStopTimeBean : gtfsTripStopTimes) {
                    stopIds.add(tripStopTimeBean.stopId);
                }
                String stopSequenceKey = ListUtils.listToString(stopIds, ";");
                String shapeId = null;
                if (!stopSequenceDictionary.containsKey(stopSequenceKey)) {
                    shapeId = tripBean.directionId ? String.valueOf(routeId) + "_" + (backwardArray.size() + 1) + "_1" : String.valueOf(routeId) + "_" + (forwardArray.size() + 1) + "_0";
                    shapeId = StringUtils.makeSafeForFilename(shapeId, false);
                    stopSequenceDictionary.put(stopSequenceKey, shapeId);
                    JSONArray stopSequenceArray = new JSONArray();
                    stopSequenceArray.addAll(stopIds);
                    stopSequencesObject.put(shapeId, stopSequenceArray);
                    JSONArray tripIdsArray = new JSONArray();
                    tripIdsArray.add(tripId);
                    tripIdsObject.put(shapeId, tripIdsArray);
                } else {
                    ((JSONArray)tripIdsObject.get(stopSequenceDictionary.get(stopSequenceKey))).add(tripId);
                }
                if (shapeId == null) continue;
                JSONObject dataJSON = new JSONObject();
                int i = 0;
                while (i < gtfsTripStopTimes.size()) {
                    String stopId = gtfsTripStopTimes.get((int)i).stopId;
                    GTFSStopBean stopBean = this.gtfsDatasetBean.gtfsStopMap.get(stopId);
                    if (stopBean != null) {
                        ArrayList<String> previousStopIds = new ArrayList<String>();
                        ArrayList<String> nextStopIds = new ArrayList<String>();
                        if (i > 0) {
                            previousStopIds.add(gtfsTripStopTimes.get((int)(i - 1)).stopId);
                        }
                        if (i < gtfsTripStopTimes.size() - 1) {
                            nextStopIds.add(gtfsTripStopTimes.get((int)(i + 1)).stopId);
                        }
                        JSONObject stopObject = this.createStopObject(stopBean, previousStopIds, nextStopIds, null);
                        dataJSON.put(stopBean.stopId, stopObject);
                    }
                    ++i;
                }
                String jsonFilePath = String.valueOf(linePath) + "/" + shapeId + ".json";
                FileUtils.stringToFile(jsonFilePath, dataJSON.toJSONString());
                if (tripBean.directionId) {
                    backwardArray.add(shapeId);
                } else {
                    forwardArray.add(shapeId);
                }
                this.log.info(jsonFilePath);
            }
            this.log.info("Ecriture du fichier de description de la ligne");
            JSONObject aboutObject = new JSONObject();
            aboutObject.put("adminId", routeId);
            aboutObject.put("baseGeoJSON", "");
            JSONArray commercialLineArray = new JSONArray();
            JSONObject commercialLineObject = new JSONObject();
            commercialLineObject.put("name", routeBean.routeId);
            commercialLineObject.put("libelle", routeBean.routeShortName);
            commercialLineObject.put("operator", this.gtfsDatasetBean.getAgencyName(routeBean.agencyId));
            commercialLineObject.put("network", routeBean.agencyId);
            commercialLineObject.put("forward", forwardArray);
            commercialLineObject.put("backward", backwardArray);
            commercialLineArray.add(commercialLineObject);
            aboutObject.put("commercialLines", commercialLineArray);
            aboutObject.put("tripIds", tripIdsObject);
            aboutObject.put("stopSequences", stopSequencesObject);
            String aboutFilePath = String.valueOf(linePath) + "/about.json";
            FileUtils.stringToFile(aboutFilePath, aboutObject.toString());
            this.log.title(aboutFilePath);
            int nSubLines = stopSequenceDictionary.size();
            String networkName = this.gtfsDatasetBean.getAgencyName(routeBean.agencyId);
            JSONObject lineObject = new JSONObject();
            lineObject.put("network", networkName);
            lineObject.put("routeId", routeBean.routeId);
            lineObject.put("lineName", routeBean.routeShortName);
            lineObject.put("nSubLines", nSubLines);
            lineObjects.add(lineObject);
            reportFile.addLine();
            reportFile.setAttrValue("reseau", networkName);
            reportFile.setAttrValue("route_id", routeBean.routeId);
            reportFile.setAttrValue("nom", routeBean.routeShortName);
            reportFile.setAttrValue("sous_lignes", String.valueOf(nSubLines));
            ++totalNLines;
            totalNSubLines += nSubLines;
            if (nSubLines <= 4) {
                devis += 30;
            }
            if (nSubLines >= 5 && nSubLines <= 9) {
                devis += 40;
            }
            if (nSubLines >= 10 && nSubLines <= 19) {
                devis += 60;
            }
            if (nSubLines < 20) continue;
            devis += 80;
        }
        Collections.sort(lineObjects, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject l1, JSONObject l2) {
                return StringUtils.compareLineNames((String)l1.get("lineName"), (String)l2.get("lineName"), true);
            }
        });
        JSONObject aboutGTFS = new JSONObject();
        JSONArray lineArray = new JSONArray();
        for (JSONObject lineObject : lineObjects) {
            lineArray.add(lineObject);
        }
        aboutGTFS.put("lines", lineArray);
        FileUtils.stringToFile(String.valueOf(autoroutePath) + "/about.json", aboutGTFS.toString());
        reportFile.write(String.valueOf(autoroutePath) + "/report" + DateUtils.getDateAndTimeForPath() + ".csv");
        this.log.info("");
        this.log.info(String.valueOf(totalNLines) + " lignes de bus (pas de m\u00e9tro, tram, train, ...)");
        this.log.info(String.valueOf(totalNSubLines) + " sous-lignes en tout");
        this.log.info("devis \u00e9valu\u00e9 \u00e0 " + devis);
    }

    public AutorouteProxyResult convertGTFSToAutorouteForIDFM(String autoroutePath, IDFMIlicoAdminLineBean adminLineBean, String baseGeojsonFilename) throws LatitudeException, IOException {
        AutorouteProxyResult autorouteProxyResult = new AutorouteProxyResult();
        JSONArray commercialLineArray = new JSONArray();
        JSONObject stopSequencesObject = new JSONObject();
        JSONObject tripIdsObject = new JSONObject();
        for (Map.Entry<String, GTFSRouteBean> routeEntry : this.gtfsDatasetBean.gtfsRouteMap.entrySet()) {
            GTFSRouteBean routeBean = routeEntry.getValue();
            String routeId = routeBean.routeId;
            boolean keepThisRoute = false;
            String url = "";
            for (IDFMIlicoCommercialLineBean comLineBean : adminLineBean.commercialLines) {
                if (!routeId.startsWith(comLineBean.codeTechnique)) continue;
                keepThisRoute = true;
                url = comLineBean.schematicMapUrl;
                break;
            }
            if (!keepThisRoute || routeBean.routeType != 3) continue;
            autorouteProxyResult.routeIds.add(routeId);
            autorouteProxyResult.shapeByRouteMap.put(routeId, new ArrayList());
            HashMap<String, String> stopSequenceDictionary = new HashMap<String, String>();
            JSONArray forwardArray = new JSONArray();
            JSONArray backwardArray = new JSONArray();
            for (Map.Entry<String, GTFSTripBean> tripEntry : this.gtfsDatasetBean.gtfsTripMap.entrySet()) {
                String tripId;
                GTFSStopTimeBean stopTimeBean;
                GTFSTripBean tripBean = tripEntry.getValue();
                if (!tripBean.routeId.equals(routeId) || (stopTimeBean = this.gtfsDatasetBean.gtfsStopTimeMap.get(tripId = tripBean.tripId)) == null) continue;
                List<GTFSTripStopTimeBean> gtfsTripStopTimes = stopTimeBean.gtfsTripStopTimes;
                ArrayList<String> stopIds = new ArrayList<String>();
                for (GTFSTripStopTimeBean tripStopTimeBean : gtfsTripStopTimes) {
                    stopIds.add(tripStopTimeBean.stopId);
                }
                String stopSequenceKey = ListUtils.listToString(stopIds, ";");
                String shapeId = null;
                if (!stopSequenceDictionary.containsKey(stopSequenceKey)) {
                    shapeId = tripBean.directionId ? String.valueOf(routeId) + "_" + (backwardArray.size() + 1) + "_1" : String.valueOf(routeId) + "_" + (forwardArray.size() + 1) + "_0";
                    shapeId = StringUtils.makeSafeForFilename(shapeId, false);
                    stopSequenceDictionary.put(stopSequenceKey, shapeId);
                    JSONArray stopSequenceArray = new JSONArray();
                    stopSequenceArray.addAll(stopIds);
                    stopSequencesObject.put(shapeId, stopSequenceArray);
                    JSONArray tripIdsArray = new JSONArray();
                    tripIdsArray.add(tripId);
                    tripIdsObject.put(shapeId, tripIdsArray);
                } else {
                    ((JSONArray)tripIdsObject.get(stopSequenceDictionary.get(stopSequenceKey))).add(tripId);
                }
                if (shapeId == null) continue;
                JSONObject dataJSON = new JSONObject();
                int i = 0;
                while (i < gtfsTripStopTimes.size()) {
                    String stopId = gtfsTripStopTimes.get((int)i).stopId;
                    GTFSStopBean stopBean = this.gtfsDatasetBean.gtfsStopMap.get(stopId);
                    if (stopBean != null) {
                        ArrayList<String> previousStopIds = new ArrayList<String>();
                        ArrayList<String> nextStopIds = new ArrayList<String>();
                        if (i > 0) {
                            previousStopIds.add(gtfsTripStopTimes.get((int)(i - 1)).stopId);
                        }
                        if (i < gtfsTripStopTimes.size() - 1) {
                            nextStopIds.add(gtfsTripStopTimes.get((int)(i + 1)).stopId);
                        }
                        if (dataJSON.containsKey(stopId)) {
                            this.updateStopObject((JSONObject)dataJSON.get(stopId), previousStopIds, nextStopIds);
                        } else {
                            JSONObject stopObject = this.createStopObject(stopBean, previousStopIds, nextStopIds, null);
                            dataJSON.put(stopBean.stopId, stopObject);
                        }
                    }
                    ++i;
                }
                String jsonFilePath = String.valueOf(autoroutePath) + "/" + shapeId + ".json";
                autorouteProxyResult.shapeIds.add(shapeId);
                autorouteProxyResult.shapeByRouteMap.get(routeId).add(shapeId);
                FileUtils.stringToFile(jsonFilePath, dataJSON.toJSONString());
                if (tripBean.directionId) {
                    backwardArray.add(shapeId);
                } else {
                    forwardArray.add(shapeId);
                }
                this.log.info(jsonFilePath);
            }
            JSONObject commercialLineObject = new JSONObject();
            commercialLineObject.put("name", routeBean.routeId);
            commercialLineObject.put("libelle", routeBean.routeShortName);
            commercialLineObject.put("operator", this.gtfsDatasetBean.getAgencyName(routeBean.agencyId));
            commercialLineObject.put("network", routeBean.agencyId);
            commercialLineObject.put("forward", forwardArray);
            commercialLineObject.put("backward", backwardArray);
            commercialLineObject.put("url", url);
            commercialLineArray.add(commercialLineObject);
        }
        JSONObject aboutObject = new JSONObject();
        aboutObject.put("adminId", adminLineBean.codeAdministratif);
        aboutObject.put("baseGeoJSON", baseGeojsonFilename);
        aboutObject.put("commercialLines", commercialLineArray);
        aboutObject.put("tripIds", tripIdsObject);
        aboutObject.put("stopSequences", stopSequencesObject);
        String aboutFilePath = String.valueOf(autoroutePath) + "/about.json";
        FileUtils.stringToFile(aboutFilePath, aboutObject.toString());
        this.log.title(aboutFilePath);
        return autorouteProxyResult;
    }

    public void updateFromGtfs(String updateFromGtfsPath) throws IOException, LatitudeException, ParseException {
        this.log.info("Mise \u00e0 jour \u00e0 partir du GTFS : " + updateFromGtfsPath);
        GTFSFileReaderProxy updateFromGtfsFileReaderProxy = new GTFSFileReaderProxy(this.log, updateFromGtfsPath);
        GTFSDatasetBean updateFromGtfsDatasetBean = updateFromGtfsFileReaderProxy.loadGTFSDataset();
        String fromAutoroutePath = String.valueOf(updateFromGtfsPath.replace(".zip", "")) + "/autoroute";
        String toAutoroutePath = String.valueOf(this.gtfsPath.replace(".zip", "")) + "/autoroute";
        List<String> lines = FileUtils.getFolderNamesFromFolder(toAutoroutePath);
        for (String line : lines) {
            if (!new File(String.valueOf(fromAutoroutePath) + "/" + line).exists()) continue;
            String fromAbout = String.valueOf(fromAutoroutePath) + "/" + line + "/about.json";
            String toAbout = String.valueOf(toAutoroutePath) + "/" + line + "/about.json";
            JSONParser parser = new JSONParser();
            JSONObject fromAboutObject = (JSONObject)parser.parse(FileUtils.fileToString(new File(fromAbout)));
            JSONObject jSONObject = (JSONObject)parser.parse(FileUtils.fileToString(new File(toAbout)));
        }
    }

    public String convertAutorouteToGTFS(String autoroutePath, String destGTFSPath) throws IOException, ParseException, LatitudeException {
        this.log.info("convertAutorouteToGTFS");
        JSONParser jsonParser = new JSONParser();
        GeoJSONReaderJTS geoJSONReaderJTS = new GeoJSONReaderJTS();
        this.log.info("mise \u00e0 jour des shapeIds dans les trips \u00e0 partir du about.json");
        List<String> routeIds = FileUtils.getFolderNamesFromFolder(autoroutePath);
        for (String routeId : routeIds) {
            String linePath = String.valueOf(autoroutePath) + "/" + routeId;
            String aboutStr = FileUtils.fileToString(new File(String.valueOf(linePath) + "/about.json"));
            JSONObject aboutObject = (JSONObject)jsonParser.parse(aboutStr);
            JSONObject tripIdsObject = (JSONObject)aboutObject.get("tripIds");
            for (Object shapeIdO : tripIdsObject.keySet()) {
                String shapeId = (String)shapeIdO;
                JSONArray tripIds = (JSONArray)tripIdsObject.get(shapeId);
                int t = 0;
                while (t < tripIds.size()) {
                    String tripId = (String)tripIds.get(t);
                    GTFSTripBean tripBean = this.gtfsDatasetBean.gtfsTripMap.get(tripId);
                    if (tripBean != null) {
                        tripBean.shapeId = shapeId;
                    }
                    ++t;
                }
            }
        }
        this.log.info("cr\u00e9ation des shapes");
        if (this.gtfsDatasetBean.gtfsShapeMap != null) {
            this.gtfsDatasetBean.gtfsShapeMap.clear();
        } else {
            this.gtfsDatasetBean.gtfsShapeMap = new LinkedHashMap<String, GTFSShapeBean>();
        }
        List<String> geojsonFilePaths = FileUtils.getFilePathsFromFolderRecursively(autoroutePath, "geojson");
        this.log.info(String.valueOf(geojsonFilePaths.size()) + " geojsons trouv\u00e9s");
        for (String geojsonFilePath : geojsonFilePaths) {
            File geojsonFile = new File(geojsonFilePath);
            String shapeId = geojsonFile.getName().replace(".geojson", "");
            List<GeoJSONFeatureBeanJTS> features = geoJSONReaderJTS.readGeoJSON(geojsonFile);
            if (features.size() != 1) {
                throw new LatitudeException("erreur de format geojson autoroute : 1 seule entit\u00e9 attendue");
            }
            GeoJSONFeatureBeanJTS feature = features.get(0);
            if (!(feature.geometry instanceof LineString)) {
                throw new LatitudeException("erreur de format geojson autoroute : linestring attendue");
            }
            LineString lineString = (LineString)feature.geometry;
            GTFSShapeBean shapeBean = new GTFSShapeBean();
            shapeBean.shapeId = shapeId;
            int p = 0;
            while (p < lineString.getNumPoints()) {
                Point point = lineString.getPointN(p);
                GTFSShapePointBean pointBean = new GTFSShapePointBean();
                pointBean.shapePtSequence = p + 1;
                pointBean.shapePtLon = point.getX();
                pointBean.shapePtLat = point.getY();
                shapeBean.gtfsShapePoints.add(pointBean);
                ++p;
            }
            this.log.info("adding shape_id " + shapeId);
            this.gtfsDatasetBean.gtfsShapeMap.put(shapeId, shapeBean);
        }
        GTFSFileWriterProxy gtfsFileWriterProxy = new GTFSFileWriterProxy(this.log, destGTFSPath);
        gtfsFileWriterProxy.writeGTFSDataset(this.gtfsDatasetBean, false);
        return destGTFSPath;
    }

    private JSONObject createStopObject(GTFSStopBean stopBean, List<String> previousStopIds, List<String> nextStopIds, List<List<String>> paths) {
        JSONObject stopObject = new JSONObject();
        stopObject.put("id", stopBean.stopId);
        stopObject.put("name", stopBean.stopName);
        stopObject.put("lat", stopBean.stopLat);
        stopObject.put("lng", stopBean.stopLon);
        stopObject.put("type", "stop");
        JSONArray previousArray = new JSONArray();
        for (String id : previousStopIds) {
            previousArray.add(id);
        }
        stopObject.put("previous", previousArray);
        JSONArray nextArray = new JSONArray();
        JSONArray pathArray = new JSONArray();
        int n = 0;
        while (n < nextStopIds.size()) {
            nextArray.add(nextStopIds.get(n));
            JSONObject pathObject = new JSONObject();
            pathObject.put("mode", "bus");
            if (paths != null) {
                List<String> nextPaths = paths.get(n);
                JSONArray nextPathArray = new JSONArray();
                int p = 0;
                while (p < nextPaths.size()) {
                    nextPathArray.add(nextPaths.get(p));
                    ++p;
                }
                pathObject.put("pathIds", nextPathArray);
            }
            pathArray.add(pathObject);
            ++n;
        }
        stopObject.put("next", nextArray);
        stopObject.put("paths", pathArray);
        return stopObject;
    }

    private void updateStopObject(JSONObject stopObject, List<String> previousStopIds, List<String> nextStopIds) {
        JSONArray previous = (JSONArray)stopObject.get("previous");
        JSONArray next = (JSONArray)stopObject.get("next");
        for (String id : previousStopIds) {
            if (previous.contains(id)) continue;
            previous.add(id);
        }
        for (String id : nextStopIds) {
            if (next.contains(id)) continue;
            next.add(id);
            JSONArray paths = (JSONArray)stopObject.get("paths");
            JSONObject pathObject = new JSONObject();
            pathObject.put("mode", "bus");
            paths.add(pathObject);
        }
        stopObject.put("previous", previous);
        stopObject.put("next", next);
    }
}

