/*
 * Decompiled with CFR 0.152.
 */
package latitude.data.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import latitude.framework.LatitudeProxy;
import latitude.utils.DateUtils;
import latitude.utils.FileUtils;

public class CSVFile
extends LatitudeProxy {
    public static String CSV_FIELD_NAME_XY = "XY";
    public static String CSV_FIELD_NAME_LONGLAT = "LL";
    public static String SEPARATOR_COMMA = ",";
    public static String SEPARATOR_SEMICOLON = ";";
    private String path;
    private String filename;
    private Map<String, Integer> colsMap = new HashMap<String, Integer>();
    private List<String[]> attrs = new ArrayList<String[]>();
    private Iterator<String[]> iterator;
    private String[] attr;
    private String separator = SEPARATOR_SEMICOLON;

    public CSVFile(String path, String filename) {
        this.path = path;
        this.filename = filename;
    }

    public CSVFile(File file) {
        this.path = file.getParent();
        this.filename = file.getName();
    }

    public CSVFile(String filePath) {
        this(new File(filePath));
    }

    public CSVFile(CSVFile originCSVFile) {
        this.colsMap = originCSVFile.colsMap;
    }

    public CSVFile() {
    }

    public void read(boolean ansi) {
        BufferedReader reader = null;
        try {
            File csvFile = new File(String.valueOf(this.path) + "/" + this.filename);
            if (!csvFile.exists()) {
                return;
            }
            try {
                String line;
                reader = ansi ? FileUtils.openANSIFile(csvFile) : FileUtils.openUTF8File(csvFile);
                String splitExpression = "";
                boolean first = true;
                while ((line = reader.readLine()) != null) {
                    if (first) {
                        first = false;
                        this.separator = SEPARATOR_COMMA;
                        if (line.contains(SEPARATOR_SEMICOLON)) {
                            this.separator = SEPARATOR_SEMICOLON;
                        } else if (line.contains(SEPARATOR_COMMA)) {
                            this.separator = SEPARATOR_COMMA;
                        }
                        splitExpression = String.valueOf(this.separator) + "(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
                        this.colsMap = this.loadCols(line, this.separator);
                        continue;
                    }
                    String[] attr = line.split(splitExpression, -1);
                    int a = 0;
                    while (a < attr.length) {
                        attr[a] = attr[a].replace("\"", "").trim();
                        ++a;
                    }
                    this.attrs.add(attr);
                }
                this.log.info("[CSV] " + this.filename + "\t" + this.attrs.size() + " entr\u00e9es");
                this.reset();
            }
            catch (Exception e) {
                this.log.error(e.getMessage());
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                this.log.error(e.getMessage());
            }
        }
    }

    public boolean isNull() {
        return this.attrs.size() == 0;
    }

    public int size() {
        return this.attrs.size();
    }

    public void reset() {
        this.iterator = this.attrs.iterator();
    }

    public boolean next() {
        if (this.iterator.hasNext()) {
            this.attr = this.iterator.next();
            return true;
        }
        return false;
    }

    public File write() throws FileNotFoundException, UnsupportedEncodingException {
        return this.write(String.valueOf(this.path) + "/" + this.filename);
    }

    public File write(String csvFilePath) throws FileNotFoundException, UnsupportedEncodingException {
        ArrayList<String> stringArray = new ArrayList<String>();
        String[] cols = new String[this.colsMap.size()];
        for (Map.Entry<String, Integer> colsEntry : this.colsMap.entrySet()) {
            cols[colsEntry.getValue().intValue()] = colsEntry.getKey();
        }
        String colsStr = "";
        int c = 0;
        while (c < cols.length) {
            colsStr = String.valueOf(colsStr) + cols[c];
            if (c < cols.length - 1) {
                colsStr = String.valueOf(colsStr) + this.separator;
            }
            ++c;
        }
        stringArray.add(colsStr);
        for (String[] attr : this.attrs) {
            String values = "";
            int a = 0;
            while (a < attr.length) {
                String value = attr[a];
                if (value != null) {
                    values = String.valueOf(values) + value;
                }
                if (a < attr.length - 1) {
                    values = String.valueOf(values) + this.separator;
                }
                ++a;
            }
            stringArray.add(values);
        }
        return FileUtils.arrayToFile(csvFilePath, stringArray, "UTF-8");
    }

    public boolean checkColumnsExistance(String[] colNames) {
        boolean checked = true;
        String[] stringArray = colNames;
        int n = colNames.length;
        int n2 = 0;
        while (n2 < n) {
            String colName = stringArray[n2];
            if (!this.colsMap.containsKey(colName)) {
                this.log.warn("La colonne " + colName + " n'existe pas");
                checked = false;
            }
            ++n2;
        }
        return checked;
    }

    public String[] getXYColNames() {
        String xColName = null;
        String yColName = null;
        boolean isLongLat = false;
        for (String colName : this.colsMap.keySet()) {
            String col = colName.toLowerCase().trim();
            if (col.equals("x") || col.equals("coordx") || col.equals("coo_x")) {
                xColName = colName;
                isLongLat = false;
                continue;
            }
            if (col.equals("y") || col.equals("coordy") || col.equals("coo_y")) {
                yColName = colName;
                isLongLat = false;
                continue;
            }
            if (col.equals("longitude")) {
                xColName = colName;
                isLongLat = true;
                continue;
            }
            if (!col.equals("latitude")) continue;
            yColName = colName;
            isLongLat = true;
        }
        String[] retValue = new String[]{xColName, yColName, isLongLat ? CSV_FIELD_NAME_LONGLAT : CSV_FIELD_NAME_XY};
        return retValue;
    }

    public void addColumn(String colName) {
        this.colsMap.put(colName, this.colsMap.size());
        int nCols = this.colsMap.size();
        int i = this.attrs.size() - 1;
        while (i >= 0) {
            String[] newattr = Arrays.copyOf(this.attrs.get(i), nCols);
            this.attrs.set(i, newattr);
            --i;
        }
    }

    public String getAttrValue(String colName) {
        int colId;
        if (this.colsMap.containsKey(colName) && (colId = this.colsMap.get(colName).intValue()) < this.attr.length) {
            return this.attr[colId];
        }
        return "";
    }

    public int getIntAttrValue(String colName) {
        String attrValue = this.getAttrValue(colName);
        if (attrValue.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(attrValue);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public double getDoubleAttrValue(String colName) {
        String attrValue = this.getAttrValue(colName);
        if (attrValue.isEmpty()) {
            return 0.0;
        }
        attrValue = attrValue.replace(",", ".").replace(" ", "").trim();
        try {
            return Double.parseDouble(attrValue);
        }
        catch (NumberFormatException e) {
            this.log.warn("Bad value : " + attrValue);
            return 0.0;
        }
    }

    public boolean getBoolAttrValue(String colName) {
        String attrValue = this.getAttrValue(colName);
        if (attrValue.isEmpty()) {
            return false;
        }
        return attrValue.equals("1") || attrValue.toLowerCase().trim().equals("true") || attrValue.toLowerCase().trim().startsWith("o") || attrValue.toLowerCase().trim().startsWith("y");
    }

    public Date getDateAttrValue(String colName, String dateFormat) throws ParseException {
        String attrValue = this.getAttrValue(colName);
        return DateUtils.parseDate(attrValue, dateFormat);
    }

    public void setAttrValue(String colName, String value) {
        int colId;
        if (this.colsMap.containsKey(colName) && (colId = this.colsMap.get(colName).intValue()) < this.attr.length) {
            boolean guillemets = value != null && (value.contains(SEPARATOR_COMMA) || value.contains(SEPARATOR_SEMICOLON));
            this.attr[colId] = String.valueOf(guillemets ? "\"" : "") + value + (guillemets ? "\"" : "");
        }
    }

    public void setDoubleAttrValue(String colName, double value) {
        int colId;
        if (this.colsMap.containsKey(colName) && (colId = this.colsMap.get(colName).intValue()) < this.attr.length) {
            this.attr[colId] = String.valueOf(value);
        }
    }

    public void setIntAttrValue(String colName, int value) {
        int colId;
        if (this.colsMap.containsKey(colName) && (colId = this.colsMap.get(colName).intValue()) < this.attr.length) {
            this.attr[colId] = String.valueOf(value);
        }
    }

    public void setBoolAttrValue(String colName, boolean value) {
        int colId;
        if (this.colsMap.containsKey(colName) && (colId = this.colsMap.get(colName).intValue()) < this.attr.length) {
            this.attr[colId] = value ? "1" : "0";
        }
    }

    public void addLine() {
        this.attr = new String[this.colsMap.size()];
        this.attrs.add(this.attr);
    }

    public void addCurrentLine(CSVFile otherCSVFile) {
        this.attrs.add(otherCSVFile.attr);
    }

    private Map<String, Integer> loadCols(String firstLine, String splitExpression) {
        String[] cols = firstLine.split(splitExpression, -1);
        HashMap<String, Integer> colsMap = new HashMap<String, Integer>();
        int i = 0;
        while (i < cols.length) {
            colsMap.put(cols[i].trim(), i);
            ++i;
        }
        return colsMap;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

