/*
 * Decompiled with CFR 0.152.
 */
package latitude.data.csv;

import java.io.BufferedReader;
import java.io.File;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import latitude.framework.LatitudeProxy;
import latitude.utils.DateUtils;
import latitude.utils.FileUtils;

public class CSVFileSuperReader
extends LatitudeProxy {
    public static String CSV_FIELD_NAME_XY = "XY";
    public static String CSV_FIELD_NAME_LONGLAT = "LL";
    private String path;
    private String filename;
    private boolean bigFile;
    private String line;
    private int nLines;
    private BufferedReader reader;
    private String splitExpression = "";
    private String[] attr;
    private Map<String, Integer> colsMap = new HashMap<String, Integer>();

    public CSVFileSuperReader(String path, String filename) {
        this.path = path;
        this.filename = filename;
    }

    public CSVFileSuperReader(File file) {
        this.path = file.getParent();
        this.filename = file.getName();
    }

    public CSVFileSuperReader(String filePath) {
        this(new File(filePath));
    }

    public void read(boolean ansi) {
        try {
            File csvFile = new File(String.valueOf(this.path) + "/" + this.filename);
            this.log.info("[CSV] " + this.filename + (this.bigFile ? " (BIG)" : ""));
            if (!csvFile.exists()) {
                return;
            }
            this.reader = ansi ? FileUtils.openANSIFile(csvFile) : FileUtils.openUTF8File(csvFile);
            this.line = this.reader.readLine();
            if (this.line != null) {
                String separator = ",";
                if (this.line.contains(";")) {
                    separator = ";";
                } else if (this.line.contains(",")) {
                    separator = ",";
                }
                this.splitExpression = separator;
                if (!this.bigFile) {
                    separator = String.valueOf(separator) + "(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
                }
                this.colsMap = this.loadCols(this.line, separator);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
    }

    public boolean isNull() {
        return this.colsMap == null || this.colsMap.size() == 0;
    }

    public int size() {
        return this.colsMap.size();
    }

    public boolean next() {
        block5: {
            this.line = this.reader.readLine();
            if (this.line == null) break block5;
            this.attr = this.line.split(this.splitExpression, -1);
            int a = 0;
            while (a < this.attr.length) {
                this.attr[a] = this.attr[a].replace("\"", "").trim();
                ++a;
            }
            ++this.nLines;
            if (this.nLines % 1000000 == 0) {
                this.log.info(String.valueOf(this.nLines) + " lignes lues");
            }
            return true;
        }
        try {
            this.reader.close();
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        return false;
    }

    public boolean checkColumnsExistance(String[] colNames) {
        boolean checked = true;
        String[] stringArray = colNames;
        int n = colNames.length;
        int n2 = 0;
        while (n2 < n) {
            String colName = stringArray[n2];
            if (!this.colsMap.containsKey(colName)) {
                this.log.warn("La colonne " + colName + " n'existe pas");
                checked = false;
            }
            ++n2;
        }
        return checked;
    }

    public String[] getXYColNames() {
        String xColName = null;
        String yColName = null;
        boolean isLongLat = false;
        for (String colName : this.colsMap.keySet()) {
            String col = colName.toLowerCase().trim();
            if (col.equals("x") || col.equals("coordx") || col.equals("coo_x")) {
                xColName = colName;
                isLongLat = false;
                continue;
            }
            if (col.equals("y") || col.equals("coordy") || col.equals("coo_y")) {
                yColName = colName;
                isLongLat = false;
                continue;
            }
            if (col.equals("longitude")) {
                xColName = colName;
                isLongLat = true;
                continue;
            }
            if (!col.equals("latitude")) continue;
            yColName = colName;
            isLongLat = true;
        }
        String[] retValue = new String[]{xColName, yColName, isLongLat ? CSV_FIELD_NAME_LONGLAT : CSV_FIELD_NAME_XY};
        return retValue;
    }

    public String getAttrValue(String colName) {
        int colId;
        if (this.colsMap.containsKey(colName) && (colId = this.colsMap.get(colName).intValue()) < this.attr.length) {
            return this.attr[colId];
        }
        return "";
    }

    public int getIntAttrValue(String colName) {
        String attrValue = this.getAttrValue(colName);
        if (attrValue.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(attrValue);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public double getDoubleAttrValue(String colName) {
        String attrValue = this.getAttrValue(colName);
        if (attrValue.isEmpty()) {
            return 0.0;
        }
        return Double.parseDouble(attrValue.replace(",", ".").replace(" ", "").trim());
    }

    public boolean getBoolAttrValue(String colName) {
        String attrValue = this.getAttrValue(colName);
        if (attrValue.isEmpty()) {
            return false;
        }
        return attrValue.equals("1") || attrValue.toLowerCase().trim().equals("true") || attrValue.toLowerCase().trim().startsWith("o");
    }

    public Date getDateAttrValue(String colName, String dateFormat) throws ParseException {
        String attrValue = this.getAttrValue(colName);
        return DateUtils.parseDate(attrValue, dateFormat);
    }

    private Map<String, Integer> loadCols(String firstLine, String splitExpression) {
        String[] cols = firstLine.split(splitExpression, -1);
        HashMap<String, Integer> colsMap = new HashMap<String, Integer>();
        int i = 0;
        while (i < cols.length) {
            colsMap.put(cols[i].trim(), i);
            ++i;
        }
        return colsMap;
    }

    public boolean isBigFile() {
        return this.bigFile;
    }

    public void setBigFile(boolean bigFile) {
        this.bigFile = bigFile;
    }
}

