/*
 * Decompiled with CFR 0.152.
 */
package latitude.data.geojson;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import latitude.data.geojson.GeoJSONFeatureBeanJTS;
import latitude.framework.LatitudeException;
import latitude.framework.LatitudeProxy;
import latitude.utils.FileUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;

public class GeoJSONReaderJTS
extends LatitudeProxy {
    public GeometryFactory geometryFactory = new GeometryFactory();

    public List<GeoJSONFeatureBeanJTS> readGeoJSON(File file) throws IOException, LatitudeException, ParseException {
        ArrayList<GeoJSONFeatureBeanJTS> features = new ArrayList<GeoJSONFeatureBeanJTS>();
        String geojsonStr = FileUtils.fileToString(file);
        JSONParser parser = new JSONParser();
        JSONObject geoJSONObject = (JSONObject)parser.parse(geojsonStr);
        JSONArray featuresArray = (JSONArray)geoJSONObject.get("features");
        int f = 0;
        while (f < featuresArray.size()) {
            JSONObject featureObject = (JSONObject)featuresArray.get(f);
            JSONObject geometryObject = (JSONObject)featureObject.get("geometry");
            GeoJSONFeatureBeanJTS featureBean = new GeoJSONFeatureBeanJTS();
            featureBean.geometry = this.readGeometry(geometryObject);
            JSONObject propertiesObject = (JSONObject)featureObject.get("properties");
            for (String key : propertiesObject.keySet()) {
                featureBean.properties.put(key, propertiesObject.get(key));
            }
            features.add(featureBean);
            ++f;
        }
        return features;
    }

    private Geometry readGeometry(JSONObject geometryObject) throws LatitudeException, IOException {
        String type = (String)geometryObject.get("type");
        JSONArray coordinates = (JSONArray)geometryObject.get("coordinates");
        Geometry geometry = null;
        if (type.equals("Point")) {
            geometry = this.readPoint(coordinates);
        } else if (type.equals("LineString")) {
            geometry = this.readPath(coordinates);
        } else if (type.equals("MultiLineString")) {
            LineString[] lineStrings = new LineString[coordinates.size()];
            int c = 0;
            while (c < coordinates.size()) {
                LineString lineString;
                JSONArray lineStringArray = (JSONArray)coordinates.get(c);
                lineStrings[c] = lineString = this.readPath(lineStringArray);
                ++c;
            }
            geometry = this.geometryFactory.createMultiLineString(lineStrings);
        } else if (type.equals("Polygon")) {
            LinearRing[] linearRings = new LinearRing[coordinates.size()];
            int c = 0;
            while (c < coordinates.size()) {
                LinearRing lineString;
                JSONArray lineStringArray = (JSONArray)coordinates.get(c);
                linearRings[c] = lineString = this.readRing(lineStringArray);
                ++c;
            }
            if (linearRings.length > 1) {
                throw new LatitudeException("un seul polygon support\u00e9 TODO");
            }
            geometry = this.geometryFactory.createPolygon(linearRings[0]);
        } else {
            throw new LatitudeException("G\u00e9om\u00e9trie " + type + " non reconnue (not yet implemented)");
        }
        return geometry;
    }

    private Coordinate getCoordinate(JSONArray pointCoords) {
        return new Coordinate((Double)pointCoords.get(0), (Double)pointCoords.get(1));
    }

    private Point readPoint(JSONArray pointCoords) {
        return this.geometryFactory.createPoint(this.getCoordinate(pointCoords));
    }

    private LineString readPath(JSONArray pointArray) {
        int n = pointArray.size();
        Coordinate[] coordinates = new Coordinate[n];
        int i = 0;
        while (i < n) {
            coordinates[i] = this.getCoordinate((JSONArray)pointArray.get(i));
            ++i;
        }
        return this.geometryFactory.createLineString(coordinates);
    }

    private LinearRing readRing(JSONArray pointArray) {
        int n = pointArray.size();
        Coordinate[] coordinates = new Coordinate[n];
        int i = 0;
        while (i < n) {
            coordinates[i] = this.getCoordinate((JSONArray)pointArray.get(i));
            ++i;
        }
        return this.geometryFactory.createLinearRing(coordinates);
    }
}

