/*
 * Decompiled with CFR 0.152.
 */
package latitude.data.gtfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import latitude.data.csv.CSVFile;
import latitude.data.geojson.GeoJSONFeatureBeanJTS;
import latitude.data.geojson.GeoJSONReaderJTS;
import latitude.data.gtfs.GTFSFileReaderProxy;
import latitude.data.gtfs.GTFSFileWriterProxy;
import latitude.data.gtfs.bean.GTFSAgencyBean;
import latitude.data.gtfs.bean.GTFSCalendarBean;
import latitude.data.gtfs.bean.GTFSCalendarDateBean;
import latitude.data.gtfs.bean.GTFSDatasetBean;
import latitude.data.gtfs.bean.GTFSRouteBean;
import latitude.data.gtfs.bean.GTFSShapeBean;
import latitude.data.gtfs.bean.GTFSShapePointBean;
import latitude.data.gtfs.bean.GTFSStopBean;
import latitude.data.gtfs.bean.GTFSStopTimeBean;
import latitude.data.gtfs.bean.GTFSTransferBean;
import latitude.data.gtfs.bean.GTFSTripBean;
import latitude.data.gtfs.bean.GTFSTripStopTimeBean;
import latitude.framework.LatitudeException;
import latitude.framework.LatitudeProxy;
import latitude.utils.DateUtils;
import latitude.utils.DoubleUtils;
import latitude.utils.FileUtils;
import latitude.utils.ListUtils;
import org.json.simple.parser.ParseException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;

public class GTFSAlterationProxy
extends LatitudeProxy {
    private String inputGTFSPath;
    private String outputGTFSPath;
    private GTFSDatasetBean gtfsDatasetBean;

    public GTFSAlterationProxy(String pInputGTFSPath, String pOutputGTFSPath) throws LatitudeException, IOException {
        this.inputGTFSPath = pInputGTFSPath;
        this.outputGTFSPath = pOutputGTFSPath;
        GTFSFileReaderProxy gtfsFileReaderProxy = new GTFSFileReaderProxy(this.log, this.inputGTFSPath);
        this.gtfsDatasetBean = gtfsFileReaderProxy.loadGTFSDataset();
    }

    public GTFSAlterationProxy(GTFSDatasetBean pDatasetBean, String pOutputGTFSPath) {
        this.gtfsDatasetBean = pDatasetBean;
        this.outputGTFSPath = pOutputGTFSPath;
    }

    public void dissolveRouteIdsByRouteShortName(boolean withAgencyIdPrefix) throws FileNotFoundException, UnsupportedEncodingException {
        this.log.info("Mise \u00e0 jour des routes");
        HashMap<String, String> routeShortNameIdMap = new HashMap<String, String>();
        HashMap<String, String> oldNewMap = new HashMap<String, String>();
        LinkedHashMap<String, GTFSRouteBean> gtfsRouteMap = new LinkedHashMap<String, GTFSRouteBean>();
        for (Map.Entry<String, GTFSRouteBean> entry : this.gtfsDatasetBean.gtfsRouteMap.entrySet()) {
            GTFSRouteBean routeBean = entry.getValue();
            String routeId = routeBean.routeId;
            String routeName = routeBean.routeShortName;
            if (!routeShortNameIdMap.containsKey(routeName)) {
                routeShortNameIdMap.put(routeName, routeId);
                oldNewMap.put(routeId, routeId);
                gtfsRouteMap.put(routeBean.routeId, routeBean);
                continue;
            }
            routeBean.routeId = (String)routeShortNameIdMap.get(routeName);
            oldNewMap.put(routeId, routeBean.routeId);
        }
        this.gtfsDatasetBean.gtfsRouteMap = gtfsRouteMap;
        this.log.info("Mise \u00e0 jour des trips");
        for (Map.Entry<String, Object> entry : this.gtfsDatasetBean.gtfsTripMap.entrySet()) {
            GTFSTripBean tripBean = (GTFSTripBean)entry.getValue();
            tripBean.routeId = (String)oldNewMap.get(tripBean.routeId);
        }
    }

    public void updateTripNotaByDetectingStringInHeadsign(String nota) {
        for (Map.Entry<String, GTFSTripBean> tripEntry : this.gtfsDatasetBean.gtfsTripMap.entrySet()) {
            GTFSTripBean tripBean = tripEntry.getValue();
            if (!tripBean.tripHeadsign.contains(nota)) continue;
            tripBean.nota = nota;
        }
    }

    public void updateTripHeadsignsWithLastStopInfo(boolean withStopName) {
        for (Map.Entry<String, GTFSStopTimeBean> gtfsStopTimeEntry : this.gtfsDatasetBean.gtfsStopTimeMap.entrySet()) {
            GTFSStopTimeBean gtfsStopTimeBean = gtfsStopTimeEntry.getValue();
            String lastStopId = gtfsStopTimeBean.gtfsTripStopTimes.get((int)(gtfsStopTimeBean.gtfsTripStopTimes.size() - 1)).stopId;
            GTFSStopBean lastStopbean = this.gtfsDatasetBean.gtfsStopMap.get(lastStopId);
            String string = this.gtfsDatasetBean.gtfsTripMap.get((Object)gtfsStopTimeBean.tripId).tripHeadsign = withStopName ? lastStopbean.stopName : lastStopbean.stopId;
        }
    }

    public void applyStopNameDictionary(Map<String, String> stopNameMap) {
        for (Map.Entry<String, GTFSStopBean> stopEntry : this.gtfsDatasetBean.gtfsStopMap.entrySet()) {
            if (!stopNameMap.containsKey(stopEntry.getKey())) continue;
            stopEntry.getValue().stopName = stopNameMap.get(stopEntry.getKey());
        }
    }

    public void repairUnnamedRoutes(String alternativeNamePrefix) {
        int i = 0;
        for (Map.Entry<String, GTFSRouteBean> routeEntry : this.gtfsDatasetBean.gtfsRouteMap.entrySet()) {
            GTFSRouteBean routeBean = routeEntry.getValue();
            if (routeBean.routeShortName != null && routeBean.routeShortName.length() != 0) continue;
            this.log.info("La route route_id=" + routeBean.routeId + " n'avait pas de nom");
            routeBean.routeShortName = String.valueOf(alternativeNamePrefix) + ++i;
        }
    }

    public void repairUnnamedStops(String alternativeName) {
        for (Map.Entry<String, GTFSStopBean> stopEntry : this.gtfsDatasetBean.gtfsStopMap.entrySet()) {
            GTFSStopBean stopBean = stopEntry.getValue();
            if (stopBean.stopName != null && stopBean.stopName.length() != 0) continue;
            this.log.info("L'arr\u00eat stop_id=" + stopBean.stopId + " n'avait pas de nom");
            stopBean.stopName = alternativeName;
        }
    }

    public void replaceStopNameString(String search, String replace) {
        for (Map.Entry<String, GTFSStopBean> stopEntry : this.gtfsDatasetBean.gtfsStopMap.entrySet()) {
            GTFSStopBean stopBean = stopEntry.getValue();
            stopBean.stopName = stopBean.stopName.replace(search, replace);
        }
    }

    public void replaceStopIdString(String search, String replace) {
        ArrayList<String> toDeletes = new ArrayList<String>();
        ArrayList<String> toReplaces = new ArrayList<String>();
        for (Map.Entry<String, GTFSStopBean> entry : this.gtfsDatasetBean.gtfsStopMap.entrySet()) {
            String newStopId;
            GTFSStopBean stopBean = entry.getValue();
            if (!stopBean.stopId.contains(search) || !this.gtfsDatasetBean.gtfsStopMap.containsKey(newStopId = stopBean.stopId.replace(search, replace))) continue;
            toDeletes.add(stopBean.stopId);
            toReplaces.add(stopBean.stopId);
        }
        for (Map.Entry<String, Object> entry : this.gtfsDatasetBean.gtfsStopTimeMap.entrySet()) {
            GTFSStopTimeBean stopTimeBean = (GTFSStopTimeBean)entry.getValue();
            for (GTFSTripStopTimeBean tripStopTimeBean : stopTimeBean.gtfsTripStopTimes) {
                if (!toReplaces.contains(tripStopTimeBean.stopId)) continue;
                tripStopTimeBean.stopId = tripStopTimeBean.stopId.replace(search, replace);
            }
        }
        for (String string : toDeletes) {
            this.gtfsDatasetBean.gtfsStopMap.remove(string);
        }
    }

    public void filterByAgencyName(String filterAgencyName) {
        HashSet<String> toDeleteAgencies = new HashSet<String>();
        HashSet<String> toDeleteRoutes = new HashSet<String>();
        HashSet<String> toDeleteTrips = new HashSet<String>();
        HashSet<String> toDeleteShapes = new HashSet<String>();
        HashSet<String> toKeepStops = new HashSet<String>();
        HashSet<String> toKeepServices = new HashSet<String>();
        for (Map.Entry<String, GTFSAgencyBean> entry : this.gtfsDatasetBean.gtfsAgencyMap.entrySet()) {
            String agencyName = entry.getValue().agencyName;
            if (!agencyName.toLowerCase().contains(filterAgencyName.toLowerCase())) {
                this.log.info("Suppression des donn\u00e9es de l'agence " + agencyName);
                toDeleteAgencies.add(entry.getKey());
                continue;
            }
            this.log.info("Agence conserv\u00e9e : " + agencyName);
        }
        for (Map.Entry<String, Object> entry : this.gtfsDatasetBean.gtfsRouteMap.entrySet()) {
            if (!toDeleteAgencies.contains(((GTFSRouteBean)entry.getValue()).agencyId)) continue;
            toDeleteRoutes.add(entry.getKey());
        }
        for (Map.Entry<String, Object> entry : this.gtfsDatasetBean.gtfsTripMap.entrySet()) {
            GTFSTripBean tripBean = (GTFSTripBean)entry.getValue();
            if (toDeleteRoutes.contains(tripBean.routeId)) {
                toDeleteTrips.add(tripBean.tripId);
                if (tripBean.shapeId == null || tripBean.shapeId.equals("")) continue;
                toDeleteShapes.add(tripBean.shapeId);
                continue;
            }
            toKeepServices.add(tripBean.serviceId);
        }
        for (Map.Entry<String, Object> entry : this.gtfsDatasetBean.gtfsStopTimeMap.entrySet()) {
            if (toDeleteTrips.contains(((GTFSStopTimeBean)entry.getValue()).tripId)) continue;
            for (GTFSTripStopTimeBean gtfsTripStopTimeBean : ((GTFSStopTimeBean)entry.getValue()).gtfsTripStopTimes) {
                toKeepStops.add(gtfsTripStopTimeBean.stopId);
            }
        }
        this.gtfsDatasetBean.deleteAgencies(toDeleteAgencies);
        this.gtfsDatasetBean.deleteRoutes(toDeleteRoutes);
        this.gtfsDatasetBean.deleteTrips(toDeleteTrips);
        this.gtfsDatasetBean.deleteShapes(toDeleteShapes);
        this.gtfsDatasetBean.keepStops(toKeepStops);
        this.gtfsDatasetBean.keepServices(toKeepServices);
    }

    public void filterByRouteId(String filterRouteIds, boolean startsWith) {
        HashSet<String> toKeepAgencies = new HashSet<String>();
        HashSet<String> toDeleteRoutes = new HashSet<String>();
        HashSet<String> toDeleteTrips = new HashSet<String>();
        HashSet<String> toDeleteShapes = new HashSet<String>();
        HashSet<String> toKeepStops = new HashSet<String>();
        HashSet<String> toKeepServices = new HashSet<String>();
        String[] frIds = filterRouteIds.split(";", -1);
        for (Map.Entry<String, GTFSRouteBean> entry : this.gtfsDatasetBean.gtfsRouteMap.entrySet()) {
            String routeId = entry.getKey();
            boolean delete = true;
            String[] stringArray = frIds;
            int n = frIds.length;
            int n2 = 0;
            while (n2 < n) {
                String filterRouteId = stringArray[n2];
                if (startsWith && routeId.startsWith(filterRouteId) || !startsWith && routeId.equals(filterRouteId)) {
                    delete = false;
                }
                ++n2;
            }
            if (delete) {
                toDeleteRoutes.add(routeId);
                continue;
            }
            this.log.info("Conservation de la ligne id=" + routeId + " nom=" + entry.getValue().routeShortName + " agencyId=" + entry.getValue().agencyId);
            toKeepAgencies.add(entry.getValue().agencyId);
        }
        for (Map.Entry<String, Object> entry : this.gtfsDatasetBean.gtfsTripMap.entrySet()) {
            GTFSTripBean tripBean = (GTFSTripBean)entry.getValue();
            if (toDeleteRoutes.contains(tripBean.routeId)) {
                toDeleteTrips.add(entry.getKey());
                if (tripBean.shapeId == null || tripBean.shapeId.equals("")) continue;
                toDeleteShapes.add(tripBean.shapeId);
                continue;
            }
            toKeepServices.add(tripBean.serviceId);
        }
        for (Map.Entry<String, Object> entry : this.gtfsDatasetBean.gtfsStopTimeMap.entrySet()) {
            if (toDeleteTrips.contains(((GTFSStopTimeBean)entry.getValue()).tripId)) continue;
            for (GTFSTripStopTimeBean gtfsTripStopTimeBean : ((GTFSStopTimeBean)entry.getValue()).gtfsTripStopTimes) {
                toKeepStops.add(gtfsTripStopTimeBean.stopId);
            }
        }
        this.gtfsDatasetBean.deleteTrips(toDeleteTrips);
        this.gtfsDatasetBean.deleteRoutes(toDeleteRoutes);
        this.gtfsDatasetBean.deleteShapes(toDeleteShapes);
        this.gtfsDatasetBean.keepStops(toKeepStops);
        this.gtfsDatasetBean.keepAgencies(toKeepAgencies);
        this.gtfsDatasetBean.keepServices(toKeepServices);
    }

    public void filterByGeojson(String geojsonPath) throws IOException, LatitudeException, ParseException {
        this.log.info("Reading geojson");
        GeoJSONReaderJTS geoJSONReader = new GeoJSONReaderJTS();
        List<GeoJSONFeatureBeanJTS> features = geoJSONReader.readGeoJSON(new File(geojsonPath));
        this.log.info(features.size() + " features");
        HashSet<String> toKeepStops = new HashSet<String>();
        HashSet<String> toKeepTrips = new HashSet<String>();
        HashSet<String> toKeepRoutes = new HashSet<String>();
        HashSet<String> toKeepShapes = new HashSet<String>();
        HashSet<String> toKeepAgencies = new HashSet<String>();
        HashSet<String> toKeepServices = new HashSet<String>();
        this.log.info("Listing stops contained in geojson");
        GeometryFactory factory = new GeometryFactory();
        for (GeoJSONFeatureBeanJTS geoJSONFeatureBeanJTS : features) {
            for (Map.Entry<String, GTFSStopBean> stopEntry : this.gtfsDatasetBean.gtfsStopMap.entrySet()) {
                if (toKeepStops.contains(stopEntry.getKey())) continue;
                GTFSStopBean stopBean = stopEntry.getValue();
                Coordinate coordinate = new Coordinate(stopBean.stopLon, stopBean.stopLat);
                Point stopPoint = factory.createPoint(coordinate);
                if (!geoJSONFeatureBeanJTS.geometry.contains(stopPoint)) continue;
                toKeepStops.add(stopBean.stopId);
            }
        }
        this.log.info(toKeepStops.size() + " / " + this.gtfsDatasetBean.gtfsStopMap.size() + " stops kept");
        block2: for (Map.Entry entry : this.gtfsDatasetBean.gtfsStopTimeMap.entrySet()) {
            for (GTFSTripStopTimeBean gtfsTripStopTimeBean : ((GTFSStopTimeBean)entry.getValue()).gtfsTripStopTimes) {
                if (!toKeepStops.contains(gtfsTripStopTimeBean.stopId)) continue;
                toKeepTrips.add((String)entry.getKey());
                continue block2;
            }
        }
        for (Map.Entry entry : this.gtfsDatasetBean.gtfsTripMap.entrySet()) {
            if (!toKeepTrips.contains(entry.getKey())) continue;
            toKeepRoutes.add(((GTFSTripBean)entry.getValue()).routeId);
            toKeepShapes.add(((GTFSTripBean)entry.getValue()).shapeId);
            toKeepServices.add(((GTFSTripBean)entry.getValue()).serviceId);
        }
        for (Map.Entry entry : this.gtfsDatasetBean.gtfsRouteMap.entrySet()) {
            if (!toKeepRoutes.contains(entry.getKey())) continue;
            toKeepAgencies.add(((GTFSRouteBean)entry.getValue()).agencyId);
        }
        this.gtfsDatasetBean.keepStops(toKeepStops);
        this.gtfsDatasetBean.keepTrips(toKeepTrips);
        this.gtfsDatasetBean.keepRoutes(toKeepRoutes);
        this.gtfsDatasetBean.keepAgencies(toKeepAgencies);
        this.gtfsDatasetBean.keepServices(toKeepServices);
        this.gtfsDatasetBean.keepShapes(toKeepShapes);
    }

    public void addShapeFromFolder(String shapeFolderPath) {
        List<String> shapeFilePaths = FileUtils.getFilenamesFromFolder(shapeFolderPath, "txt", true);
        for (String shapeFilePath : shapeFilePaths) {
            String[] sp = new File(shapeFilePath).getName().split("_", -1);
            if (!sp[0].equals("shape") || sp.length != 3) continue;
            String routeShortName = sp[1];
            boolean directionId = sp[2].startsWith("1");
            String shapeId = "s" + routeShortName + "_" + (directionId ? "1" : "0");
            GTFSShapeBean gtfsShapeBean = new GTFSShapeBean();
            gtfsShapeBean.shapeId = shapeId;
            if (this.gtfsDatasetBean.gtfsShapeMap == null) {
                this.gtfsDatasetBean.gtfsShapeMap = new LinkedHashMap<String, GTFSShapeBean>();
            }
            this.gtfsDatasetBean.gtfsShapeMap.put(shapeId, gtfsShapeBean);
            int sequence = 1;
            CSVFile csvFile = new CSVFile(shapeFilePath);
            csvFile.read(false);
            while (csvFile.next()) {
                double lon = csvFile.getDoubleAttrValue("shape_pt_lon");
                double lat = csvFile.getDoubleAttrValue("shape_pt_lat");
                GTFSShapePointBean gtfsShapePointBean = new GTFSShapePointBean();
                gtfsShapePointBean.shapePtLon = lon;
                gtfsShapePointBean.shapePtLat = lat;
                gtfsShapePointBean.shapePtSequence = ++sequence;
                gtfsShapeBean.gtfsShapePoints.add(gtfsShapePointBean);
            }
            Set<String> routeIds = this.gtfsDatasetBean.getRouteIds(routeShortName);
            for (String routeId : routeIds) {
                for (Map.Entry<String, GTFSTripBean> tripEntry : this.gtfsDatasetBean.gtfsTripMap.entrySet()) {
                    GTFSTripBean gtfsTripBean = tripEntry.getValue();
                    if (!gtfsTripBean.routeId.equals(routeId) || gtfsTripBean.directionId != directionId) continue;
                    gtfsTripBean.shapeId = shapeId;
                }
            }
        }
    }

    public void addShapeFromGeoJSON(List<GeoJSONFeatureBeanJTS> features, String routeShortNameProperty, String directionIdProperty) {
        for (GeoJSONFeatureBeanJTS featureBean : features) {
            String routeShortName = (String)featureBean.properties.get(routeShortNameProperty);
            String directionIdValue = ((String)featureBean.properties.get(directionIdProperty)).toUpperCase();
            boolean directionId = directionIdValue.startsWith("R") || directionIdValue.startsWith("T") || directionIdValue.startsWith("1");
            LineString lineString = null;
            if (featureBean.geometry instanceof LineString) {
                lineString = (LineString)featureBean.geometry;
            }
            if (featureBean.geometry instanceof MultiLineString) {
                lineString = (LineString)((MultiLineString)featureBean.geometry).getGeometryN(0);
            }
            String shapeId = "s" + routeShortName + "_" + (directionId ? "1" : "0");
            GTFSShapeBean gtfsShapeBean = new GTFSShapeBean();
            gtfsShapeBean.shapeId = shapeId;
            if (this.gtfsDatasetBean.gtfsShapeMap == null) {
                this.gtfsDatasetBean.gtfsShapeMap = new LinkedHashMap<String, GTFSShapeBean>();
            }
            this.gtfsDatasetBean.gtfsShapeMap.put(shapeId, gtfsShapeBean);
            int p = 0;
            while (p < lineString.getNumPoints()) {
                Coordinate coord = lineString.getPointN(p).getCoordinate();
                GTFSShapePointBean gtfsShapePointBean = new GTFSShapePointBean();
                gtfsShapePointBean.shapePtLon = coord.x;
                gtfsShapePointBean.shapePtLat = coord.y;
                gtfsShapePointBean.shapePtSequence = p + 1;
                gtfsShapeBean.gtfsShapePoints.add(gtfsShapePointBean);
                ++p;
            }
            Set<String> routeIds = this.gtfsDatasetBean.getRouteIds(routeShortName);
            for (String routeId : routeIds) {
                for (Map.Entry<String, GTFSTripBean> tripEntry : this.gtfsDatasetBean.gtfsTripMap.entrySet()) {
                    GTFSTripBean gtfsTripBean = tripEntry.getValue();
                    if (!gtfsTripBean.routeId.equals(routeId) || gtfsTripBean.directionId != directionId) continue;
                    gtfsTripBean.shapeId = shapeId;
                }
            }
        }
    }

    public void generateTransfers(double distanceMax, double speed) {
        List<String> stopIds = ListUtils.setToList(this.gtfsDatasetBean.gtfsStopMap.keySet());
        int i = 0;
        while (i < stopIds.size()) {
            if (i % 1000 == 0) {
                this.log.info(String.valueOf(i) + " / " + stopIds.size());
            }
            int j = i + 1;
            while (j < stopIds.size()) {
                double distance;
                String id1 = stopIds.get(i);
                String id2 = stopIds.get(j);
                GTFSStopBean stop1 = this.gtfsDatasetBean.gtfsStopMap.get(id1);
                GTFSStopBean stop2 = this.gtfsDatasetBean.gtfsStopMap.get(id2);
                if (stop1.locationType == 0 && stop2.locationType == 0 && (distance = DoubleUtils.distanceLngLat(stop1.stopLon, stop1.stopLat, stop2.stopLon, stop2.stopLat)) < distanceMax) {
                    int time = (int)Math.floor(distance / speed);
                    if (time < 60) {
                        time = 60;
                    }
                    GTFSTransferBean transferBean1 = new GTFSTransferBean();
                    transferBean1.fromStopId = id1;
                    transferBean1.toStopId = id2;
                    transferBean1.transferType = 2;
                    transferBean1.minTransferTime = time;
                    this.gtfsDatasetBean.gtfsTransferList.add(transferBean1);
                    GTFSTransferBean transferBean2 = new GTFSTransferBean();
                    transferBean2.fromStopId = id2;
                    transferBean2.toStopId = id1;
                    transferBean2.transferType = 2;
                    transferBean2.minTransferTime = time;
                    this.gtfsDatasetBean.gtfsTransferList.add(transferBean2);
                }
                ++j;
            }
            ++i;
        }
    }

    public void generateDefaultColors(String routeColor, String routeTextColor) {
        if (routeColor.startsWith("#")) {
            routeColor = routeColor.substring(1);
        }
        if (routeTextColor.startsWith("#")) {
            routeTextColor = routeTextColor.substring(1);
        }
        for (Map.Entry<String, GTFSRouteBean> routeEntry : this.gtfsDatasetBean.gtfsRouteMap.entrySet()) {
            GTFSRouteBean routeBean = routeEntry.getValue();
            if (routeBean.routeColor == null || routeBean.routeColor.length() <= 1) {
                routeBean.routeColor = routeColor;
            }
            if (routeBean.routeTextColor != null && routeBean.routeTextColor.length() > 1) continue;
            routeBean.routeTextColor = routeTextColor;
        }
    }

    public void addParentStationSuffixe(String suffixe) {
        HashMap<String, String> renamedStopIds = new HashMap<String, String>();
        this.log.info("Updating stops");
        for (Map.Entry<String, GTFSStopBean> entry : this.gtfsDatasetBean.gtfsStopMap.entrySet()) {
            GTFSStopBean stopBean = entry.getValue();
            if (stopBean.locationType == 1) {
                String suffixed = String.valueOf(stopBean.stopId) + suffixe;
                renamedStopIds.put(stopBean.stopId, suffixed);
                stopBean.stopId = suffixed;
                continue;
            }
            if (stopBean.locationType != 0 || stopBean.parentStation == null || stopBean.parentStation.length() <= 0) continue;
            stopBean.parentStation = String.valueOf(stopBean.parentStation) + suffixe;
        }
        this.log.info("Updating transfers");
        for (GTFSTransferBean gTFSTransferBean : this.gtfsDatasetBean.gtfsTransferList) {
            if (renamedStopIds.containsKey(gTFSTransferBean.fromStopId)) {
                gTFSTransferBean.fromStopId = (String)renamedStopIds.get(gTFSTransferBean.fromStopId);
            }
            if (!renamedStopIds.containsKey(gTFSTransferBean.toStopId)) continue;
            gTFSTransferBean.toStopId = (String)renamedStopIds.get(gTFSTransferBean.toStopId);
        }
        this.log.info("Updating stop_times");
        for (Map.Entry entry : this.gtfsDatasetBean.gtfsStopTimeMap.entrySet()) {
            for (GTFSTripStopTimeBean tripStopTimeBean : ((GTFSStopTimeBean)entry.getValue()).gtfsTripStopTimes) {
                if (!renamedStopIds.containsKey(tripStopTimeBean.stopId)) continue;
                tripStopTimeBean.stopId = (String)renamedStopIds.get(tripStopTimeBean.stopId);
            }
        }
    }

    public void setStartingDate(Date expectingStartDate) throws java.text.ParseException {
        HashSet<String> removedServiceIds = new HashSet<String>();
        HashSet<String> originalServiceIds = new HashSet<String>();
        String format = "yyyyMMdd";
        String expectedDateStr = DateUtils.getDateWithFormat(format, expectingStartDate);
        int shorted = 0;
        for (Map.Entry<String, GTFSCalendarBean> entry : this.gtfsDatasetBean.gtfsCalendarMap.entrySet()) {
            GTFSCalendarBean calendarBean = entry.getValue();
            originalServiceIds.add(calendarBean.serviceId);
            Iterator startDate = DateUtils.parseDate(calendarBean.startDate, format);
            Date endDate = DateUtils.parseDate(calendarBean.endDate, format);
            if (((Date)((Object)startDate)).before(expectingStartDate) && endDate.after(expectingStartDate)) {
                calendarBean.startDate = expectedDateStr;
                ++shorted;
                continue;
            }
            if (!((Date)((Object)startDate)).before(expectingStartDate) || !endDate.before(expectingStartDate)) continue;
            removedServiceIds.add(calendarBean.serviceId);
        }
        ArrayList<GTFSCalendarDateBean> removedCalendarDates = new ArrayList<GTFSCalendarDateBean>();
        HashSet<String> removedCDServiceIds = new HashSet<String>();
        for (GTFSCalendarDateBean calendarDateBean : this.gtfsDatasetBean.gtfsCalendarDateList) {
            Date date = DateUtils.parseDate(calendarDateBean.date, format);
            originalServiceIds.add(calendarDateBean.serviceId);
            if (date.before(expectingStartDate)) {
                removedCalendarDates.add(calendarDateBean);
                removedCDServiceIds.add(calendarDateBean.serviceId);
                continue;
            }
            if (!removedServiceIds.contains(calendarDateBean.serviceId)) continue;
            removedServiceIds.remove(calendarDateBean.serviceId);
        }
        this.log.info("Total services : " + originalServiceIds.size());
        this.log.info(shorted + " services shorted");
        this.log.info(removedServiceIds.size() + " services deleted");
        for (String serviceId : removedServiceIds) {
            this.gtfsDatasetBean.gtfsCalendarMap.remove(serviceId);
        }
        this.gtfsDatasetBean.gtfsCalendarDateList.removeAll(removedCalendarDates);
        for (String serviceId : removedCDServiceIds) {
            boolean met = false;
            for (GTFSCalendarDateBean calendarDateBean : this.gtfsDatasetBean.gtfsCalendarDateList) {
                if (!calendarDateBean.serviceId.equals(serviceId)) continue;
                met = true;
                break;
            }
            if (met) continue;
            removedServiceIds.add(serviceId);
        }
        HashSet<String> toRemoveTripIds = new HashSet<String>();
        for (Map.Entry<String, GTFSTripBean> entry : this.gtfsDatasetBean.gtfsTripMap.entrySet()) {
            if (!removedServiceIds.contains(entry.getValue().serviceId)) continue;
            toRemoveTripIds.add(entry.getKey());
        }
        for (String tripId : toRemoveTripIds) {
            this.gtfsDatasetBean.gtfsTripMap.remove(tripId);
            this.gtfsDatasetBean.gtfsStopTimeMap.remove(tripId);
        }
    }

    public void saveOutputGTFS(boolean extended) throws FileNotFoundException, UnsupportedEncodingException, LatitudeException {
        this.log.info("Enregistrement du nouveau GTFS");
        GTFSFileWriterProxy gtfsFileWriterProxy = new GTFSFileWriterProxy(this.log, this.outputGTFSPath);
        gtfsFileWriterProxy.writeGTFSDataset(this.gtfsDatasetBean, extended);
    }
}

