/*
 * Decompiled with CFR 0.152.
 */
package latitude.data.gtfs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import latitude.data.csv.CSVFile;
import latitude.data.csv.CSVFileSuperReader;
import latitude.data.gtfs.bean.GTFSAgencyBean;
import latitude.data.gtfs.bean.GTFSCalendarBean;
import latitude.data.gtfs.bean.GTFSCalendarDateBean;
import latitude.data.gtfs.bean.GTFSDatasetBean;
import latitude.data.gtfs.bean.GTFSFeedInfoBean;
import latitude.data.gtfs.bean.GTFSRouteBean;
import latitude.data.gtfs.bean.GTFSShapeBean;
import latitude.data.gtfs.bean.GTFSShapePointBean;
import latitude.data.gtfs.bean.GTFSShapePointComparator;
import latitude.data.gtfs.bean.GTFSStopBean;
import latitude.data.gtfs.bean.GTFSStopTimeBean;
import latitude.data.gtfs.bean.GTFSTransferBean;
import latitude.data.gtfs.bean.GTFSTripBean;
import latitude.data.gtfs.bean.GTFSTripStopTimeBean;
import latitude.data.gtfs.bean.GTFSTripStopTimeComparator;
import latitude.framework.LatitudeException;
import latitude.framework.LatitudeLogger;
import latitude.framework.LatitudeProxy;
import latitude.utils.FileUtils;
import latitude.utils.ZipUtils;

public class GTFSFileReaderProxy
extends LatitudeProxy {
    private String gtfsPath;
    public static String defaultAgencyId = "1";

    public GTFSFileReaderProxy(LatitudeLogger log, String gtfsPath) throws IOException, LatitudeException {
        this.log = log;
        File gtfsFile = new File(gtfsPath);
        if (!gtfsFile.exists()) {
            throw new LatitudeException("Le GTFS " + gtfsPath + " n'existe pas");
        }
        if (gtfsFile.isFile() && gtfsFile.getName().toLowerCase().endsWith(".zip")) {
            this.gtfsPath = String.valueOf(gtfsFile.getParent()) + "/" + FileUtils.getFilenameWithoutExtension(gtfsFile);
            new File(gtfsPath).mkdirs();
            ZipUtils.unzip(gtfsPath, this.gtfsPath);
        } else {
            this.gtfsPath = gtfsPath;
        }
    }

    public GTFSDatasetBean loadGTFSDataset() throws LatitudeException {
        GTFSDatasetBean gtfsDatasetBean = new GTFSDatasetBean();
        gtfsDatasetBean.gtfsFeedInfos = this.loadFeedInfos();
        gtfsDatasetBean.gtfsAgencyMap = this.loadAgencies();
        gtfsDatasetBean.gtfsStopMap = this.loadStops();
        gtfsDatasetBean.gtfsRouteMap = this.loadRoutes();
        gtfsDatasetBean.gtfsTripMap = this.loadTrips();
        gtfsDatasetBean.gtfsShapeMap = this.loadShapes();
        gtfsDatasetBean.gtfsStopTimeMap = this.loadStopTimes();
        gtfsDatasetBean.gtfsCalendarMap = this.loadCalendar();
        gtfsDatasetBean.gtfsCalendarDateList = this.loadCalendarDate();
        gtfsDatasetBean.gtfsTransferList = this.loadTransfers();
        return gtfsDatasetBean;
    }

    private List<GTFSFeedInfoBean> loadFeedInfos() throws LatitudeException {
        CSVFile gtfsFile = new CSVFile(this.gtfsPath, "feed_info.txt");
        gtfsFile.read(false);
        if (gtfsFile.isNull()) {
            return null;
        }
        ArrayList<GTFSFeedInfoBean> gtfsFeedInfos = new ArrayList<GTFSFeedInfoBean>();
        while (gtfsFile.next()) {
            String feedPublisherName = gtfsFile.getAttrValue("feed_publisher_name");
            String feedPublisherUrl = gtfsFile.getAttrValue("feed_publisher_url");
            String feedLang = gtfsFile.getAttrValue("feed_lang");
            if (feedPublisherName.length() <= 0) continue;
            GTFSFeedInfoBean gtfsFeedInfoBean = new GTFSFeedInfoBean();
            gtfsFeedInfoBean.feedPublisherName = feedPublisherName;
            gtfsFeedInfoBean.feedPublisherUrl = feedPublisherUrl;
            gtfsFeedInfoBean.feedLang = feedLang;
            gtfsFeedInfoBean.feedStartDate = gtfsFile.getAttrValue("feed_start_date");
            gtfsFeedInfoBean.feedEndDate = gtfsFile.getAttrValue("feed_end_date");
            gtfsFeedInfoBean.feedVersion = gtfsFile.getAttrValue("feed_version");
            gtfsFeedInfoBean.feedContactEmail = gtfsFile.getAttrValue("feed_contact_email");
            gtfsFeedInfoBean.feedContactUrl = gtfsFile.getAttrValue("feed_contact_url");
            gtfsFeedInfos.add(gtfsFeedInfoBean);
        }
        return gtfsFeedInfos;
    }

    private Map<String, GTFSAgencyBean> loadAgencies() throws LatitudeException {
        CSVFile gtfsFile = new CSVFile(this.gtfsPath, "agency.txt");
        gtfsFile.read(false);
        if (gtfsFile.isNull()) {
            throw new LatitudeException("Le fichier agency.txt est absent du dossier " + this.gtfsPath);
        }
        LinkedHashMap<String, GTFSAgencyBean> gtfsAgencyMap = new LinkedHashMap<String, GTFSAgencyBean>();
        while (gtfsFile.next()) {
            String agencyId = gtfsFile.getAttrValue("agency_id");
            String agencyName = gtfsFile.getAttrValue("agency_name");
            if (agencyName.length() <= 0) continue;
            if (agencyId.length() == 0) {
                agencyId = defaultAgencyId;
            }
            GTFSAgencyBean gtfsAgencyBean = new GTFSAgencyBean();
            gtfsAgencyBean.agencyId = agencyId;
            gtfsAgencyBean.agencyName = agencyName;
            gtfsAgencyBean.agencyUrl = gtfsFile.getAttrValue("agency_url");
            gtfsAgencyBean.agencyTimezone = gtfsFile.getAttrValue("agency_timezone");
            gtfsAgencyBean.agencyLang = gtfsFile.getAttrValue("agency_lang");
            gtfsAgencyBean.agencyPhone = gtfsFile.getAttrValue("agency_phone");
            gtfsAgencyBean.agencyFareUrl = gtfsFile.getAttrValue("agency_fare_url");
            gtfsAgencyBean.agencyEmail = gtfsFile.getAttrValue("agency_email");
            gtfsAgencyMap.put(agencyId, gtfsAgencyBean);
        }
        return gtfsAgencyMap;
    }

    private Map<String, GTFSStopBean> loadStops() throws LatitudeException {
        CSVFile gtfsFile = new CSVFile(this.gtfsPath, "stops.txt");
        gtfsFile.read(false);
        if (gtfsFile.isNull()) {
            throw new LatitudeException("Le fichier stops.txt est absent du dossier " + this.gtfsPath);
        }
        LinkedHashMap<String, GTFSStopBean> gtfsStopMap = new LinkedHashMap<String, GTFSStopBean>();
        while (gtfsFile.next()) {
            String stopId = gtfsFile.getAttrValue("stop_id");
            if (stopId.length() <= 0) continue;
            GTFSStopBean gtfsStopBean = new GTFSStopBean();
            gtfsStopBean.stopId = stopId;
            gtfsStopBean.stopCode = gtfsFile.getAttrValue("stop_code");
            gtfsStopBean.stopName = gtfsFile.getAttrValue("stop_name");
            gtfsStopBean.stopDesc = gtfsFile.getAttrValue("stop_desc");
            gtfsStopBean.stopLat = gtfsFile.getDoubleAttrValue("stop_lat");
            gtfsStopBean.stopLon = gtfsFile.getDoubleAttrValue("stop_lon");
            gtfsStopBean.zoneId = gtfsFile.getAttrValue("zone_id");
            gtfsStopBean.stopUrl = gtfsFile.getAttrValue("stop_url");
            gtfsStopBean.locationType = gtfsFile.getIntAttrValue("location_type");
            gtfsStopBean.parentStation = gtfsFile.getAttrValue("parent_station");
            gtfsStopBean.stopTimezone = gtfsFile.getAttrValue("stop_timezone");
            gtfsStopBean.wheelchairBoarding = gtfsFile.getIntAttrValue("wheelchair_boarding");
            gtfsStopBean.platformCode = gtfsFile.getAttrValue("platform_code");
            gtfsStopMap.put(stopId, gtfsStopBean);
        }
        return gtfsStopMap;
    }

    private Map<String, GTFSRouteBean> loadRoutes() throws LatitudeException {
        CSVFile gtfsFile = new CSVFile(this.gtfsPath, "routes.txt");
        gtfsFile.read(false);
        if (gtfsFile.isNull()) {
            throw new LatitudeException("Le fichier routes.txt est absent du dossier " + this.gtfsPath);
        }
        LinkedHashMap<String, GTFSRouteBean> gtfsRouteMap = new LinkedHashMap<String, GTFSRouteBean>();
        while (gtfsFile.next()) {
            String routeId = gtfsFile.getAttrValue("route_id");
            if (routeId.length() <= 0) continue;
            GTFSRouteBean gtfsRouteBean = new GTFSRouteBean();
            gtfsRouteBean.routeId = routeId;
            gtfsRouteBean.agencyId = gtfsFile.getAttrValue("agency_id");
            if (gtfsRouteBean.agencyId.length() == 0) {
                gtfsRouteBean.agencyId = defaultAgencyId;
            }
            gtfsRouteBean.routeShortName = gtfsFile.getAttrValue("route_short_name");
            gtfsRouteBean.routeLongName = gtfsFile.getAttrValue("route_long_name");
            gtfsRouteBean.routeDesc = gtfsFile.getAttrValue("route_desc");
            gtfsRouteBean.routeType = gtfsFile.getIntAttrValue("route_type");
            gtfsRouteBean.routeUrl = gtfsFile.getAttrValue("route_url");
            gtfsRouteBean.routeColor = gtfsFile.getAttrValue("route_color");
            gtfsRouteBean.routeTextColor = gtfsFile.getAttrValue("route_text_color");
            gtfsRouteMap.put(gtfsRouteBean.routeId, gtfsRouteBean);
        }
        return gtfsRouteMap;
    }

    private Map<String, GTFSTripBean> loadTrips() throws LatitudeException {
        CSVFile gtfsFile = new CSVFile(this.gtfsPath, "trips.txt");
        gtfsFile.read(false);
        if (gtfsFile.isNull()) {
            throw new LatitudeException("Le fichier trips.txt est absent du dossier " + this.gtfsPath);
        }
        LinkedHashMap<String, GTFSTripBean> gtfsTripMap = new LinkedHashMap<String, GTFSTripBean>();
        while (gtfsFile.next()) {
            String tripId = gtfsFile.getAttrValue("trip_id");
            if (tripId.length() <= 0) continue;
            GTFSTripBean gtfsTripBean = new GTFSTripBean();
            gtfsTripBean.routeId = gtfsFile.getAttrValue("route_id");
            gtfsTripBean.serviceId = gtfsFile.getAttrValue("service_id");
            gtfsTripBean.tripId = tripId;
            gtfsTripBean.tripHeadsign = gtfsFile.getAttrValue("trip_headsign");
            gtfsTripBean.tripShortName = gtfsFile.getAttrValue("trip_short_name");
            gtfsTripBean.directionId = gtfsFile.getBoolAttrValue("direction_id");
            gtfsTripBean.blockId = gtfsFile.getAttrValue("block_id");
            gtfsTripBean.shapeId = gtfsFile.getAttrValue("shape_id");
            gtfsTripBean.wheelchairAccessible = gtfsFile.getIntAttrValue("wheelchair_accessible");
            gtfsTripBean.bikesAllowed = gtfsFile.getIntAttrValue("bikes_allowed");
            gtfsTripBean.nota = gtfsFile.getAttrValue("nota");
            gtfsTripMap.put(gtfsTripBean.tripId, gtfsTripBean);
        }
        return gtfsTripMap;
    }

    private Map<String, GTFSShapeBean> loadShapes() throws LatitudeException {
        GTFSShapeBean gtfsShapeBean;
        CSVFile gtfsFile = new CSVFile(this.gtfsPath, "shapes.txt");
        gtfsFile.read(false);
        if (gtfsFile.isNull()) {
            return null;
        }
        HashMap<String, GTFSShapeBean> gtfsShapeMap = new HashMap<String, GTFSShapeBean>();
        while (gtfsFile.next()) {
            String shapeId = gtfsFile.getAttrValue("shape_id");
            if (shapeId.length() <= 0) continue;
            GTFSShapePointBean gtfsShapePoint = new GTFSShapePointBean();
            gtfsShapePoint.shapePtLat = gtfsFile.getDoubleAttrValue("shape_pt_lat");
            gtfsShapePoint.shapePtLon = gtfsFile.getDoubleAttrValue("shape_pt_lon");
            gtfsShapePoint.shapePtSequence = gtfsFile.getIntAttrValue("shape_pt_sequence");
            gtfsShapePoint.shapeDistTraveled = gtfsFile.getDoubleAttrValue("shape_dist_traveled");
            if (!gtfsShapeMap.containsKey(shapeId)) {
                gtfsShapeBean = new GTFSShapeBean();
                gtfsShapeBean.shapeId = shapeId;
                gtfsShapeBean.gtfsShapePoints.add(gtfsShapePoint);
                gtfsShapeMap.put(shapeId, gtfsShapeBean);
                continue;
            }
            ((GTFSShapeBean)gtfsShapeMap.get((Object)shapeId)).gtfsShapePoints.add(gtfsShapePoint);
        }
        for (Map.Entry gtfsShapeEntry : gtfsShapeMap.entrySet()) {
            gtfsShapeBean = (GTFSShapeBean)gtfsShapeEntry.getValue();
            Collections.sort(gtfsShapeBean.gtfsShapePoints, new GTFSShapePointComparator());
        }
        return gtfsShapeMap;
    }

    private Map<String, GTFSStopTimeBean> loadStopTimes() throws LatitudeException {
        GTFSStopTimeBean gtfsStopTimeBean;
        CSVFileSuperReader gtfsFile = new CSVFileSuperReader(this.gtfsPath, "stop_times.txt");
        gtfsFile.setBigFile(true);
        gtfsFile.read(false);
        if (gtfsFile.isNull()) {
            throw new LatitudeException("Le fichier stop_times.txt est absent du dossier " + this.gtfsPath);
        }
        HashMap<String, GTFSStopTimeBean> gtfsStopTimeMap = new HashMap<String, GTFSStopTimeBean>();
        while (gtfsFile.next()) {
            String tripId = gtfsFile.getAttrValue("trip_id");
            if (tripId.length() <= 0) continue;
            GTFSTripStopTimeBean gtfsTripStopTimeBean = new GTFSTripStopTimeBean();
            gtfsTripStopTimeBean.arrivalTime = gtfsFile.getAttrValue("arrival_time");
            gtfsTripStopTimeBean.departureTime = gtfsFile.getAttrValue("departure_time");
            gtfsTripStopTimeBean.stopId = gtfsFile.getAttrValue("stop_id");
            gtfsTripStopTimeBean.stopSequence = gtfsFile.getIntAttrValue("stop_sequence");
            gtfsTripStopTimeBean.stopHeadsign = gtfsFile.getAttrValue("stop_headsign");
            gtfsTripStopTimeBean.pickupType = gtfsFile.getIntAttrValue("pickup_type");
            gtfsTripStopTimeBean.dropOffType = gtfsFile.getIntAttrValue("drop_off_type");
            gtfsTripStopTimeBean.shapeDistTraveled = gtfsFile.getDoubleAttrValue("shape_dist_traveled");
            gtfsTripStopTimeBean.timepoint = gtfsFile.getAttrValue("timepoint");
            if (!gtfsStopTimeMap.containsKey(tripId)) {
                gtfsStopTimeBean = new GTFSStopTimeBean();
                gtfsStopTimeBean.tripId = tripId;
                gtfsStopTimeBean.gtfsTripStopTimes.add(gtfsTripStopTimeBean);
                gtfsStopTimeMap.put(tripId, gtfsStopTimeBean);
                continue;
            }
            ((GTFSStopTimeBean)gtfsStopTimeMap.get((Object)tripId)).gtfsTripStopTimes.add(gtfsTripStopTimeBean);
        }
        for (Map.Entry gtfsStopTimeEntry : gtfsStopTimeMap.entrySet()) {
            gtfsStopTimeBean = (GTFSStopTimeBean)gtfsStopTimeEntry.getValue();
            Collections.sort(gtfsStopTimeBean.gtfsTripStopTimes, new GTFSTripStopTimeComparator());
        }
        return gtfsStopTimeMap;
    }

    private Map<String, GTFSCalendarBean> loadCalendar() throws LatitudeException {
        LinkedHashMap<String, GTFSCalendarBean> gtfsCalendarMap = new LinkedHashMap<String, GTFSCalendarBean>();
        CSVFile gtfsFile = new CSVFile(this.gtfsPath, "calendar.txt");
        gtfsFile.read(false);
        if (!gtfsFile.isNull()) {
            while (gtfsFile.next()) {
                String serviceId = gtfsFile.getAttrValue("service_id");
                if (serviceId.length() <= 0) continue;
                GTFSCalendarBean gtfsCalendarBean = new GTFSCalendarBean();
                gtfsCalendarBean.serviceId = serviceId;
                gtfsCalendarBean.monday = gtfsFile.getBoolAttrValue("monday");
                gtfsCalendarBean.tuesday = gtfsFile.getBoolAttrValue("tuesday");
                gtfsCalendarBean.wednesday = gtfsFile.getBoolAttrValue("wednesday");
                gtfsCalendarBean.thursday = gtfsFile.getBoolAttrValue("thursday");
                gtfsCalendarBean.friday = gtfsFile.getBoolAttrValue("friday");
                gtfsCalendarBean.saturday = gtfsFile.getBoolAttrValue("saturday");
                gtfsCalendarBean.sunday = gtfsFile.getBoolAttrValue("sunday");
                gtfsCalendarBean.startDate = gtfsFile.getAttrValue("start_date");
                gtfsCalendarBean.endDate = gtfsFile.getAttrValue("end_date");
                gtfsCalendarMap.put(serviceId, gtfsCalendarBean);
            }
        }
        return gtfsCalendarMap;
    }

    private List<GTFSCalendarDateBean> loadCalendarDate() throws LatitudeException {
        ArrayList<GTFSCalendarDateBean> gtfsCalendarDateList = new ArrayList<GTFSCalendarDateBean>();
        CSVFile gtfsFile = new CSVFile(this.gtfsPath, "calendar_dates.txt");
        gtfsFile.read(false);
        if (!gtfsFile.isNull()) {
            while (gtfsFile.next()) {
                String serviceId = gtfsFile.getAttrValue("service_id");
                if (serviceId.length() <= 0) continue;
                GTFSCalendarDateBean gtfsCalendarDateBean = new GTFSCalendarDateBean();
                gtfsCalendarDateBean.serviceId = serviceId;
                gtfsCalendarDateBean.date = gtfsFile.getAttrValue("date");
                gtfsCalendarDateBean.exceptionType = gtfsFile.getIntAttrValue("exception_type");
                gtfsCalendarDateList.add(gtfsCalendarDateBean);
            }
        }
        return gtfsCalendarDateList;
    }

    private List<GTFSTransferBean> loadTransfers() throws LatitudeException {
        ArrayList<GTFSTransferBean> gtfsTransferList = new ArrayList<GTFSTransferBean>();
        CSVFile gtfsFile = new CSVFile(this.gtfsPath, "transfers.txt");
        gtfsFile.read(false);
        if (!gtfsFile.isNull()) {
            while (gtfsFile.next()) {
                String fromStopId = gtfsFile.getAttrValue("from_stop_id");
                String toStopId = gtfsFile.getAttrValue("to_stop_id");
                if (fromStopId.length() <= 0 || toStopId.length() <= 0) continue;
                GTFSTransferBean gtfsTransferBean = new GTFSTransferBean();
                gtfsTransferBean.fromStopId = fromStopId;
                gtfsTransferBean.toStopId = toStopId;
                gtfsTransferBean.transferType = gtfsFile.getIntAttrValue("transfer_type");
                gtfsTransferBean.minTransferTime = gtfsFile.getIntAttrValue("min_transfer_time");
                gtfsTransferList.add(gtfsTransferBean);
            }
        }
        return gtfsTransferList;
    }
}

