/*
 * Decompiled with CFR 0.152.
 */
package latitude.data.gtfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import latitude.data.csv.CSVFile;
import latitude.data.gtfs.bean.GTFSAgencyBean;
import latitude.data.gtfs.bean.GTFSCalendarBean;
import latitude.data.gtfs.bean.GTFSCalendarDateBean;
import latitude.data.gtfs.bean.GTFSDatasetBean;
import latitude.data.gtfs.bean.GTFSFeedInfoBean;
import latitude.data.gtfs.bean.GTFSRouteBean;
import latitude.data.gtfs.bean.GTFSShapeBean;
import latitude.data.gtfs.bean.GTFSShapePointBean;
import latitude.data.gtfs.bean.GTFSStopBean;
import latitude.data.gtfs.bean.GTFSStopTimeBean;
import latitude.data.gtfs.bean.GTFSTransferBean;
import latitude.data.gtfs.bean.GTFSTripBean;
import latitude.data.gtfs.bean.GTFSTripStopTimeBean;
import latitude.framework.LatitudeException;
import latitude.framework.LatitudeLogger;
import latitude.framework.LatitudeProxy;
import latitude.utils.StringUtils;
import latitude.utils.ZipUtils;

public class GTFSFileWriterProxy
extends LatitudeProxy {
    private String gtfsPath;
    private String zipPath = null;

    public GTFSFileWriterProxy(LatitudeLogger log, String gtfsPath) {
        this.log = log;
        if (gtfsPath.endsWith(".zip")) {
            this.zipPath = gtfsPath;
            this.gtfsPath = StringUtils.replaceLast(gtfsPath, ".zip", "");
        } else {
            this.gtfsPath = gtfsPath;
        }
    }

    public void writeGTFSDataset(GTFSDatasetBean gtfsDatasetBean, boolean extended) throws FileNotFoundException, UnsupportedEncodingException, LatitudeException {
        new File(this.gtfsPath).mkdirs();
        this.writeFeedInfos(gtfsDatasetBean.gtfsFeedInfos);
        this.writeAgencies(gtfsDatasetBean.gtfsAgencyMap);
        this.writeStops(gtfsDatasetBean.gtfsStopMap);
        this.writeRoutes(gtfsDatasetBean.gtfsRouteMap);
        this.writeTrips(gtfsDatasetBean.gtfsTripMap, extended);
        this.writeStopTimes(gtfsDatasetBean.gtfsStopTimeMap);
        this.writeCalendars(gtfsDatasetBean.gtfsCalendarMap);
        this.writeCalendarDates(gtfsDatasetBean.gtfsCalendarDateList);
        this.writeShapes(gtfsDatasetBean.gtfsShapeMap);
        this.writeTransfers(gtfsDatasetBean.gtfsTransferList);
        if (this.zipPath != null) {
            ZipUtils.zip(this.gtfsPath, this.zipPath);
        }
    }

    public void writeFeedInfos(List<GTFSFeedInfoBean> feedInfos) throws FileNotFoundException, UnsupportedEncodingException {
        if (feedInfos != null) {
            CSVFile csvFile = new CSVFile();
            csvFile.addColumn("feed_publisher_name");
            csvFile.addColumn("feed_publisher_url");
            csvFile.addColumn("feed_lang");
            csvFile.addColumn("feed_start_date");
            csvFile.addColumn("feed_end_date");
            csvFile.addColumn("feed_version");
            csvFile.addColumn("feed_contact_email");
            csvFile.addColumn("feed_contact_url");
            for (GTFSFeedInfoBean feedInfo : feedInfos) {
                csvFile.addLine();
                csvFile.setAttrValue("feed_publisher_name", feedInfo.feedPublisherName);
                csvFile.setAttrValue("feed_publisher_url", feedInfo.feedPublisherUrl);
                csvFile.setAttrValue("feed_lang", feedInfo.feedLang);
                csvFile.setAttrValue("feed_start_date", feedInfo.feedStartDate);
                csvFile.setAttrValue("feed_end_date", feedInfo.feedEndDate);
                csvFile.setAttrValue("feed_version", feedInfo.feedVersion);
                csvFile.setAttrValue("feed_contact_email", feedInfo.feedContactEmail);
                csvFile.setAttrValue("feed_contact_url", feedInfo.feedContactUrl);
            }
            this.writeCSVFile("feed_info", csvFile);
        }
    }

    public void writeAgencies(Map<String, GTFSAgencyBean> agencyMap) throws FileNotFoundException, UnsupportedEncodingException {
        if (agencyMap != null) {
            CSVFile csvFile = new CSVFile();
            csvFile.addColumn("agency_id");
            csvFile.addColumn("agency_name");
            csvFile.addColumn("agency_url");
            csvFile.addColumn("agency_timezone");
            csvFile.addColumn("agency_lang");
            csvFile.addColumn("agency_phone");
            csvFile.addColumn("agency_fare_url");
            csvFile.addColumn("agency_email");
            for (Map.Entry<String, GTFSAgencyBean> agencyEntry : agencyMap.entrySet()) {
                csvFile.addLine();
                GTFSAgencyBean agencyBean = agencyEntry.getValue();
                csvFile.setAttrValue("agency_id", agencyBean.agencyId);
                csvFile.setAttrValue("agency_name", agencyBean.agencyName);
                csvFile.setAttrValue("agency_url", agencyBean.agencyUrl);
                csvFile.setAttrValue("agency_timezone", agencyBean.agencyTimezone);
                csvFile.setAttrValue("agency_lang", agencyBean.agencyLang);
                csvFile.setAttrValue("agency_phone", agencyBean.agencyPhone);
                csvFile.setAttrValue("agency_fare_url", agencyBean.agencyFareUrl);
                csvFile.setAttrValue("agency_email", agencyBean.agencyEmail);
            }
            this.writeCSVFile("agency", csvFile);
        }
    }

    public void writeStops(Map<String, GTFSStopBean> stopMap) throws FileNotFoundException, UnsupportedEncodingException {
        if (stopMap != null) {
            CSVFile csvFile = new CSVFile();
            csvFile.addColumn("stop_id");
            csvFile.addColumn("stop_code");
            csvFile.addColumn("stop_name");
            csvFile.addColumn("stop_desc");
            csvFile.addColumn("stop_lat");
            csvFile.addColumn("stop_lon");
            csvFile.addColumn("zone_id");
            csvFile.addColumn("stop_url");
            csvFile.addColumn("location_type");
            csvFile.addColumn("parent_station");
            csvFile.addColumn("stop_timezone");
            csvFile.addColumn("wheelchair_boarding");
            csvFile.addColumn("platform_code");
            for (Map.Entry<String, GTFSStopBean> stopEntry : stopMap.entrySet()) {
                csvFile.addLine();
                GTFSStopBean stopBean = stopEntry.getValue();
                csvFile.setAttrValue("stop_id", stopBean.stopId);
                csvFile.setAttrValue("stop_code", stopBean.stopCode);
                csvFile.setAttrValue("stop_name", stopBean.stopName);
                csvFile.setAttrValue("stop_desc", stopBean.stopDesc);
                csvFile.setDoubleAttrValue("stop_lat", stopBean.stopLat);
                csvFile.setDoubleAttrValue("stop_lon", stopBean.stopLon);
                csvFile.setAttrValue("zone_id", stopBean.zoneId);
                csvFile.setIntAttrValue("location_type", stopBean.locationType);
                csvFile.setAttrValue("parent_station", stopBean.parentStation);
                csvFile.setAttrValue("stop_timezone", stopBean.stopTimezone);
                csvFile.setIntAttrValue("wheelchair_boarding", stopBean.wheelchairBoarding);
                csvFile.setAttrValue("platform_code", stopBean.platformCode);
            }
            this.writeCSVFile("stops", csvFile);
        }
    }

    public void writeRoutes(Map<String, GTFSRouteBean> routeMap) throws FileNotFoundException, UnsupportedEncodingException {
        if (routeMap != null) {
            CSVFile csvFile = new CSVFile();
            csvFile.addColumn("route_id");
            csvFile.addColumn("agency_id");
            csvFile.addColumn("route_short_name");
            csvFile.addColumn("route_long_name");
            csvFile.addColumn("route_desc");
            csvFile.addColumn("route_type");
            csvFile.addColumn("route_url");
            csvFile.addColumn("route_color");
            csvFile.addColumn("route_text_color");
            for (Map.Entry<String, GTFSRouteBean> routeEntry : routeMap.entrySet()) {
                csvFile.addLine();
                GTFSRouteBean routeBean = routeEntry.getValue();
                csvFile.setAttrValue("route_id", routeBean.routeId);
                csvFile.setAttrValue("agency_id", routeBean.agencyId);
                csvFile.setAttrValue("route_short_name", routeBean.routeShortName);
                csvFile.setAttrValue("route_long_name", routeBean.routeLongName);
                csvFile.setAttrValue("route_desc", routeBean.routeDesc);
                csvFile.setIntAttrValue("route_type", routeBean.routeType);
                csvFile.setAttrValue("route_url", routeBean.routeUrl);
                csvFile.setAttrValue("route_color", routeBean.routeColor);
                csvFile.setAttrValue("route_text_color", routeBean.routeTextColor);
            }
            this.writeCSVFile("routes", csvFile);
        }
    }

    public void writeTrips(Map<String, GTFSTripBean> tripMap, boolean extended) throws FileNotFoundException, UnsupportedEncodingException {
        if (tripMap != null) {
            CSVFile csvFile = new CSVFile();
            csvFile.addColumn("route_id");
            csvFile.addColumn("service_id");
            csvFile.addColumn("trip_id");
            csvFile.addColumn("trip_headsign");
            csvFile.addColumn("trip_short_name");
            csvFile.addColumn("direction_id");
            csvFile.addColumn("block_id");
            csvFile.addColumn("wheelchair_accessible");
            csvFile.addColumn("shape_id");
            if (extended) {
                csvFile.addColumn("nota");
            }
            for (Map.Entry<String, GTFSTripBean> tripEntry : tripMap.entrySet()) {
                csvFile.addLine();
                GTFSTripBean tripBean = tripEntry.getValue();
                csvFile.setAttrValue("route_id", tripBean.routeId);
                csvFile.setAttrValue("service_id", tripBean.serviceId);
                csvFile.setAttrValue("trip_id", tripBean.tripId);
                csvFile.setAttrValue("trip_headsign", tripBean.tripHeadsign);
                csvFile.setAttrValue("trip_short_name", tripBean.tripShortName);
                csvFile.setBoolAttrValue("direction_id", tripBean.directionId);
                csvFile.setAttrValue("block_id", tripBean.blockId);
                csvFile.setIntAttrValue("wheelchair_accessible", tripBean.wheelchairAccessible);
                csvFile.setAttrValue("shape_id", tripBean.shapeId);
                if (!extended) continue;
                csvFile.setAttrValue("nota", tripBean.nota);
            }
            this.writeCSVFile("trips", csvFile);
        }
    }

    public void writeStopTimes(Map<String, GTFSStopTimeBean> stopTimeMap) throws FileNotFoundException, UnsupportedEncodingException {
        if (stopTimeMap != null) {
            CSVFile csvFile = new CSVFile();
            csvFile.addColumn("trip_id");
            csvFile.addColumn("arrival_time");
            csvFile.addColumn("departure_time");
            csvFile.addColumn("stop_id");
            csvFile.addColumn("stop_sequence");
            csvFile.addColumn("stop_headsign");
            csvFile.addColumn("drop_off_type");
            csvFile.addColumn("pickup_type");
            csvFile.addColumn("shape_dist_traveled");
            csvFile.addColumn("timepoint");
            for (Map.Entry<String, GTFSStopTimeBean> stopTimeEntry : stopTimeMap.entrySet()) {
                GTFSStopTimeBean stopTimeBean = stopTimeEntry.getValue();
                for (GTFSTripStopTimeBean tripStopTimeBean : stopTimeBean.gtfsTripStopTimes) {
                    csvFile.addLine();
                    csvFile.setAttrValue("trip_id", stopTimeBean.tripId);
                    csvFile.setAttrValue("arrival_time", tripStopTimeBean.arrivalTime);
                    csvFile.setAttrValue("departure_time", tripStopTimeBean.departureTime);
                    csvFile.setAttrValue("stop_id", tripStopTimeBean.stopId);
                    csvFile.setIntAttrValue("stop_sequence", tripStopTimeBean.stopSequence);
                    csvFile.setAttrValue("stop_headsign", tripStopTimeBean.stopHeadsign);
                    csvFile.setIntAttrValue("drop_off_type", tripStopTimeBean.dropOffType);
                    csvFile.setIntAttrValue("pickup_type", tripStopTimeBean.pickupType);
                    csvFile.setDoubleAttrValue("shape_dist_traveled", tripStopTimeBean.shapeDistTraveled);
                    csvFile.setAttrValue("timepoint", tripStopTimeBean.timepoint);
                }
            }
            this.writeCSVFile("stop_times", csvFile);
        }
    }

    public void writeCalendars(Map<String, GTFSCalendarBean> calendarMap) throws FileNotFoundException, UnsupportedEncodingException {
        if (calendarMap != null) {
            CSVFile csvFile = new CSVFile();
            csvFile.addColumn("service_id");
            csvFile.addColumn("monday");
            csvFile.addColumn("tuesday");
            csvFile.addColumn("wednesday");
            csvFile.addColumn("thursday");
            csvFile.addColumn("friday");
            csvFile.addColumn("saturday");
            csvFile.addColumn("sunday");
            csvFile.addColumn("start_date");
            csvFile.addColumn("end_date");
            for (Map.Entry<String, GTFSCalendarBean> calendarEntry : calendarMap.entrySet()) {
                GTFSCalendarBean calendarBean = calendarEntry.getValue();
                if (calendarBean == null || calendarBean.serviceId == null) continue;
                csvFile.addLine();
                csvFile.setAttrValue("service_id", calendarBean.serviceId);
                csvFile.setBoolAttrValue("monday", calendarBean.monday);
                csvFile.setBoolAttrValue("tuesday", calendarBean.tuesday);
                csvFile.setBoolAttrValue("wednesday", calendarBean.wednesday);
                csvFile.setBoolAttrValue("thursday", calendarBean.thursday);
                csvFile.setBoolAttrValue("friday", calendarBean.friday);
                csvFile.setBoolAttrValue("saturday", calendarBean.saturday);
                csvFile.setBoolAttrValue("sunday", calendarBean.sunday);
                csvFile.setAttrValue("start_date", calendarBean.startDate);
                csvFile.setAttrValue("end_date", calendarBean.endDate);
            }
            this.writeCSVFile("calendar", csvFile);
        }
    }

    public void writeCalendarDates(List<GTFSCalendarDateBean> calendarDates) throws FileNotFoundException, UnsupportedEncodingException {
        if (calendarDates != null) {
            CSVFile csvFile = new CSVFile();
            csvFile.addColumn("service_id");
            csvFile.addColumn("date");
            csvFile.addColumn("exception_type");
            for (GTFSCalendarDateBean calendarDateBean : calendarDates) {
                if (calendarDateBean == null || calendarDateBean.serviceId == null) continue;
                csvFile.addLine();
                csvFile.setAttrValue("service_id", calendarDateBean.serviceId);
                csvFile.setAttrValue("date", calendarDateBean.date);
                csvFile.setIntAttrValue("exception_type", calendarDateBean.exceptionType);
            }
            this.writeCSVFile("calendar_dates", csvFile);
        }
    }

    public void writeShapes(Map<String, GTFSShapeBean> shapeMap) throws FileNotFoundException, UnsupportedEncodingException {
        if (shapeMap != null) {
            CSVFile csvFile = new CSVFile();
            csvFile.addColumn("shape_id");
            csvFile.addColumn("shape_pt_lat");
            csvFile.addColumn("shape_pt_lon");
            csvFile.addColumn("shape_pt_sequence");
            csvFile.addColumn("shape_dist_traveled");
            for (Map.Entry<String, GTFSShapeBean> shapeEntry : shapeMap.entrySet()) {
                GTFSShapeBean shapeBean = shapeEntry.getValue();
                for (GTFSShapePointBean shapePointBean : shapeBean.gtfsShapePoints) {
                    csvFile.addLine();
                    csvFile.setAttrValue("shape_id", shapeBean.shapeId);
                    csvFile.setDoubleAttrValue("shape_pt_lat", shapePointBean.shapePtLat);
                    csvFile.setDoubleAttrValue("shape_pt_lon", shapePointBean.shapePtLon);
                    csvFile.setIntAttrValue("shape_pt_sequence", shapePointBean.shapePtSequence);
                    csvFile.setDoubleAttrValue("shape_dist_traveled", shapePointBean.shapeDistTraveled);
                }
            }
            this.writeCSVFile("shapes", csvFile);
        }
    }

    public void writeTransfers(List<GTFSTransferBean> transferList) throws FileNotFoundException, UnsupportedEncodingException {
        if (transferList != null) {
            CSVFile csvFile = new CSVFile();
            csvFile.addColumn("from_stop_id");
            csvFile.addColumn("to_stop_id");
            csvFile.addColumn("transfer_type");
            csvFile.addColumn("min_transfer_time");
            for (GTFSTransferBean transferBean : transferList) {
                csvFile.addLine();
                csvFile.setAttrValue("from_stop_id", transferBean.fromStopId);
                csvFile.setAttrValue("to_stop_id", transferBean.toStopId);
                csvFile.setIntAttrValue("transfer_type", transferBean.transferType);
                csvFile.setIntAttrValue("min_transfer_time", transferBean.minTransferTime);
            }
            this.writeCSVFile("transfers", csvFile);
        }
    }

    private void writeCSVFile(String filename, CSVFile csvFile) throws FileNotFoundException, UnsupportedEncodingException {
        this.log.info("\ud83d\udcbe  " + filename + ".txt\t" + csvFile.size() + " entr\u00e9es");
        csvFile.setSeparator(CSVFile.SEPARATOR_COMMA);
        csvFile.write(String.valueOf(this.gtfsPath) + "/" + filename + ".txt");
    }
}

