/*
 * Decompiled with CFR 0.152.
 */
package latitude.data.gtfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import latitude.data.gtfs.GTFSFileReaderProxy;
import latitude.data.gtfs.bean.GTFSAgencyBean;
import latitude.data.gtfs.bean.GTFSCalendarBean;
import latitude.data.gtfs.bean.GTFSCalendarDateBean;
import latitude.data.gtfs.bean.GTFSDatasetBean;
import latitude.data.gtfs.bean.GTFSRouteBean;
import latitude.data.gtfs.bean.GTFSShapeBean;
import latitude.data.gtfs.bean.GTFSStopBean;
import latitude.data.gtfs.bean.GTFSStopTimeBean;
import latitude.data.gtfs.bean.GTFSTransferBean;
import latitude.data.gtfs.bean.GTFSTripBean;
import latitude.framework.LatitudeException;
import latitude.framework.LatitudeLogger;
import latitude.framework.LatitudeProxy;

public class GTFSMergeProxy
extends LatitudeProxy {
    public GTFSMergeProxy(LatitudeLogger log) {
        this.log = log;
    }

    public GTFSDatasetBean merge(String primaryGTFSPath, String secondaryGTFSPath, boolean dissolveCommonIds) throws LatitudeException, IOException {
        this.log.info("Chargement du GTFS : " + primaryGTFSPath);
        GTFSFileReaderProxy primaryReaderProxy = new GTFSFileReaderProxy(this.log, primaryGTFSPath);
        GTFSDatasetBean primaryDatasetBean = primaryReaderProxy.loadGTFSDataset();
        this.log.info("Chargement du GTFS : " + secondaryGTFSPath);
        GTFSFileReaderProxy secondaryReaderProxy = new GTFSFileReaderProxy(this.log, secondaryGTFSPath);
        GTFSDatasetBean secondaryDatasetBean = secondaryReaderProxy.loadGTFSDataset();
        GTFSDatasetBean mergedDatasetBean = dissolveCommonIds ? this.mergeKeepingIds(primaryDatasetBean, secondaryDatasetBean) : this.mergeDuplicatingIds(primaryDatasetBean, secondaryDatasetBean);
        return mergedDatasetBean;
    }

    private GTFSDatasetBean mergeKeepingIds(GTFSDatasetBean masterDatasetBean, GTFSDatasetBean slaveDatasetBean) {
        String serviceId;
        String tripId;
        this.log.info("Fusion en conservant les ids du master");
        String secSuffix = "sec";
        HashMap<String, String> agencyIdMap = new HashMap<String, String>();
        for (Map.Entry<String, GTFSAgencyBean> entry : slaveDatasetBean.gtfsAgencyMap.entrySet()) {
            String slaveAgencyId = entry.getKey();
            if (masterDatasetBean.gtfsAgencyMap.containsKey(slaveAgencyId) && !entry.getValue().agencyName.equals(masterDatasetBean.gtfsAgencyMap.get((Object)slaveAgencyId).agencyName)) {
                String suffixedAgencyId;
                entry.getValue().agencyId = suffixedAgencyId = String.valueOf(slaveAgencyId) + secSuffix;
                masterDatasetBean.gtfsAgencyMap.put(suffixedAgencyId, entry.getValue());
                agencyIdMap.put(slaveAgencyId, suffixedAgencyId);
                continue;
            }
            agencyIdMap.put(slaveAgencyId, slaveAgencyId);
        }
        for (Map.Entry<String, Object> entry : slaveDatasetBean.gtfsRouteMap.entrySet()) {
            String routeId = entry.getKey();
            if (masterDatasetBean.gtfsRouteMap.containsKey(routeId)) continue;
            ((GTFSRouteBean)entry.getValue()).agencyId = (String)agencyIdMap.get(((GTFSRouteBean)entry.getValue()).agencyId);
            masterDatasetBean.gtfsRouteMap.put(routeId, (GTFSRouteBean)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : slaveDatasetBean.gtfsTripMap.entrySet()) {
            tripId = entry.getKey();
            if (masterDatasetBean.gtfsTripMap.containsKey(tripId)) continue;
            masterDatasetBean.gtfsTripMap.put(tripId, (GTFSTripBean)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : slaveDatasetBean.gtfsStopTimeMap.entrySet()) {
            tripId = entry.getKey();
            if (masterDatasetBean.gtfsStopTimeMap.containsKey(tripId)) continue;
            masterDatasetBean.gtfsStopTimeMap.put(tripId, (GTFSStopTimeBean)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : slaveDatasetBean.gtfsStopMap.entrySet()) {
            String stopId = entry.getKey();
            if (masterDatasetBean.gtfsStopMap.containsKey(stopId)) continue;
            masterDatasetBean.gtfsStopMap.put(stopId, (GTFSStopBean)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : slaveDatasetBean.gtfsCalendarMap.entrySet()) {
            serviceId = entry.getKey();
            if (masterDatasetBean.gtfsCalendarMap.containsKey(serviceId)) continue;
            masterDatasetBean.gtfsCalendarMap.put(serviceId, (GTFSCalendarBean)entry.getValue());
        }
        if (slaveDatasetBean.gtfsCalendarDateList != null) {
            if (masterDatasetBean.gtfsCalendarDateList == null) {
                masterDatasetBean.gtfsCalendarDateList = new ArrayList<GTFSCalendarDateBean>();
            }
            for (GTFSCalendarDateBean gTFSCalendarDateBean : slaveDatasetBean.gtfsCalendarDateList) {
                serviceId = gTFSCalendarDateBean.serviceId;
                if (masterDatasetBean.gtfsCalendarMap.containsKey(serviceId)) continue;
                masterDatasetBean.gtfsCalendarDateList.add(gTFSCalendarDateBean);
            }
        }
        if (slaveDatasetBean.gtfsShapeMap != null) {
            if (masterDatasetBean.gtfsShapeMap == null) {
                masterDatasetBean.gtfsShapeMap = new HashMap<String, GTFSShapeBean>();
            }
            for (Map.Entry entry : slaveDatasetBean.gtfsShapeMap.entrySet()) {
                String shapeId = (String)entry.getKey();
                if (masterDatasetBean.gtfsShapeMap.containsKey(shapeId)) continue;
                masterDatasetBean.gtfsShapeMap.put(shapeId, (GTFSShapeBean)entry.getValue());
            }
        }
        if (slaveDatasetBean.gtfsTransferList != null) {
            if (masterDatasetBean.gtfsTransferList == null) {
                masterDatasetBean.gtfsTransferList = new ArrayList<GTFSTransferBean>();
            }
            for (GTFSTransferBean gTFSTransferBean : slaveDatasetBean.gtfsTransferList) {
                boolean existsInMaster = false;
                for (GTFSTransferBean masterTransferBean : masterDatasetBean.gtfsTransferList) {
                    if (!masterTransferBean.fromStopId.equals(gTFSTransferBean.fromStopId) || !masterTransferBean.toStopId.equals(gTFSTransferBean.toStopId)) continue;
                    existsInMaster = true;
                    break;
                }
                if (existsInMaster) continue;
                masterDatasetBean.gtfsTransferList.add(gTFSTransferBean);
            }
        }
        return masterDatasetBean;
    }

    private GTFSDatasetBean mergeDuplicatingIds(GTFSDatasetBean primaryDatasetBean, GTFSDatasetBean secondaryDatasetBean) throws LatitudeException {
        throw new LatitudeException("mergeDuplicatingIds not yet implemented");
    }
}

