/*
 * Decompiled with CFR 0.152.
 */
package latitude.data.gtfs.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import latitude.data.gtfs.bean.GTFSAgencyBean;
import latitude.data.gtfs.bean.GTFSCalendarBean;
import latitude.data.gtfs.bean.GTFSCalendarDateBean;
import latitude.data.gtfs.bean.GTFSFeedInfoBean;
import latitude.data.gtfs.bean.GTFSRouteBean;
import latitude.data.gtfs.bean.GTFSServiceBean;
import latitude.data.gtfs.bean.GTFSShapeBean;
import latitude.data.gtfs.bean.GTFSStopBean;
import latitude.data.gtfs.bean.GTFSStopTimeBean;
import latitude.data.gtfs.bean.GTFSTransferBean;
import latitude.data.gtfs.bean.GTFSTripBean;

public class GTFSDatasetBean {
    public List<GTFSFeedInfoBean> gtfsFeedInfos;
    public Map<String, GTFSAgencyBean> gtfsAgencyMap;
    public Map<String, GTFSStopBean> gtfsStopMap;
    public Map<String, GTFSRouteBean> gtfsRouteMap;
    public Map<String, GTFSTripBean> gtfsTripMap;
    public Map<String, GTFSShapeBean> gtfsShapeMap;
    public Map<String, GTFSStopTimeBean> gtfsStopTimeMap;
    public Map<String, GTFSCalendarBean> gtfsCalendarMap;
    public List<GTFSCalendarDateBean> gtfsCalendarDateList;
    public List<GTFSTransferBean> gtfsTransferList;
    public Map<String, GTFSServiceBean> gtfsServiceMap;

    public String getAgencyName(String agencyId) {
        if (this.gtfsAgencyMap != null && this.gtfsAgencyMap.size() > 0 && this.gtfsAgencyMap.containsKey(agencyId)) {
            return this.gtfsAgencyMap.get((Object)agencyId).agencyName;
        }
        return "UNKNOWN_AGENCY";
    }

    public String getAgencyNameByLineName(String lineName) {
        return this.getAgencyName(this.gtfsRouteMap.get((Object)this.getRouteId((String)lineName)).agencyId);
    }

    public String getStopCode(String stopId) {
        GTFSStopBean stopBean = this.gtfsStopMap.get(stopId);
        if (stopBean != null) {
            return stopBean.stopCode;
        }
        return null;
    }

    public String getStopId(String stopCode) {
        for (Map.Entry<String, GTFSStopBean> stopEntry : this.gtfsStopMap.entrySet()) {
            if (!stopEntry.getValue().stopCode.equals(stopCode)) continue;
            return stopEntry.getKey();
        }
        return null;
    }

    public String getStopName(String stopId) {
        return this.gtfsStopMap.get((Object)stopId).stopName;
    }

    public String getStopCity(String stopId) {
        return this.gtfsStopMap.get((Object)stopId).city;
    }

    public String getRouteId(String lineName) {
        for (Map.Entry<String, GTFSRouteBean> routeEntry : this.gtfsRouteMap.entrySet()) {
            if (!routeEntry.getValue().routeShortName.equals(lineName)) continue;
            return routeEntry.getKey();
        }
        return null;
    }

    public Set<String> getRouteIds(String lineName) {
        HashSet<String> routeIds = new HashSet<String>();
        for (Map.Entry<String, GTFSRouteBean> routeEntry : this.gtfsRouteMap.entrySet()) {
            if (!routeEntry.getValue().routeShortName.equals(lineName)) continue;
            routeIds.add(routeEntry.getKey());
        }
        return routeIds;
    }

    public String getLineName(String routeId) {
        GTFSRouteBean routeBean = this.gtfsRouteMap.get(routeId);
        if (routeBean != null) {
            return routeBean.routeShortName;
        }
        return null;
    }

    public List<GTFSTripBean> getTripList(String routeId, boolean directionId, List<String> serviceIds) {
        ArrayList<GTFSTripBean> tripList = new ArrayList<GTFSTripBean>();
        for (Map.Entry<String, GTFSTripBean> tripEntry : this.gtfsTripMap.entrySet()) {
            GTFSTripBean tripBean = tripEntry.getValue();
            if (!tripBean.routeId.equals(routeId) || tripBean.directionId != directionId || serviceIds != null && !serviceIds.contains(tripBean.serviceId)) continue;
            tripList.add(tripBean);
        }
        return tripList;
    }

    public String getBlockId(String tripId) {
        return this.gtfsTripMap.get((Object)tripId).blockId;
    }

    public void keepStops(Set<String> toKeepStops) {
        HashMap<String, GTFSStopBean> newStopMap = new HashMap<String, GTFSStopBean>();
        for (String stopId : toKeepStops) {
            newStopMap.put(stopId, this.gtfsStopMap.get(stopId));
        }
        this.gtfsStopMap = newStopMap;
        ArrayList<GTFSTransferBean> newTransfers = new ArrayList<GTFSTransferBean>();
        for (GTFSTransferBean transferBean : this.gtfsTransferList) {
            if (!toKeepStops.contains(transferBean.fromStopId) && !toKeepStops.contains(transferBean.toStopId)) continue;
            newTransfers.add(transferBean);
        }
        this.gtfsTransferList = newTransfers;
    }

    public void keepAgencies(Set<String> toKeepAgencies) {
        HashMap<String, GTFSAgencyBean> newAgencyMap = new HashMap<String, GTFSAgencyBean>();
        for (String agencyId : toKeepAgencies) {
            newAgencyMap.put(agencyId, this.gtfsAgencyMap.get(agencyId));
        }
        this.gtfsAgencyMap = newAgencyMap;
    }

    public void deleteAgencies(Set<String> toDeleteAgencies) {
        for (String agencyId : toDeleteAgencies) {
            this.gtfsAgencyMap.remove(agencyId);
        }
    }

    public void keepRoutes(Set<String> toKeepRoutes) {
        HashMap<String, GTFSRouteBean> newRouteMap = new HashMap<String, GTFSRouteBean>();
        for (String routeId : toKeepRoutes) {
            newRouteMap.put(routeId, this.gtfsRouteMap.get(routeId));
        }
        this.gtfsRouteMap = newRouteMap;
    }

    public void deleteRoutes(Set<String> toDeleteRoutes) {
        for (String routeId : toDeleteRoutes) {
            this.gtfsRouteMap.remove(routeId);
        }
    }

    public void keepTrips(Set<String> toKeepTrips) {
        HashMap<String, GTFSTripBean> newTripMap = new HashMap<String, GTFSTripBean>();
        HashMap<String, GTFSStopTimeBean> newStopTimeMap = new HashMap<String, GTFSStopTimeBean>();
        for (String tripId : toKeepTrips) {
            newTripMap.put(tripId, this.gtfsTripMap.get(tripId));
            newStopTimeMap.put(tripId, this.gtfsStopTimeMap.get(tripId));
        }
        this.gtfsTripMap = newTripMap;
        this.gtfsStopTimeMap = newStopTimeMap;
    }

    public void deleteTrips(Set<String> toDeleteTrips) {
        for (String tripId : toDeleteTrips) {
            this.gtfsTripMap.remove(tripId);
        }
        for (String tripId : toDeleteTrips) {
            this.gtfsStopTimeMap.remove(tripId);
        }
    }

    public void keepServices(Set<String> toKeepServices) {
        HashMap<String, GTFSCalendarBean> newCalendarMap = new HashMap<String, GTFSCalendarBean>();
        for (String id : toKeepServices) {
            newCalendarMap.put(id, this.gtfsCalendarMap.get(id));
        }
        this.gtfsCalendarMap = newCalendarMap;
        ArrayList<GTFSCalendarDateBean> newCalendarDates = new ArrayList<GTFSCalendarDateBean>();
        for (GTFSCalendarDateBean calendarDateBean : this.gtfsCalendarDateList) {
            if (!toKeepServices.contains(calendarDateBean.serviceId)) continue;
            newCalendarDates.add(calendarDateBean);
        }
        this.gtfsCalendarDateList = newCalendarDates;
    }

    public void keepShapes(Set<String> toKeepShapes) {
        if (this.gtfsShapeMap != null) {
            HashMap<String, GTFSShapeBean> newShapeMap = new HashMap<String, GTFSShapeBean>();
            for (String shapeId : toKeepShapes) {
                newShapeMap.put(shapeId, this.gtfsShapeMap.get(shapeId));
            }
            this.gtfsShapeMap = newShapeMap;
        }
    }

    public void deleteShapes(Set<String> toDeleteShapes) {
        for (String shapeId : toDeleteShapes) {
            this.gtfsShapeMap.remove(shapeId);
        }
    }
}

