/*
 * Decompiled with CFR 0.152.
 */
package latitude.data.xml;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import latitude.data.xml.XMLNodeList;
import latitude.framework.LatitudeException;
import latitude.utils.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLUtils {
    public static Document fileToDocument(File file) throws LatitudeException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (file.exists()) {
                Document document = builder.parse(file);
                return document;
            }
            throw new LatitudeException("Le fichier " + file.getAbsolutePath() + " n'existe pas");
        }
        catch (OutOfMemoryError e) {
            throw new LatitudeException("Le document XML est trop volumineux -> augmenter la m\u00e9moire Java.");
        }
        catch (Exception e) {
            throw new LatitudeException("Erreur de lecture du fichier XML : " + e.getMessage());
        }
    }

    public static File documentToFile(Document document, String filePath) throws LatitudeException {
        try {
            File file = new File(filePath);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(file));
            return file;
        }
        catch (Exception e) {
            throw new LatitudeException("Erreur lors de l'enregistrement du fichier XML : " + e.getMessage());
        }
    }

    public static Document stringToDocument(String string) throws LatitudeException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(string)));
            return document;
        }
        catch (OutOfMemoryError e) {
            throw new LatitudeException("Le document XML est trop volumineux -> augmenter la m\u00e9moire Java.");
        }
        catch (Exception e) {
            throw new LatitudeException("Erreur de lecture du fichier XML : " + e.getMessage());
        }
    }

    public static String documentToString(Document document) {
        try {
            StringWriter sw = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", StringUtils.UTF8);
            transformer.transform(new DOMSource(document), new StreamResult(sw));
            return sw.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error converting to String", ex);
        }
    }

    public static Node getChildByName(Node parent, String childName) {
        for (Node node : new XMLNodeList(parent.getChildNodes())) {
            if (!node.getNodeName().equals(childName)) continue;
            return node;
        }
        return null;
    }

    public static List<Node> getChildsByName(Node parent, String childName) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node node : new XMLNodeList(parent.getChildNodes())) {
            if (!node.getNodeName().equals(childName)) continue;
            nodes.add(node);
        }
        return nodes;
    }
}

