/*
 * Decompiled with CFR 0.152.
 */
package latitude.framework;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import latitude.utils.ListUtils;

public class LatitudeLogger {
    private boolean uiLog;
    private String mute = null;
    private Logger logger = null;

    public LatitudeLogger() {
        this.uiLog = false;
    }

    public LatitudeLogger(String mute) {
        this.mute = mute;
    }

    public LatitudeLogger(boolean pUiLog) {
        this.uiLog = pUiLog;
    }

    public void title(String t) throws IOException {
        if (this.mute == null) {
            System.err.println(t);
        }
        if (this.logger != null) {
            this.logger.info(t);
        }
    }

    public void info(String a) {
        this.verbose(a);
    }

    public void list(List<String> strings) {
        this.info(ListUtils.listToString(strings, ";"));
    }

    public void list(Set<String> set) {
        this.list(ListUtils.setToList(set));
    }

    public void verbose(String a) {
        if (this.mute == null) {
            System.out.println(a);
        }
        if (this.logger != null) {
            this.logger.info(a);
        }
    }

    public void warn(String e) {
        if (this.mute == null) {
            System.out.println("WARNING: " + e);
        }
        if (this.logger != null) {
            this.logger.warning(e);
        }
        if (this.uiLog) {
            JOptionPane.showMessageDialog(null, e, "Attention", 2);
        }
    }

    public void error(String e) {
        if (this.mute == null) {
            System.out.println("ERROR: " + e);
        }
        if (this.logger != null) {
            this.logger.severe(e);
        }
        if (this.uiLog) {
            JOptionPane.showMessageDialog(null, e, "Erreur", 0);
        }
    }

    public void errorAndExit(String e) {
        this.error("FATAL: " + e);
        if (this.logger != null) {
            this.logger.severe(e);
        }
        System.exit(0);
    }

    public void ex(Exception e) {
        e.printStackTrace(System.err);
        if (this.logger != null) {
            this.logger.severe(e.getMessage());
        }
        if (this.uiLog) {
            JOptionPane.showMessageDialog(null, String.valueOf(e.getClass().getName()) + " : " + e.getMessage(), "Exception", 0);
        }
    }

    public void endNotification() {
        JOptionPane.showMessageDialog(null, "Le traitement est termin\u00e9");
    }
}

