/*
 * Decompiled with CFR 0.152.
 */
package latitude.framework;

import latitude.framework.LatitudeLogger;
import latitude.framework.LatitudeProxy;
import latitude.utils.DateUtils;

public class ProcCtx
extends LatitudeProxy {
    public static final int EXPORT = 0;
    public static final int GENERATION = 1;
    public static final int UPDATE = 2;
    public static final int PROCESSING = 3;
    public static final int DOWNLOAD = 4;
    public static final int LOAD = 5;
    public static final int TEST = 6;
    private int processingType;
    private String processingTypeNameWithArticle;
    private long startTime;
    private long unitStartTime;
    private int step;

    public ProcCtx(LatitudeLogger log, int processingType) {
        this.log = log;
        this.processingType = processingType;
        this.init();
        log.info("D\u00e9marrage " + ("de " + this.processingTypeNameWithArticle).replaceFirst("de le", "du"));
    }

    public ProcCtx(LatitudeLogger log, int processingType, int nPlans) {
        this.log = log;
        this.init();
        log.info("D\u00e9marrage " + ("de " + this.processingTypeNameWithArticle).replaceFirst("de le", "du") + " de " + nPlans + " plans");
    }

    public void init() {
        this.startTime = System.nanoTime();
        this.step = 0;
        switch (this.processingType) {
            case 0: {
                this.processingTypeNameWithArticle = "l'export";
                break;
            }
            case 1: {
                this.processingTypeNameWithArticle = "la g\u00e9n\u00e9ration";
                break;
            }
            case 2: {
                this.processingTypeNameWithArticle = "la mise \u00e0 jour";
                break;
            }
            case 3: {
                this.processingTypeNameWithArticle = "le traitement";
                break;
            }
            case 4: {
                this.processingTypeNameWithArticle = "le t\u00e9l\u00e9chargement";
                break;
            }
            case 5: {
                this.processingTypeNameWithArticle = "le chargement";
                break;
            }
            case 6: {
                this.processingTypeNameWithArticle = "le test";
            }
        }
    }

    public void step() {
        ++this.step;
    }

    public void end() {
        long endTime = System.nanoTime();
        if (this.step > 0) {
            switch (this.processingType) {
                case 6: {
                    this.log.info(this.step + " tests pass\u00e9s");
                    break;
                }
                default: {
                    this.log.info(this.step + " plans export\u00e9s");
                }
            }
        }
        this.log.info(String.valueOf(this.processingTypeNameWithArticle.replaceFirst("l", "L")) + " a dur\u00e9 " + DateUtils.getElapsedTime(this.startTime, endTime));
    }

    public void startUnitTimer() {
        this.unitStartTime = System.nanoTime();
    }

    public void stopUnitTimer() {
        this.log.info("Temps du traitement : " + DateUtils.getElapsedTime(this.unitStartTime, System.nanoTime()));
    }

    public void startTest(String title) {
        this.log.info("TEST " + title);
    }

    public void testOK() {
        this.log.info("[TEST PASS\u00c9]");
        this.step();
    }
}

