/*
 * Decompiled with CFR 0.152.
 */
package latitude.utils;

import java.awt.Color;

public class ColorUtils {
    public static String colorToString(int rgb) {
        int blue = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int red = rgb & 0xFF;
        return String.valueOf(red) + "," + green + "," + blue;
    }

    public static String hexToString(String hexa) {
        String val;
        String string = val = hexa.startsWith("#") ? hexa.substring(1) : hexa;
        if (val.length() == 6) {
            Color color = new Color(Integer.valueOf(val.substring(0, 2), 16), Integer.valueOf(val.substring(2, 4), 16), Integer.valueOf(val.substring(4, 6), 16));
            return String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue();
        }
        if (val.length() == 3) {
            Color color = new Color(Integer.valueOf(val.substring(0, 1), 8), Integer.valueOf(val.substring(1, 2), 8), Integer.valueOf(val.substring(2, 3), 8));
            return String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue();
        }
        return null;
    }

    public static String rgbToCmyk(String rgbHex) {
        if (rgbHex.length() == 6) {
            int red = Integer.valueOf(rgbHex.substring(0, 2), 16);
            int green = Integer.valueOf(rgbHex.substring(2, 4), 16);
            int blue = Integer.valueOf(rgbHex.substring(4, 6), 16);
            float r1 = (float)red / 255.0f;
            float g1 = (float)green / 255.0f;
            float b1 = (float)blue / 255.0f;
            float k = 1.0f - Math.max(r1, Math.max(g1, b1));
            float c = (1.0f - r1 - k) / (1.0f - k);
            float m = (1.0f - g1 - k) / (1.0f - k);
            float y = (1.0f - b1 - k) / (1.0f - k);
            int cyan = Math.round(c * 100.0f);
            int magenta = Math.round(m * 100.0f);
            int yellow = Math.round(y * 100.0f);
            int black = Math.round(k * 100.0f);
            return String.valueOf(cyan) + "/" + magenta + "/" + yellow + "/" + black;
        }
        return "0/0/0/100";
    }
}

