/*
 * Decompiled with CFR 0.152.
 */
package latitude.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class DateUtils {
    public static Date getOriginDate() throws ParseException {
        return DateUtils.parseDate("01/01/1970 00", "dd/MM/yyyy HH");
    }

    public static String getDateAndTimeForPath() {
        return DateUtils.getDateWithFormat("yyyy-MM-dd-HHmmss");
    }

    public static String getDateWithFormat(String format) {
        return DateUtils.getDateWithFormat(format, new Date());
    }

    public static String getDateWithFormat(String format, Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        String dat = dateFormat.format(date);
        return dat;
    }

    public static Date getNextTuesday() {
        int tuesday = 3;
        Calendar calendar = Calendar.getInstance();
        int diff = tuesday - calendar.get(7);
        if (diff <= 0) {
            diff += 7;
        }
        calendar.add(5, diff);
        return calendar.getTime();
    }

    public static Date getLastFriday() {
        int friday = 6;
        Calendar calendar = Calendar.getInstance();
        int diff = friday - calendar.get(7);
        if (diff >= 0) {
            diff -= 7;
        }
        calendar.add(5, diff);
        return calendar.getTime();
    }

    public static int getDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7);
    }

    public static int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static String getElapsedTime(long startTime, long endTime) {
        long elapsedTime = endTime - startTime;
        long diffInMilli = elapsedTime / 1000000L;
        long secondsInMilli = 1000L;
        long minutesInMilli = secondsInMilli * 60L;
        long hoursInMilli = minutesInMilli * 60L;
        long daysInMilli = hoursInMilli * 24L;
        long elapsedDays = diffInMilli / daysInMilli;
        long elapsedHours = (diffInMilli %= daysInMilli) / hoursInMilli;
        long elapsedMinutes = (diffInMilli %= hoursInMilli) / minutesInMilli;
        long elapsedSeconds = (diffInMilli %= minutesInMilli) / secondsInMilli;
        String time = String.valueOf(elapsedDays > 0L ? String.valueOf(elapsedDays) + " jours, " : "") + (elapsedHours > 0L ? String.valueOf(elapsedHours) + " heures, " : "") + (elapsedMinutes > 0L ? String.valueOf(elapsedMinutes) + " minutes, " : "") + elapsedSeconds + "." + (diffInMilli %= secondsInMilli) + " secondes";
        return time;
    }

    public static long getElapsedMinutes(long startTime, long endTime) {
        long elapsedTime = endTime - startTime;
        long secondsInMilli = 1000L;
        long minutesInMilli = secondsInMilli * 60L;
        long elapsedMinutes = elapsedTime / minutesInMilli;
        return elapsedMinutes;
    }

    public static double getElapsedHours(long startTime, long endTime) {
        double elapsedTime = endTime - startTime;
        double secondsInMilli = 1000.0;
        double hoursInMilli = secondsInMilli * 3600.0;
        double elapsedMinutes = elapsedTime / hoursInMilli;
        return elapsedMinutes;
    }

    public static Date getWeekDate(int week, int year) {
        Calendar weekCalendar = Calendar.getInstance();
        weekCalendar.clear();
        weekCalendar.set(3, week);
        weekCalendar.set(1, year);
        return weekCalendar.getTime();
    }

    public static boolean dayIsInWeek(Date weekDate, String dateStr, String dateFormat) throws ParseException {
        Date date = new SimpleDateFormat(dateFormat).parse(dateStr);
        int diff = (int)Math.round((double)(date.getTime() - weekDate.getTime()) / 8.64E7);
        return diff >= 0 && diff <= 7;
    }

    public static int getWeekNumber(Date date) {
        Calendar cal = Calendar.getInstance(Locale.FRANCE);
        cal.setTime(date);
        int week = cal.get(3);
        return week;
    }

    public static int getYear(Date date) {
        Calendar cal = Calendar.getInstance(Locale.FRANCE);
        cal.setTime(date);
        int year = cal.get(1);
        return year;
    }

    public static int getNumberOfDaysBetweenTwoDays(Date d, Date e) {
        int diff = (int)Math.round((double)(d.getTime() - e.getTime()) / 8.64E7);
        return diff;
    }

    public static Date parseDate(String dateStr, String format) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.parse(dateStr);
    }

    public static Date addSeconds(Date date, long numberOfSeconds) {
        return new Date(date.getTime() + TimeUnit.SECONDS.toMillis(numberOfSeconds));
    }

    public static Date addHours(Date date, long numberOfHours) {
        return new Date(date.getTime() + TimeUnit.HOURS.toMillis(numberOfHours));
    }

    public static Date addDays(Date date, long numberOfDays) {
        return new Date(date.getTime() + TimeUnit.DAYS.toMillis(numberOfDays));
    }

    public static boolean between(Date date, Date minDate, Date maxDate) {
        return date.compareTo(minDate) >= 0 && date.compareTo(maxDate) <= 0;
    }

    public static double getHours(Date date) {
        return (double)date.getHours() + (double)date.getMinutes() / 60.0 + (double)date.getSeconds() / 3600.0;
    }

    public static Date[] clipDates(Date debut, Date fin, Date limitStartDate, Date limitEndDate) {
        if (DateUtils.between(debut, limitStartDate, limitEndDate) && DateUtils.between(fin, limitStartDate, limitEndDate)) {
            return new Date[]{debut, fin};
        }
        if (debut.compareTo(limitStartDate) <= 0 && fin.compareTo(limitEndDate) >= 0) {
            return new Date[]{limitStartDate, limitEndDate};
        }
        if (debut.compareTo(limitStartDate) < 0 && DateUtils.between(fin, limitStartDate, limitEndDate)) {
            return new Date[]{limitStartDate, fin};
        }
        if (DateUtils.between(debut, limitStartDate, limitEndDate) && fin.compareTo(limitEndDate) > 0) {
            return new Date[]{debut, limitEndDate};
        }
        return null;
    }
}

