/*
 * Decompiled with CFR 0.152.
 */
package latitude.utils;

public class DoubleUtils {
    public static double EARTH_RADIUS = 6371000.0;

    public static boolean isAbout(double a, double b, double precision) {
        return a > b - precision && a < b + precision;
    }

    public static boolean isBetweenOrEqual(double a, double min, double max) {
        return a >= min && a <= max;
    }

    public static double rotateX(double x, double y, double angle) {
        return x * Math.cos(angle) + y * Math.sin(angle);
    }

    public static double rotateY(double x, double y, double angle) {
        return -x * Math.sin(angle) + y * Math.cos(angle);
    }

    public static double degreeToRadian(double d) {
        return d * Math.PI / 180.0;
    }

    public static double radianToDegree(double r) {
        return r * 180.0 / Math.PI;
    }

    public static double normalizeDegreeAngle(double a) {
        while (a <= -180.0) {
            a += 360.0;
        }
        while (a > 180.0) {
            a -= 360.0;
        }
        return a;
    }

    public static double dmsToDecimalDegrees(String dms) {
        String[] a = dms.split("\u00b0", -1);
        String[] b = a[1].split("'", -1);
        double degrees = Double.parseDouble(a[0]);
        double minutes = Double.parseDouble(b[0]);
        double seconds = Double.parseDouble(b[1].replace("\"", "").replaceAll("[a-zA-Z]", ""));
        double decimal = (minutes * 60.0 + seconds) / 3600.0;
        double decimalDegrees = degrees + decimal;
        return decimalDegrees;
    }

    public static String roundToDecimal(double value, int numberOfDecimal) {
        return "" + (double)Math.round(value * Math.pow(10.0, numberOfDecimal)) / Math.pow(10.0, numberOfDecimal);
    }

    public static double geographicToArithmetic(double a) {
        return -a + 90.0;
    }

    public static double square(double a) {
        return a * a;
    }

    public static double squareDistance(double x1, double y1, double x2, double y2) {
        return DoubleUtils.square(y2 - y1) + DoubleUtils.square(x2 - x1);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(DoubleUtils.squareDistance(x1, y1, x2, y2));
    }

    public static double distanceLngLat(double lon1, double lat1, double lon2, double lat2) {
        double dLat = DoubleUtils.degreeToRadian(lat2 - lat1);
        double dLon = DoubleUtils.degreeToRadian(lon2 - lon1);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(DoubleUtils.degreeToRadian(lat1)) * Math.cos(DoubleUtils.degreeToRadian(lat2)) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double d = EARTH_RADIUS * c;
        return d;
    }

    public static double reduceDigits(double a, int nDigitsAfterComma) {
        double m = Math.pow(10.0, nDigitsAfterComma);
        return (double)Math.round(a * m) / m;
    }
}

