/*
 * Decompiled with CFR 0.152.
 */
package latitude.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import latitude.framework.LoggableBase;
import latitude.utils.StringUtils;

public class FileUtils
extends LoggableBase {
    public static String getProjectJarFilePath(Class mainClass, String jarFilename) throws IOException, URISyntaxException {
        String mainClassLocationPath = new File(mainClass.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
        if (mainClassLocationPath.endsWith(".jar")) {
            return mainClassLocationPath;
        }
        return String.valueOf(FileUtils.getProjectPath()) + "/" + jarFilename;
    }

    public static String getProjectPath() throws IOException, URISyntaxException {
        String fileUtilsLocationPath = new File(FileUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
        if (fileUtilsLocationPath.endsWith(".jar")) {
            return new File(FileUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
        }
        return new File(".").getCanonicalPath();
    }

    public static String[] separateFilePathAndName(String absoluteFilePath) {
        File file = new File(absoluteFilePath);
        return new String[]{file.getParent(), file.getName()};
    }

    public static String getFilenameWithoutExtension(File file) {
        String fileName = file.getName();
        return FileUtils.getFilenameWithoutExtension(fileName);
    }

    public static String getFilenameWithoutExtension(String filename) {
        int pos = filename.lastIndexOf(".");
        if (pos > 0) {
            filename = filename.substring(0, pos);
        }
        return filename;
    }

    public static String getExtension(String filename) {
        int pos = filename.lastIndexOf(".");
        if (pos > 0) {
            filename = filename.substring(pos);
        }
        return filename;
    }

    public static FilenameFilter getXMLFilenameFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String lowercaseName = name.toLowerCase();
                return lowercaseName.endsWith(".xml");
            }
        };
    }

    public static FilenameFilter getOSMFilenameFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String lowercaseName = name.toLowerCase();
                return lowercaseName.endsWith(".osm");
            }
        };
    }

    public static BufferedReader openUTF8File(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StringUtils.UTF8));
        reader.mark(4);
        if (65279 != reader.read()) {
            reader.reset();
        }
        return reader;
    }

    public static BufferedReader openANSIFile(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StringUtils.CP1252));
        return reader;
    }

    public static String fileToString(File file) throws IOException {
        BufferedReader bufferedReader = FileUtils.openUTF8File(file);
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append("\n");
        }
        bufferedReader.close();
        String string = stringBuilder.toString();
        return string;
    }

    public static File stringToFile(String filePath, String content) throws IOException {
        File file = new File(filePath);
        new File(file.getParent()).mkdirs();
        PrintWriter out = new PrintWriter(file, StringUtils.UTF8);
        out.write(content);
        out.flush();
        out.close();
        return file;
    }

    public static List<String> fileToStringArray(File file) throws IOException {
        BufferedReader bufferedReader = FileUtils.openUTF8File(file);
        String line = null;
        ArrayList<String> strings = new ArrayList<String>();
        while ((line = bufferedReader.readLine()) != null) {
            strings.add(line);
        }
        bufferedReader.close();
        return strings;
    }

    public static File arrayToFile(String filePath, List<String> stringArray) throws FileNotFoundException, UnsupportedEncodingException {
        return FileUtils.arrayToFile(filePath, stringArray, StringUtils.UTF8);
    }

    public static File arrayToFile(String filePath, List<String> stringArray, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        File file = new File(filePath);
        new File(file.getParent()).mkdirs();
        PrintWriter out = new PrintWriter(file, encoding);
        for (String s : stringArray) {
            out.write(String.valueOf(s) + "\n");
        }
        out.flush();
        out.close();
        return file;
    }

    public static File inputStreamToFile(InputStream inputStream, String filename) throws IOException {
        int bytesRead;
        FileOutputStream fos = new FileOutputStream(filename);
        byte[] buffer = new byte[1024];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            fos.write(buffer, 0, bytesRead);
        }
        inputStream.close();
        fos.flush();
        fos.close();
        return new File(filename);
    }

    public static List<String> getFilePathsFromFolderRecursively(String folderPath, String extension) {
        List<String> filenames = FileUtils.getFilenamesFromFolder(folderPath, extension, true);
        List<String> subFolders = FileUtils.getFolderNamesFromFolder(folderPath);
        for (String subFolder : subFolders) {
            filenames.addAll(FileUtils.getFilePathsFromFolderRecursively(String.valueOf(folderPath) + "/" + subFolder, extension));
        }
        return filenames;
    }

    public static List<String> getFilenamesFromFolder(String folderPath, final String extension, boolean withFullPath) {
        File folder = new File(folderPath);
        File[] files = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return extension == null || name.toLowerCase().endsWith("." + extension);
            }
        });
        ArrayList<String> filenames = new ArrayList<String>();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (withFullPath) {
                    filenames.add(files[i].getPath());
                } else {
                    filenames.add(files[i].getName());
                }
                ++i;
            }
        }
        return filenames;
    }

    public static String getFolderName(String folderPath) {
        File folder = new File(folderPath);
        return folder.getName();
    }

    public static List<String> getFolderNamesFromFolder(String folderPath) {
        File folder = new File(folderPath);
        File[] folders = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return new File(dir, name).isDirectory();
            }
        });
        ArrayList<String> filenames = new ArrayList<String>();
        if (folders != null) {
            int i = 0;
            while (i < folders.length) {
                filenames.add(folders[i].getName());
                ++i;
            }
        }
        return filenames;
    }

    public static void copy(File source, File dest) throws IOException {
        FileInputStream input = null;
        OutputStream output = null;
        try {
            int bytesRead;
            input = new FileInputStream(source);
            output = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            while ((bytesRead = ((InputStream)input).read(buf)) > 0) {
                output.write(buf, 0, bytesRead);
            }
        }
        finally {
            if (input != null) {
                ((InputStream)input).close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    public static void copyFolderContent(String originPath, String extension, String destPath) throws IOException {
        List<String> filenames = FileUtils.getFilenamesFromFolder(originPath, extension, false);
        for (String filename : filenames) {
            FileUtils.copy(new File(String.valueOf(originPath) + "/" + filename), new File(String.valueOf(destPath) + "/" + filename));
        }
    }

    public static String convertFilePathForExtendScriptToolkit(String filePath) throws UnsupportedEncodingException {
        String converted = filePath.replace("\\", "/");
        converted = converted.replace("D:", "/d");
        converted = converted.replace("C:", "/c");
        return converted;
    }

    public static String chooseFolder(String startPath, boolean fullPath) {
        JFileChooser fileChooser = new JFileChooser(startPath);
        fileChooser.setFileSelectionMode(1);
        int returnVal = fileChooser.showOpenDialog(null);
        if (returnVal == 0) {
            if (fullPath) {
                String folderName = fileChooser.getSelectedFile().getAbsolutePath();
                return folderName;
            }
            String folderName = fileChooser.getSelectedFile().getName();
            return folderName;
        }
        return null;
    }

    public static File chooseFile(String startPath, String extension, String fileTypeDescription) {
        JFileChooser fileChooser = new JFileChooser(startPath);
        fileChooser.setFileFilter(new FileNameExtensionFilter(fileTypeDescription, extension));
        int returnVal = fileChooser.showOpenDialog(null);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            return file;
        }
        return null;
    }

    public static void renameFilesWithSameName(String path, String filenameWithoutExtension, String toFilename) {
        File[] list;
        File[] fileArray = list = new File(path).listFiles();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith(filenameWithoutExtension)) {
                file.renameTo(new File(String.valueOf(path) + "/" + toFilename + FileUtils.getExtension(file.getName())));
            }
            ++n2;
        }
    }

    public static void deleteFolder(File folder) throws IOException {
        File[] entries;
        if (folder.isDirectory() && (entries = folder.listFiles()) != null) {
            File[] fileArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                File entry = fileArray[n2];
                FileUtils.deleteFolder(entry);
                ++n2;
            }
        }
        if (!folder.delete()) {
            throw new IOException("Failed to delete " + folder);
        }
    }

    public static String mntize(String path) {
        return path.replace("\\", "/").replace("D:", "/mnt/d").replace("C:", "/mnt/c");
    }

    public static boolean isCreatedToday(File file) {
        long lastModified = file.lastModified();
        long now = new Date().getTime();
        long diff = now - lastModified;
        return diff < 86400000L;
    }
}

