/*
 * Decompiled with CFR 0.152.
 */
package latitude.utils;

import java.text.Normalizer;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.text.WordUtils;

public class StringUtils {
    public static String UTF8 = "UTF-8";
    public static String ISO8859 = "ISO-8859-1";
    public static String WINDOWS1252 = "Windows-1252";
    public static String CP1252 = "Cp1252";

    public static String generateUUID() {
        return UUID.randomUUID().toString();
    }

    public static String makeSafeForGDBTableName(String s) {
        s = Normalizer.normalize(s, Normalizer.Form.NFD);
        if (Character.isDigit((s = s.replaceAll("[^\\p{ASCII}]", "")).charAt(0))) {
            s = "_" + s;
        }
        s = s.toUpperCase();
        s = s.replace("-", "_");
        s = s.replace("'", "_");
        s = s.replace("\"", "_");
        s = s.replace(",", "_");
        s = s.replace(":", "_");
        s = s.replace("&", "_");
        s = s.replace(".", "_");
        s = s.replace("+", "plus");
        s = s.replace("#", "diese");
        s = s.replace("=", "_");
        s = s.replace("(", "_");
        s = s.replace(")", "_");
        s = s.replace("[", "_");
        s = s.replace("]", "_");
        s = s.replace("{", "_");
        s = s.replace("}", "_");
        s = s.replace("\\", "_");
        s = s.replace("/", "_");
        s = s.replace(";", "_");
        return s.replace(" ", "_");
    }

    public static String makeSafeForGDBFieldName(String s) {
        return StringUtils.makeSafeForGDBTableName(s);
    }

    public static String makeSafeForFilename(String s, boolean isShapefile) {
        s = s.replace("<", "_");
        s = s.replace(">", "_");
        s = s.replace(":", "_");
        s = s.replace("\"", "_");
        s = s.replace("\\", "_");
        s = s.replace("/", "_");
        s = s.replace("|", "_");
        s = s.replace("?", "_");
        if (isShapefile) {
            s = s.replace(" ", "_");
            s = s.replace("'", "_");
        }
        return s.replace("*", "_");
    }

    public static String xmlAttrKV(String key, String value) {
        return String.valueOf(key) + "=\"" + value + "\"";
    }

    public static String getRandomRGBColorString() {
        Random random = new Random();
        String result = "";
        int i = 0;
        while (i < 3) {
            int c = random.nextInt(255);
            String s = Integer.toHexString(c);
            if (s.length() == 1) {
                s = "0" + s;
            }
            result = String.valueOf(result) + s;
            ++i;
        }
        return result;
    }

    public static String formatScaleForFilename(double scale) {
        double k = Math.floor(scale / 1000.0);
        double reste = scale - k * 1000.0;
        return String.valueOf((int)k) + "k" + (reste == 0.0 ? "e" : String.valueOf((int)Math.ceil(reste)) + "e");
    }

    public static boolean isInteger(String str) {
        return str != null && str.length() > 0 && str.matches("\\d*");
    }

    public static int numerise(String lineName) {
        if (StringUtils.isInteger(lineName)) {
            return Integer.parseInt(lineName);
        }
        if (lineName.length() > 0 && Character.isDigit(lineName.charAt(0))) {
            int n = 0;
            while (n < lineName.length() && Character.isDigit(lineName.charAt(n))) {
                ++n;
            }
            int number = Integer.parseInt(lineName.substring(0, n));
            return number;
        }
        return 0;
    }

    public static int compareLineNames(String name1, String name2, boolean lettersBeforeNumbers) {
        int int1 = StringUtils.numerise(name1);
        int int2 = StringUtils.numerise(name2);
        if (int1 > 0 && int2 > 0) {
            int intComparison = int1 - int2;
            if (intComparison == 0) {
                return name1.compareTo(name2);
            }
            return intComparison;
        }
        if (lettersBeforeNumbers) {
            String separationRegex = "(?x)                  # verbose regex mode on                    \n(?<=                  # Assert that the previous character is... \n \\p{L}               # a letter                                 \n)                     # and                                      \n(?=                   # that the next character is...            \n \\p{N}               # a digit.                                 \n)                     #                                          \n|                     # Or                                       \n(?<=\\p{N})(?=\\p{L}) # vice versa";
            String[] splitArray1 = name1.split(separationRegex);
            String[] splitArray2 = name2.split(separationRegex);
            if (splitArray1.length < 2 || splitArray2.length < 2) {
                return name1.compareTo(name2);
            }
            if (splitArray1[0].equals(splitArray2[0])) {
                return Integer.valueOf(StringUtils.numerise(splitArray1[1])).compareTo(StringUtils.numerise(splitArray2[1]));
            }
            return splitArray1[0].compareTo(splitArray2[0]);
        }
        if (int1 > 0) {
            return -1;
        }
        if (int2 > 0) {
            return 1;
        }
        return name1.compareTo(name2);
    }

    public static boolean isCapitalString(String s) {
        int i = s.length() - 1;
        while (i >= 0) {
            if (Character.getType(s.charAt(i)) == 2) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static String toLowerCaseCapitalized(String str) {
        String s = WordUtils.capitalize(str.toLowerCase(Locale.FRANCE));
        StringBuilder sb = new StringBuilder(s);
        int i = 0;
        while (i < sb.length() - 1) {
            if (sb.charAt(i) == '\'' || sb.charAt(i) == '-') {
                sb.setCharAt(i + 1, Character.toUpperCase(s.charAt(i + 1)));
            }
            ++i;
        }
        s = sb.toString();
        s = s.replace("Gare De L'", "Gare de l'");
        s = s.replace("Gare D", "Gare d");
        s = s.replace("Porte D", "Porte d");
        s = s.replace(" Rer", " RER");
        s = s.replace(" D'", " d'");
        s = s.replace("Metro", "M\u00e9tro");
        s = s.replace("Hopital", "H\u00f4pital");
        s = s.replace("Hotel", "H\u00f4tel");
        s = s.replace("Liberte", "Libert\u00e9");
        s = s.replace("Republique", "R\u00e9publique");
        s = s.replace("Republique", "R\u00e9publique");
        s = s.replace("-Sous-", "-sous-");
        s = s.replace("-Sur-", "-sur-");
        s = s.replace("-En-", "-en-");
        s = s.replace("-L\u00e8s-", "-l\u00e8s-");
        s = s.replace("-Le-", "-le-");
        s = s.replace("-La-", "-la-");
        s = s.replace("-Les-", "-les-");
        s = s.replace("-D-", "-du-");
        s = s.replace("-De-", "-de-");
        s = s.replace("-Des-", "-des-");
        s = s.replace("-D'", "-d'");
        s = s.replace(" Du ", " du ");
        s = s.replace(" De ", " de ");
        s = s.replace(" Des ", " des ");
        s = s.replace(" En ", " en ");
        s = s.replace(" Les ", " les ");
        s = s.replace(" Le ", " le ");
        s = s.replace(" La ", " la ");
        return s;
    }

    public static String[] wordWrap(String sentence, int maxCharsByLine) {
        String wrapped = WordUtils.wrap(sentence, maxCharsByLine, ";", false);
        return wrapped.split(";");
    }

    public static String[] splitByString(String toSplit, String separator) {
        boolean hasSeparator = toSplit.contains(separator);
        if (hasSeparator) {
            String before = toSplit.substring(0, toSplit.indexOf(separator));
            String after = toSplit.substring(toSplit.indexOf(separator) + separator.length());
            return new String[]{before, after};
        }
        return new String[]{toSplit};
    }

    public static boolean startsWithVowel(String a) {
        String vowels = "aeiou\u00e9\u00e8\u00ea";
        return vowels.indexOf(Character.toLowerCase(a.charAt(0))) != -1;
    }

    public static String replaceLast(String text, String regex, String replacement) {
        return text.replaceFirst("(?s)" + regex + "(?!.*?" + regex + ")", replacement);
    }
}

