/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;

public class Area {
    public static double ofRing(Coordinate[] ring) {
        return Math.abs(Area.ofRingSigned(ring));
    }

    public static double ofRing(CoordinateSequence ring) {
        return Math.abs(Area.ofRingSigned(ring));
    }

    public static double ofRingSigned(Coordinate[] ring) {
        if (ring.length < 3) {
            return 0.0;
        }
        double sum = 0.0;
        double x0 = ring[0].x;
        int i = 1;
        while (i < ring.length - 1) {
            double x = ring[i].x - x0;
            double y1 = ring[i + 1].y;
            double y2 = ring[i - 1].y;
            sum += x * (y2 - y1);
            ++i;
        }
        return sum / 2.0;
    }

    public static double ofRingSigned(CoordinateSequence ring) {
        int n = ring.size();
        if (n < 3) {
            return 0.0;
        }
        Coordinate p0 = new Coordinate();
        Coordinate p1 = new Coordinate();
        Coordinate p2 = new Coordinate();
        ring.getCoordinate(0, p1);
        ring.getCoordinate(1, p2);
        double x0 = p1.x;
        p2.x -= x0;
        double sum = 0.0;
        int i = 1;
        while (i < n - 1) {
            p0.y = p1.y;
            p1.x = p2.x;
            p1.y = p2.y;
            ring.getCoordinate(i + 1, p2);
            p2.x -= x0;
            sum += p1.x * (p0.y - p2.y);
            ++i;
        }
        return sum / 2.0;
    }
}

