/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class Centroid {
    private Coordinate areaBasePt = null;
    private Coordinate triangleCent3 = new Coordinate();
    private double areasum2 = 0.0;
    private Coordinate cg3 = new Coordinate();
    private Coordinate lineCentSum = new Coordinate();
    private double totalLength = 0.0;
    private int ptCount = 0;
    private Coordinate ptCentSum = new Coordinate();

    public static Coordinate getCentroid(Geometry geom) {
        Centroid cent = new Centroid(geom);
        return cent.getCentroid();
    }

    public Centroid(Geometry geom) {
        this.add(geom);
    }

    private void add(Geometry geom) {
        if (geom.isEmpty()) {
            return;
        }
        if (geom instanceof Point) {
            this.addPoint(geom.getCoordinate());
        } else if (geom instanceof LineString) {
            this.addLineSegments(geom.getCoordinates());
        } else if (geom instanceof Polygon) {
            Polygon poly = (Polygon)geom;
            this.add(poly);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            int i = 0;
            while (i < gc.getNumGeometries()) {
                this.add(gc.getGeometryN(i));
                ++i;
            }
        }
    }

    public Coordinate getCentroid() {
        Coordinate cent = new Coordinate();
        if (Math.abs(this.areasum2) > 0.0) {
            cent.x = this.cg3.x / 3.0 / this.areasum2;
            cent.y = this.cg3.y / 3.0 / this.areasum2;
        } else if (this.totalLength > 0.0) {
            cent.x = this.lineCentSum.x / this.totalLength;
            cent.y = this.lineCentSum.y / this.totalLength;
        } else if (this.ptCount > 0) {
            cent.x = this.ptCentSum.x / (double)this.ptCount;
            cent.y = this.ptCentSum.y / (double)this.ptCount;
        } else {
            return null;
        }
        return cent;
    }

    private void setAreaBasePoint(Coordinate basePt) {
        this.areaBasePt = basePt;
    }

    private void add(Polygon poly) {
        this.addShell(poly.getExteriorRing().getCoordinates());
        int i = 0;
        while (i < poly.getNumInteriorRing()) {
            this.addHole(poly.getInteriorRingN(i).getCoordinates());
            ++i;
        }
    }

    private void addShell(Coordinate[] pts) {
        if (pts.length > 0) {
            this.setAreaBasePoint(pts[0]);
        }
        boolean isPositiveArea = !Orientation.isCCW(pts);
        int i = 0;
        while (i < pts.length - 1) {
            this.addTriangle(this.areaBasePt, pts[i], pts[i + 1], isPositiveArea);
            ++i;
        }
        this.addLineSegments(pts);
    }

    private void addHole(Coordinate[] pts) {
        boolean isPositiveArea = Orientation.isCCW(pts);
        int i = 0;
        while (i < pts.length - 1) {
            this.addTriangle(this.areaBasePt, pts[i], pts[i + 1], isPositiveArea);
            ++i;
        }
        this.addLineSegments(pts);
    }

    private void addTriangle(Coordinate p0, Coordinate p1, Coordinate p2, boolean isPositiveArea) {
        double sign = isPositiveArea ? 1.0 : -1.0;
        Centroid.centroid3(p0, p1, p2, this.triangleCent3);
        double area2 = Centroid.area2(p0, p1, p2);
        this.cg3.x += sign * area2 * this.triangleCent3.x;
        this.cg3.y += sign * area2 * this.triangleCent3.y;
        this.areasum2 += sign * area2;
    }

    private static void centroid3(Coordinate p1, Coordinate p2, Coordinate p3, Coordinate c) {
        c.x = p1.x + p2.x + p3.x;
        c.y = p1.y + p2.y + p3.y;
    }

    private static double area2(Coordinate p1, Coordinate p2, Coordinate p3) {
        return (p2.x - p1.x) * (p3.y - p1.y) - (p3.x - p1.x) * (p2.y - p1.y);
    }

    private void addLineSegments(Coordinate[] pts) {
        double lineLen = 0.0;
        int i = 0;
        while (i < pts.length - 1) {
            double segmentLen = pts[i].distance(pts[i + 1]);
            if (segmentLen != 0.0) {
                lineLen += segmentLen;
                double midx = (pts[i].x + pts[i + 1].x) / 2.0;
                this.lineCentSum.x += segmentLen * midx;
                double midy = (pts[i].y + pts[i + 1].y) / 2.0;
                this.lineCentSum.y += segmentLen * midy;
            }
            ++i;
        }
        this.totalLength += lineLen;
        if (lineLen == 0.0 && pts.length > 0) {
            this.addPoint(pts[0]);
        }
    }

    private void addPoint(Coordinate pt) {
        ++this.ptCount;
        this.ptCentSum.x += pt.x;
        this.ptCentSum.y += pt.y;
    }
}

