/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Stack;
import java.util.TreeSet;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.util.Assert;
import org.locationtech.jts.util.UniqueCoordinateArrayFilter;

public class ConvexHull {
    private GeometryFactory geomFactory;
    private Coordinate[] inputPts;

    public ConvexHull(Geometry geometry) {
        this(ConvexHull.extractCoordinates(geometry), geometry.getFactory());
    }

    public ConvexHull(Coordinate[] pts, GeometryFactory geomFactory) {
        this.inputPts = UniqueCoordinateArrayFilter.filterCoordinates(pts);
        this.geomFactory = geomFactory;
    }

    private static Coordinate[] extractCoordinates(Geometry geom) {
        UniqueCoordinateArrayFilter filter = new UniqueCoordinateArrayFilter();
        geom.apply(filter);
        return filter.getCoordinates();
    }

    public Geometry getConvexHull() {
        if (this.inputPts.length == 0) {
            return this.geomFactory.createGeometryCollection();
        }
        if (this.inputPts.length == 1) {
            return this.geomFactory.createPoint(this.inputPts[0]);
        }
        if (this.inputPts.length == 2) {
            return this.geomFactory.createLineString(this.inputPts);
        }
        Coordinate[] reducedPts = this.inputPts;
        if (this.inputPts.length > 50) {
            reducedPts = this.reduce(this.inputPts);
        }
        Coordinate[] sortedPts = this.preSort(reducedPts);
        Stack cHS = this.grahamScan(sortedPts);
        Coordinate[] cH = this.toCoordinateArray(cHS);
        return this.lineOrPolygon(cH);
    }

    protected Coordinate[] toCoordinateArray(Stack stack) {
        Coordinate[] coordinates = new Coordinate[stack.size()];
        int i = 0;
        while (i < stack.size()) {
            Coordinate coordinate;
            coordinates[i] = coordinate = (Coordinate)stack.get(i);
            ++i;
        }
        return coordinates;
    }

    private Coordinate[] reduce(Coordinate[] inputPts) {
        Coordinate[] polyPts = this.computeOctRing(inputPts);
        if (polyPts == null) {
            return inputPts;
        }
        TreeSet<Coordinate> reducedSet = new TreeSet<Coordinate>();
        int i = 0;
        while (i < polyPts.length) {
            reducedSet.add(polyPts[i]);
            ++i;
        }
        i = 0;
        while (i < inputPts.length) {
            if (!PointLocation.isInRing(inputPts[i], polyPts)) {
                reducedSet.add(inputPts[i]);
            }
            ++i;
        }
        Coordinate[] reducedPts = CoordinateArrays.toCoordinateArray(reducedSet);
        if (reducedPts.length < 3) {
            return this.padArray3(reducedPts);
        }
        return reducedPts;
    }

    private Coordinate[] padArray3(Coordinate[] pts) {
        Coordinate[] pad = new Coordinate[3];
        int i = 0;
        while (i < pad.length) {
            pad[i] = i < pts.length ? pts[i] : pts[0];
            ++i;
        }
        return pad;
    }

    private Coordinate[] preSort(Coordinate[] pts) {
        int i = 1;
        while (i < pts.length) {
            if (pts[i].y < pts[0].y || pts[i].y == pts[0].y && pts[i].x < pts[0].x) {
                Coordinate t = pts[0];
                pts[0] = pts[i];
                pts[i] = t;
            }
            ++i;
        }
        Arrays.sort(pts, 1, pts.length, new RadialComparator(pts[0]));
        return pts;
    }

    private Stack grahamScan(Coordinate[] c) {
        Stack<Coordinate> ps = new Stack<Coordinate>();
        ps.push(c[0]);
        ps.push(c[1]);
        ps.push(c[2]);
        int i = 3;
        while (i < c.length) {
            Coordinate p = (Coordinate)ps.pop();
            while (!ps.empty() && Orientation.index((Coordinate)ps.peek(), p, c[i]) > 0) {
                p = (Coordinate)ps.pop();
            }
            ps.push(p);
            ps.push(c[i]);
            ++i;
        }
        ps.push(c[0]);
        return ps;
    }

    private boolean isBetween(Coordinate c1, Coordinate c2, Coordinate c3) {
        if (Orientation.index(c1, c2, c3) != 0) {
            return false;
        }
        if (c1.x != c3.x) {
            if (c1.x <= c2.x && c2.x <= c3.x) {
                return true;
            }
            if (c3.x <= c2.x && c2.x <= c1.x) {
                return true;
            }
        }
        if (c1.y != c3.y) {
            if (c1.y <= c2.y && c2.y <= c3.y) {
                return true;
            }
            if (c3.y <= c2.y && c2.y <= c1.y) {
                return true;
            }
        }
        return false;
    }

    private Coordinate[] computeOctRing(Coordinate[] inputPts) {
        Coordinate[] octPts = this.computeOctPts(inputPts);
        CoordinateList coordList = new CoordinateList();
        coordList.add(octPts, false);
        if (coordList.size() < 3) {
            return null;
        }
        coordList.closeRing();
        return coordList.toCoordinateArray();
    }

    private Coordinate[] computeOctPts(Coordinate[] inputPts) {
        Coordinate[] pts = new Coordinate[8];
        int j = 0;
        while (j < pts.length) {
            pts[j] = inputPts[0];
            ++j;
        }
        int i = 1;
        while (i < inputPts.length) {
            if (inputPts[i].x < pts[0].x) {
                pts[0] = inputPts[i];
            }
            if (inputPts[i].x - inputPts[i].y < pts[1].x - pts[1].y) {
                pts[1] = inputPts[i];
            }
            if (inputPts[i].y > pts[2].y) {
                pts[2] = inputPts[i];
            }
            if (inputPts[i].x + inputPts[i].y > pts[3].x + pts[3].y) {
                pts[3] = inputPts[i];
            }
            if (inputPts[i].x > pts[4].x) {
                pts[4] = inputPts[i];
            }
            if (inputPts[i].x - inputPts[i].y > pts[5].x - pts[5].y) {
                pts[5] = inputPts[i];
            }
            if (inputPts[i].y < pts[6].y) {
                pts[6] = inputPts[i];
            }
            if (inputPts[i].x + inputPts[i].y < pts[7].x + pts[7].y) {
                pts[7] = inputPts[i];
            }
            ++i;
        }
        return pts;
    }

    private Geometry lineOrPolygon(Coordinate[] coordinates) {
        if ((coordinates = this.cleanRing(coordinates)).length == 3) {
            return this.geomFactory.createLineString(new Coordinate[]{coordinates[0], coordinates[1]});
        }
        LinearRing linearRing = this.geomFactory.createLinearRing(coordinates);
        return this.geomFactory.createPolygon(linearRing);
    }

    private Coordinate[] cleanRing(Coordinate[] original) {
        Assert.equals(original[0], original[original.length - 1]);
        ArrayList<Coordinate> cleanedRing = new ArrayList<Coordinate>();
        Coordinate previousDistinctCoordinate = null;
        int i = 0;
        while (i <= original.length - 2) {
            Coordinate currentCoordinate = original[i];
            Coordinate nextCoordinate = original[i + 1];
            if (!(currentCoordinate.equals(nextCoordinate) || previousDistinctCoordinate != null && this.isBetween(previousDistinctCoordinate, currentCoordinate, nextCoordinate))) {
                cleanedRing.add(currentCoordinate);
                previousDistinctCoordinate = currentCoordinate;
            }
            ++i;
        }
        cleanedRing.add(original[original.length - 1]);
        Coordinate[] cleanedRingCoordinates = new Coordinate[cleanedRing.size()];
        return cleanedRing.toArray(cleanedRingCoordinates);
    }

    private static class RadialComparator
    implements Comparator {
        private Coordinate origin;

        public RadialComparator(Coordinate origin) {
            this.origin = origin;
        }

        public int compare(Object o1, Object o2) {
            Coordinate p1 = (Coordinate)o1;
            Coordinate p2 = (Coordinate)o2;
            return RadialComparator.polarCompare(this.origin, p1, p2);
        }

        private static int polarCompare(Coordinate o, Coordinate p, Coordinate q) {
            double dxp = p.x - o.x;
            double dyp = p.y - o.y;
            double dxq = q.x - o.x;
            double dyq = q.y - o.y;
            int orient = Orientation.index(o, p, q);
            if (orient == 1) {
                return 1;
            }
            if (orient == -1) {
                return -1;
            }
            double op = dxp * dxp + dyp * dyp;
            double oq = dxq * dxq + dyq * dyq;
            if (op < oq) {
                return -1;
            }
            if (op > oq) {
                return 1;
            }
            return 0;
        }
    }
}

