/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RayCrossingCounter;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;

public class PointLocation {
    public static boolean isOnLine(Coordinate p, Coordinate[] line) {
        RobustLineIntersector lineIntersector = new RobustLineIntersector();
        int i = 1;
        while (i < line.length) {
            Coordinate p0 = line[i - 1];
            Coordinate p1 = line[i];
            ((LineIntersector)lineIntersector).computeIntersection(p, p0, p1);
            if (lineIntersector.hasIntersection()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isOnLine(Coordinate p, CoordinateSequence line) {
        RobustLineIntersector lineIntersector = new RobustLineIntersector();
        Coordinate p0 = new Coordinate();
        Coordinate p1 = new Coordinate();
        int n = line.size();
        int i = 1;
        while (i < n) {
            line.getCoordinate(i - 1, p0);
            line.getCoordinate(i, p1);
            ((LineIntersector)lineIntersector).computeIntersection(p, p0, p1);
            if (lineIntersector.hasIntersection()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isInRing(Coordinate p, Coordinate[] ring) {
        return PointLocation.locateInRing(p, ring) != 2;
    }

    public static int locateInRing(Coordinate p, Coordinate[] ring) {
        return RayCrossingCounter.locatePointInRing(p, ring);
    }
}

