/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.awt;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.locationtech.jts.awt.GeometryCollectionShape;
import org.locationtech.jts.awt.IdentityPointTransformation;
import org.locationtech.jts.awt.PointShapeFactory;
import org.locationtech.jts.awt.PointTransformation;
import org.locationtech.jts.awt.PolygonShape;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class ShapeWriter {
    public static final PointTransformation DEFAULT_POINT_TRANSFORMATION = new IdentityPointTransformation();
    public static final PointShapeFactory DEFAULT_POINT_FACTORY = new PointShapeFactory.Square(3.0);
    private PointTransformation pointTransformer = DEFAULT_POINT_TRANSFORMATION;
    private PointShapeFactory pointFactory = DEFAULT_POINT_FACTORY;
    private Point2D transPoint = new Point2D.Double();
    private boolean doRemoveDuplicatePoints = false;
    private double decimationDistance = 0.0;

    public ShapeWriter(PointTransformation pointTransformer, PointShapeFactory pointFactory) {
        if (pointTransformer != null) {
            this.pointTransformer = pointTransformer;
        }
        if (pointFactory != null) {
            this.pointFactory = pointFactory;
        }
    }

    public ShapeWriter(PointTransformation pointTransformer) {
        this(pointTransformer, null);
    }

    public ShapeWriter() {
    }

    public void setRemoveDuplicatePoints(boolean doRemoveDuplicatePoints) {
        this.doRemoveDuplicatePoints = doRemoveDuplicatePoints;
    }

    public void setDecimation(double decimationDistance) {
        this.decimationDistance = decimationDistance;
    }

    public Shape toShape(Geometry geometry) {
        if (geometry.isEmpty()) {
            return new GeneralPath();
        }
        if (geometry instanceof Polygon) {
            return this.toShape((Polygon)geometry);
        }
        if (geometry instanceof LineString) {
            return this.toShape((LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.toShape((MultiLineString)geometry);
        }
        if (geometry instanceof Point) {
            return this.toShape((Point)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.toShape((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException("Unrecognized Geometry class: " + geometry.getClass());
    }

    private Shape toShape(Polygon p) {
        PolygonShape poly = new PolygonShape();
        this.appendRing(poly, p.getExteriorRing().getCoordinates());
        int j = 0;
        while (j < p.getNumInteriorRing()) {
            this.appendRing(poly, p.getInteriorRingN(j).getCoordinates());
            ++j;
        }
        return poly;
    }

    private void appendRing(PolygonShape poly, Coordinate[] coords) {
        if (coords.length == 0) {
            return;
        }
        double prevx = Double.NaN;
        double prevy = Double.NaN;
        Coordinate prev = null;
        int n = coords.length - 1;
        int i = 0;
        while (i < n) {
            block6: {
                block7: {
                    boolean isDup;
                    block5: {
                        boolean isDecimated;
                        if (!(this.decimationDistance > 0.0)) break block5;
                        boolean bl = isDecimated = prev != null && Math.abs(coords[i].x - prev.x) < this.decimationDistance && Math.abs(coords[i].y - prev.y) < this.decimationDistance;
                        if (i < n && isDecimated) break block6;
                        prev = coords[i];
                    }
                    this.transformPoint(coords[i], this.transPoint);
                    if (!this.doRemoveDuplicatePoints) break block7;
                    boolean bl = isDup = this.transPoint.getX() == prevx && this.transPoint.getY() == prevy;
                    if (i < n && isDup) break block6;
                    prevx = this.transPoint.getX();
                    prevy = this.transPoint.getY();
                }
                poly.addToRing(this.transPoint);
            }
            ++i;
        }
        poly.endRing();
    }

    private Shape toShape(GeometryCollection gc) {
        GeometryCollectionShape shape = new GeometryCollectionShape();
        int i = 0;
        while (i < gc.getNumGeometries()) {
            Geometry g = gc.getGeometryN(i);
            shape.add(this.toShape(g));
            ++i;
        }
        return shape;
    }

    private GeneralPath toShape(MultiLineString mls) {
        GeneralPath path = new GeneralPath();
        int i = 0;
        while (i < mls.getNumGeometries()) {
            LineString lineString = (LineString)mls.getGeometryN(i);
            path.append(this.toShape(lineString), false);
            ++i;
        }
        return path;
    }

    private GeneralPath toShape(LineString lineString) {
        GeneralPath shape = new GeneralPath();
        Coordinate prev = lineString.getCoordinateN(0);
        this.transformPoint(prev, this.transPoint);
        shape.moveTo((float)this.transPoint.getX(), (float)this.transPoint.getY());
        double prevx = this.transPoint.getX();
        double prevy = this.transPoint.getY();
        int n = lineString.getNumPoints() - 1;
        int i = 1;
        while (i <= n) {
            block4: {
                block5: {
                    boolean isDup;
                    Coordinate currentCoord;
                    block3: {
                        boolean isDecimated;
                        currentCoord = lineString.getCoordinateN(i);
                        if (!(this.decimationDistance > 0.0)) break block3;
                        boolean bl = isDecimated = prev != null && Math.abs(currentCoord.x - prev.x) < this.decimationDistance && Math.abs(currentCoord.y - prev.y) < this.decimationDistance;
                        if (i < n && isDecimated) break block4;
                        prev = currentCoord;
                    }
                    this.transformPoint(currentCoord, this.transPoint);
                    if (!this.doRemoveDuplicatePoints) break block5;
                    boolean bl = isDup = this.transPoint.getX() == prevx && this.transPoint.getY() == prevy;
                    if (i < n && isDup) break block4;
                    prevx = this.transPoint.getX();
                    prevy = this.transPoint.getY();
                }
                shape.lineTo((float)this.transPoint.getX(), (float)this.transPoint.getY());
            }
            ++i;
        }
        return shape;
    }

    private Shape toShape(Point point) {
        Point2D viewPoint = this.transformPoint(point.getCoordinate());
        return this.pointFactory.createPoint(viewPoint);
    }

    private Point2D transformPoint(Coordinate model) {
        return this.transformPoint(model, new Point2D.Double());
    }

    private Point2D transformPoint(Coordinate model, Point2D view) {
        this.pointTransformer.transform(model, view);
        return view;
    }
}

