/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.edgegraph;

import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.Quadrant;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.util.Assert;

public class HalfEdge {
    private Coordinate orig;
    private HalfEdge sym;
    private HalfEdge next;

    public static HalfEdge create(Coordinate p0, Coordinate p1) {
        HalfEdge e0 = new HalfEdge(p0);
        HalfEdge e1 = new HalfEdge(p1);
        e0.link(e1);
        return e0;
    }

    public HalfEdge(Coordinate orig) {
        this.orig = orig;
    }

    public void link(HalfEdge sym) {
        this.setSym(sym);
        sym.setSym(this);
        this.setNext(sym);
        sym.setNext(this);
    }

    public Coordinate orig() {
        return this.orig;
    }

    public Coordinate dest() {
        return this.sym.orig;
    }

    double directionX() {
        return this.directionPt().getX() - this.orig.getX();
    }

    double directionY() {
        return this.directionPt().getY() - this.orig.getY();
    }

    protected Coordinate directionPt() {
        return this.dest();
    }

    public HalfEdge sym() {
        return this.sym;
    }

    private void setSym(HalfEdge e) {
        this.sym = e;
    }

    public HalfEdge next() {
        return this.next;
    }

    public HalfEdge prev() {
        return this.sym.next().sym;
    }

    public HalfEdge oNext() {
        return this.sym.next;
    }

    public void setNext(HalfEdge e) {
        this.next = e;
    }

    public HalfEdge find(Coordinate dest) {
        HalfEdge oNext = this;
        do {
            if (oNext == null) {
                return null;
            }
            if (!oNext.dest().equals2D(dest)) continue;
            return oNext;
        } while ((oNext = oNext.oNext()) != this);
        return null;
    }

    public boolean equals(Coordinate p0, Coordinate p1) {
        return this.orig.equals2D(p0) && this.sym.orig.equals(p1);
    }

    public void insert(HalfEdge eAdd) {
        if (this.oNext() == this) {
            this.insertAfter(eAdd);
            return;
        }
        HalfEdge ePrev = this.insertionEdge(eAdd);
        ePrev.insertAfter(eAdd);
    }

    private HalfEdge insertionEdge(HalfEdge eAdd) {
        HalfEdge eNext;
        HalfEdge ePrev = this;
        do {
            if ((eNext = ePrev.oNext()).compareTo(ePrev) > 0 && eAdd.compareTo(ePrev) >= 0 && eAdd.compareTo(eNext) <= 0) {
                return ePrev;
            }
            if (eNext.compareTo(ePrev) > 0 || eAdd.compareTo(eNext) > 0 && eAdd.compareTo(ePrev) < 0) continue;
            return ePrev;
        } while ((ePrev = eNext) != this);
        Assert.shouldNeverReachHere();
        return null;
    }

    private void insertAfter(HalfEdge e) {
        Assert.equals(this.orig, e.orig());
        HalfEdge save = this.oNext();
        this.sym.setNext(e);
        e.sym().setNext(save);
    }

    public boolean isEdgesSorted() {
        HalfEdge eNext;
        HalfEdge lowest;
        HalfEdge e = lowest = this.findLowest();
        while ((eNext = e.oNext()) != lowest) {
            boolean isSorted;
            boolean bl = isSorted = eNext.compareTo(e) > 0;
            if (!isSorted) {
                return false;
            }
            e = eNext;
            if (e != lowest) continue;
        }
        return true;
    }

    private HalfEdge findLowest() {
        HalfEdge lowest = this;
        HalfEdge e = this.oNext();
        do {
            if (e.compareTo(lowest) >= 0) continue;
            lowest = e;
        } while ((e = e.oNext()) != this);
        return lowest;
    }

    public int compareTo(Object obj) {
        HalfEdge e = (HalfEdge)obj;
        int comp = this.compareAngularDirection(e);
        return comp;
    }

    public int compareAngularDirection(HalfEdge e) {
        int quadrant2;
        double dx = this.directionX();
        double dy = this.directionY();
        double dx2 = e.directionX();
        double dy2 = e.directionY();
        if (dx == dx2 && dy == dy2) {
            return 0;
        }
        int quadrant = Quadrant.quadrant(dx, dy);
        if (quadrant > (quadrant2 = Quadrant.quadrant(dx2, dy2))) {
            return 1;
        }
        if (quadrant < quadrant2) {
            return -1;
        }
        Coordinate dir1 = this.directionPt();
        Coordinate dir2 = e.directionPt();
        return Orientation.index(e.orig, dir2, dir1);
    }

    public String toString() {
        return "HE(" + this.orig.x + " " + this.orig.y + ", " + this.sym.orig.x + " " + this.sym.orig.y + ")";
    }

    public String toStringNode() {
        Coordinate orig = this.orig();
        Coordinate dest = this.dest();
        StringBuilder sb = new StringBuilder();
        sb.append("Node( " + WKTWriter.format(orig) + " )" + "\n");
        HalfEdge e = this;
        do {
            sb.append("  -> " + e);
            sb.append("\n");
        } while ((e = e.oNext()) != this);
        return sb.toString();
    }

    private String toStringNodeEdge() {
        return "  -> (" + WKTWriter.format(this.dest());
    }

    public int degree() {
        int degree = 0;
        HalfEdge e = this;
        do {
            ++degree;
        } while ((e = e.oNext()) != this);
        return degree;
    }

    public HalfEdge prevNode() {
        HalfEdge e = this;
        while (e.degree() == 2) {
            if ((e = e.prev()) != this) continue;
            return null;
        }
        return e;
    }
}

