/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.util.Collection;
import java.util.Comparator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Coordinates;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.math.MathUtil;

public class CoordinateArrays {
    private static final Coordinate[] coordArrayType = new Coordinate[0];

    private CoordinateArrays() {
    }

    public static int dimension(Coordinate[] pts) {
        if (pts == null || pts.length == 0) {
            return 3;
        }
        int dimension = 0;
        Coordinate[] coordinateArray = pts;
        int n = pts.length;
        int n2 = 0;
        while (n2 < n) {
            Coordinate coordinate = coordinateArray[n2];
            dimension = Math.max(dimension, Coordinates.dimension(coordinate));
            ++n2;
        }
        return dimension;
    }

    public static int measures(Coordinate[] pts) {
        if (pts == null || pts.length == 0) {
            return 0;
        }
        int measures = 0;
        Coordinate[] coordinateArray = pts;
        int n = pts.length;
        int n2 = 0;
        while (n2 < n) {
            Coordinate coordinate = coordinateArray[n2];
            measures = Math.max(measures, Coordinates.measures(coordinate));
            ++n2;
        }
        return measures;
    }

    public static boolean isRing(Coordinate[] pts) {
        if (pts.length < 4) {
            return false;
        }
        return pts[0].equals2D(pts[pts.length - 1]);
    }

    public static Coordinate ptNotInList(Coordinate[] testPts, Coordinate[] pts) {
        int i = 0;
        while (i < testPts.length) {
            Coordinate testPt = testPts[i];
            if (CoordinateArrays.indexOf(testPt, pts) < 0) {
                return testPt;
            }
            ++i;
        }
        return null;
    }

    public static int compare(Coordinate[] pts1, Coordinate[] pts2) {
        int i = 0;
        while (i < pts1.length && i < pts2.length) {
            int compare = pts1[i].compareTo(pts2[i]);
            if (compare != 0) {
                return compare;
            }
            ++i;
        }
        if (i < pts2.length) {
            return -1;
        }
        if (i < pts1.length) {
            return 1;
        }
        return 0;
    }

    public static int increasingDirection(Coordinate[] pts) {
        int i = 0;
        while (i < pts.length / 2) {
            int j = pts.length - 1 - i;
            int comp = pts[i].compareTo(pts[j]);
            if (comp != 0) {
                return comp;
            }
            ++i;
        }
        return 1;
    }

    private static boolean isEqualReversed(Coordinate[] pts1, Coordinate[] pts2) {
        int i = 0;
        while (i < pts1.length) {
            Coordinate p1 = pts1[i];
            Coordinate p2 = pts2[pts1.length - i - 1];
            if (p1.compareTo(p2) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Coordinate[] copyDeep(Coordinate[] coordinates) {
        Coordinate[] copy = new Coordinate[coordinates.length];
        int i = 0;
        while (i < coordinates.length) {
            copy[i] = coordinates[i].copy();
            ++i;
        }
        return copy;
    }

    public static void copyDeep(Coordinate[] src, int srcStart, Coordinate[] dest, int destStart, int length) {
        int i = 0;
        while (i < length) {
            dest[destStart + i] = src[srcStart + i].copy();
            ++i;
        }
    }

    public static Coordinate[] toCoordinateArray(Collection coordList) {
        return coordList.toArray(coordArrayType);
    }

    public static boolean hasRepeatedPoints(Coordinate[] coord) {
        int i = 1;
        while (i < coord.length) {
            if (coord[i - 1].equals(coord[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Coordinate[] atLeastNCoordinatesOrNothing(int n, Coordinate[] c) {
        return c.length >= n ? c : new Coordinate[]{};
    }

    public static Coordinate[] removeRepeatedPoints(Coordinate[] coord) {
        if (!CoordinateArrays.hasRepeatedPoints(coord)) {
            return coord;
        }
        CoordinateList coordList = new CoordinateList(coord, false);
        return coordList.toCoordinateArray();
    }

    public static Coordinate[] removeNull(Coordinate[] coord) {
        int nonNull = 0;
        int i = 0;
        while (i < coord.length) {
            if (coord[i] != null) {
                ++nonNull;
            }
            ++i;
        }
        Coordinate[] newCoord = new Coordinate[nonNull];
        if (nonNull == 0) {
            return newCoord;
        }
        int j = 0;
        int i2 = 0;
        while (i2 < coord.length) {
            if (coord[i2] != null) {
                newCoord[j++] = coord[i2];
            }
            ++i2;
        }
        return newCoord;
    }

    public static void reverse(Coordinate[] coord) {
        int last = coord.length - 1;
        int mid = last / 2;
        int i = 0;
        while (i <= mid) {
            Coordinate tmp = coord[i];
            coord[i] = coord[last - i];
            coord[last - i] = tmp;
            ++i;
        }
    }

    public static boolean equals(Coordinate[] coord1, Coordinate[] coord2) {
        if (coord1 == coord2) {
            return true;
        }
        if (coord1 == null || coord2 == null) {
            return false;
        }
        if (coord1.length != coord2.length) {
            return false;
        }
        int i = 0;
        while (i < coord1.length) {
            if (!coord1[i].equals(coord2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(Coordinate[] coord1, Coordinate[] coord2, Comparator coordinateComparator) {
        if (coord1 == coord2) {
            return true;
        }
        if (coord1 == null || coord2 == null) {
            return false;
        }
        if (coord1.length != coord2.length) {
            return false;
        }
        int i = 0;
        while (i < coord1.length) {
            if (coordinateComparator.compare(coord1[i], coord2[i]) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Coordinate minCoordinate(Coordinate[] coordinates) {
        Coordinate minCoord = null;
        int i = 0;
        while (i < coordinates.length) {
            if (minCoord == null || minCoord.compareTo(coordinates[i]) > 0) {
                minCoord = coordinates[i];
            }
            ++i;
        }
        return minCoord;
    }

    public static void scroll(Coordinate[] coordinates, Coordinate firstCoordinate) {
        int i = CoordinateArrays.indexOf(firstCoordinate, coordinates);
        if (i < 0) {
            return;
        }
        Coordinate[] newCoordinates = new Coordinate[coordinates.length];
        System.arraycopy(coordinates, i, newCoordinates, 0, coordinates.length - i);
        System.arraycopy(coordinates, 0, newCoordinates, coordinates.length - i, i);
        System.arraycopy(newCoordinates, 0, coordinates, 0, coordinates.length);
    }

    public static int indexOf(Coordinate coordinate, Coordinate[] coordinates) {
        int i = 0;
        while (i < coordinates.length) {
            if (coordinate.equals(coordinates[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Coordinate[] extract(Coordinate[] pts, int start, int end) {
        start = MathUtil.clamp(start, 0, pts.length);
        end = MathUtil.clamp(end, -1, pts.length);
        int npts = end - start + 1;
        if (end < 0) {
            npts = 0;
        }
        if (start >= pts.length) {
            npts = 0;
        }
        if (end < start) {
            npts = 0;
        }
        Coordinate[] extractPts = new Coordinate[npts];
        if (npts == 0) {
            return extractPts;
        }
        int iPts = 0;
        int i = start;
        while (i <= end) {
            extractPts[iPts++] = pts[i];
            ++i;
        }
        return extractPts;
    }

    public static Envelope envelope(Coordinate[] coordinates) {
        Envelope env = new Envelope();
        int i = 0;
        while (i < coordinates.length) {
            env.expandToInclude(coordinates[i]);
            ++i;
        }
        return env;
    }

    public static Coordinate[] intersection(Coordinate[] coordinates, Envelope env) {
        CoordinateList coordList = new CoordinateList();
        int i = 0;
        while (i < coordinates.length) {
            if (env.intersects(coordinates[i])) {
                coordList.add(coordinates[i], true);
            }
            ++i;
        }
        return coordList.toCoordinateArray();
    }

    public static class BidirectionalComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Coordinate[] pts1 = (Coordinate[])o1;
            Coordinate[] pts2 = (Coordinate[])o2;
            if (pts1.length < pts2.length) {
                return -1;
            }
            if (pts1.length > pts2.length) {
                return 1;
            }
            if (pts1.length == 0) {
                return 0;
            }
            int forwardComp = CoordinateArrays.compare(pts1, pts2);
            boolean isEqualRev = CoordinateArrays.isEqualReversed(pts1, pts2);
            if (isEqualRev) {
                return 0;
            }
            return forwardComp;
        }

        public int OLDcompare(Object o1, Object o2) {
            Coordinate[] pts1 = (Coordinate[])o1;
            Coordinate[] pts2 = (Coordinate[])o2;
            if (pts1.length < pts2.length) {
                return -1;
            }
            if (pts1.length > pts2.length) {
                return 1;
            }
            if (pts1.length == 0) {
                return 0;
            }
            int dir1 = CoordinateArrays.increasingDirection(pts1);
            int dir2 = CoordinateArrays.increasingDirection(pts2);
            int i1 = dir1 > 0 ? 0 : pts1.length - 1;
            int i2 = dir2 > 0 ? 0 : pts1.length - 1;
            int i = 0;
            while (i < pts1.length) {
                int comparePt = pts1[i1].compareTo(pts2[i2]);
                if (comparePt != 0) {
                    return comparePt;
                }
                i1 += dir1;
                i2 += dir2;
                ++i;
            }
            return 0;
        }
    }

    public static class ForwardComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Coordinate[] pts1 = (Coordinate[])o1;
            Coordinate[] pts2 = (Coordinate[])o2;
            return CoordinateArrays.compare(pts1, pts2);
        }
    }
}

