/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.io.OrdinateFormat;

public class CoordinateSequences {
    public static void reverse(CoordinateSequence seq) {
        int last = seq.size() - 1;
        int mid = last / 2;
        int i = 0;
        while (i <= mid) {
            CoordinateSequences.swap(seq, i, last - i);
            ++i;
        }
    }

    public static void swap(CoordinateSequence seq, int i, int j) {
        if (i == j) {
            return;
        }
        int dim = 0;
        while (dim < seq.getDimension()) {
            double tmp = seq.getOrdinate(i, dim);
            seq.setOrdinate(i, dim, seq.getOrdinate(j, dim));
            seq.setOrdinate(j, dim, tmp);
            ++dim;
        }
    }

    public static void copy(CoordinateSequence src, int srcPos, CoordinateSequence dest, int destPos, int length) {
        int i = 0;
        while (i < length) {
            CoordinateSequences.copyCoord(src, srcPos + i, dest, destPos + i);
            ++i;
        }
    }

    public static void copyCoord(CoordinateSequence src, int srcPos, CoordinateSequence dest, int destPos) {
        int minDim = Math.min(src.getDimension(), dest.getDimension());
        int dim = 0;
        while (dim < minDim) {
            dest.setOrdinate(destPos, dim, src.getOrdinate(srcPos, dim));
            ++dim;
        }
    }

    public static boolean isRing(CoordinateSequence seq) {
        int n = seq.size();
        if (n == 0) {
            return true;
        }
        if (n <= 3) {
            return false;
        }
        return seq.getOrdinate(0, 0) == seq.getOrdinate(n - 1, 0) && seq.getOrdinate(0, 1) == seq.getOrdinate(n - 1, 1);
    }

    public static CoordinateSequence ensureValidRing(CoordinateSequenceFactory fact, CoordinateSequence seq) {
        boolean isClosed;
        int n = seq.size();
        if (n == 0) {
            return seq;
        }
        if (n <= 3) {
            return CoordinateSequences.createClosedRing(fact, seq, 4);
        }
        boolean bl = isClosed = seq.getOrdinate(0, 0) == seq.getOrdinate(n - 1, 0) && seq.getOrdinate(0, 1) == seq.getOrdinate(n - 1, 1);
        if (isClosed) {
            return seq;
        }
        return CoordinateSequences.createClosedRing(fact, seq, n + 1);
    }

    private static CoordinateSequence createClosedRing(CoordinateSequenceFactory fact, CoordinateSequence seq, int size) {
        CoordinateSequence newseq = fact.create(size, seq.getDimension());
        int n = seq.size();
        CoordinateSequences.copy(seq, 0, newseq, 0, n);
        int i = n;
        while (i < size) {
            CoordinateSequences.copy(seq, 0, newseq, i, 1);
            ++i;
        }
        return newseq;
    }

    public static CoordinateSequence extend(CoordinateSequenceFactory fact, CoordinateSequence seq, int size) {
        CoordinateSequence newseq = fact.create(size, seq.getDimension());
        int n = seq.size();
        CoordinateSequences.copy(seq, 0, newseq, 0, n);
        if (n > 0) {
            int i = n;
            while (i < size) {
                CoordinateSequences.copy(seq, n - 1, newseq, i, 1);
                ++i;
            }
        }
        return newseq;
    }

    public static boolean isEqual(CoordinateSequence cs1, CoordinateSequence cs2) {
        int cs2Size;
        int cs1Size = cs1.size();
        if (cs1Size != (cs2Size = cs2.size())) {
            return false;
        }
        int dim = Math.min(cs1.getDimension(), cs2.getDimension());
        int i = 0;
        while (i < cs1Size) {
            int d = 0;
            while (d < dim) {
                double v1 = cs1.getOrdinate(i, d);
                double v2 = cs2.getOrdinate(i, d);
                if (!(cs1.getOrdinate(i, d) == cs2.getOrdinate(i, d) || Double.isNaN(v1) && Double.isNaN(v2))) {
                    return false;
                }
                ++d;
            }
            ++i;
        }
        return true;
    }

    public static String toString(CoordinateSequence cs) {
        int size = cs.size();
        if (size == 0) {
            return "()";
        }
        int dim = cs.getDimension();
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        int i = 0;
        while (i < size) {
            if (i > 0) {
                builder.append(" ");
            }
            int d = 0;
            while (d < dim) {
                if (d > 0) {
                    builder.append(",");
                }
                builder.append(OrdinateFormat.DEFAULT.format(cs.getOrdinate(i, d)));
                ++d;
            }
            ++i;
        }
        builder.append(')');
        return builder.toString();
    }

    public static Coordinate minCoordinate(CoordinateSequence seq) {
        Coordinate minCoord = null;
        int i = 0;
        while (i < seq.size()) {
            Coordinate testCoord = seq.getCoordinate(i);
            if (minCoord == null || minCoord.compareTo(testCoord) > 0) {
                minCoord = testCoord;
            }
            ++i;
        }
        return minCoord;
    }

    public static int minCoordinateIndex(CoordinateSequence seq) {
        return CoordinateSequences.minCoordinateIndex(seq, 0, seq.size() - 1);
    }

    public static int minCoordinateIndex(CoordinateSequence seq, int from, int to) {
        int minCoordIndex = -1;
        Coordinate minCoord = null;
        int i = from;
        while (i <= to) {
            Coordinate testCoord = seq.getCoordinate(i);
            if (minCoord == null || minCoord.compareTo(testCoord) > 0) {
                minCoord = testCoord;
                minCoordIndex = i;
            }
            ++i;
        }
        return minCoordIndex;
    }

    public static void scroll(CoordinateSequence seq, Coordinate firstCoordinate) {
        int i = CoordinateSequences.indexOf(firstCoordinate, seq);
        if (i <= 0) {
            return;
        }
        CoordinateSequences.scroll(seq, i);
    }

    public static void scroll(CoordinateSequence seq, int indexOfFirstCoordinate) {
        CoordinateSequences.scroll(seq, indexOfFirstCoordinate, CoordinateSequences.isRing(seq));
    }

    public static void scroll(CoordinateSequence seq, int indexOfFirstCoordinate, boolean ensureRing) {
        int i = indexOfFirstCoordinate;
        if (i <= 0) {
            return;
        }
        CoordinateSequence copy = seq.copy();
        int last = ensureRing ? seq.size() - 1 : seq.size();
        int j = 0;
        while (j < last) {
            int k = 0;
            while (k < seq.getDimension()) {
                seq.setOrdinate(j, k, copy.getOrdinate((indexOfFirstCoordinate + j) % last, k));
                ++k;
            }
            ++j;
        }
        if (ensureRing) {
            int k = 0;
            while (k < seq.getDimension()) {
                seq.setOrdinate(last, k, seq.getOrdinate(0, k));
                ++k;
            }
        }
    }

    public static int indexOf(Coordinate coordinate, CoordinateSequence seq) {
        int i = 0;
        while (i < seq.size()) {
            if (coordinate.x == seq.getOrdinate(i, 0) && coordinate.y == seq.getOrdinate(i, 1)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

