/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.util.Arrays;
import java.util.TreeSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.util.Assert;

public class GeometryCollection
extends Geometry {
    private static final long serialVersionUID = -5694727726395021467L;
    protected Geometry[] geometries;

    public GeometryCollection(Geometry[] geometries, PrecisionModel precisionModel, int SRID) {
        this(geometries, new GeometryFactory(precisionModel, SRID));
    }

    public GeometryCollection(Geometry[] geometries, GeometryFactory factory) {
        super(factory);
        if (geometries == null) {
            geometries = new Geometry[]{};
        }
        if (GeometryCollection.hasNullElements(geometries)) {
            throw new IllegalArgumentException("geometries must not contain null elements");
        }
        this.geometries = geometries;
    }

    @Override
    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.geometries[0].getCoordinate();
    }

    @Override
    public Coordinate[] getCoordinates() {
        Coordinate[] coordinates = new Coordinate[this.getNumPoints()];
        int k = -1;
        int i = 0;
        while (i < this.geometries.length) {
            Coordinate[] childCoordinates = this.geometries[i].getCoordinates();
            int j = 0;
            while (j < childCoordinates.length) {
                coordinates[++k] = childCoordinates[j];
                ++j;
            }
            ++i;
        }
        return coordinates;
    }

    @Override
    public boolean isEmpty() {
        int i = 0;
        while (i < this.geometries.length) {
            if (!this.geometries[i].isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int getDimension() {
        int dimension = -1;
        int i = 0;
        while (i < this.geometries.length) {
            dimension = Math.max(dimension, this.geometries[i].getDimension());
            ++i;
        }
        return dimension;
    }

    @Override
    public int getBoundaryDimension() {
        int dimension = -1;
        int i = 0;
        while (i < this.geometries.length) {
            dimension = Math.max(dimension, this.geometries[i].getBoundaryDimension());
            ++i;
        }
        return dimension;
    }

    @Override
    public int getNumGeometries() {
        return this.geometries.length;
    }

    @Override
    public Geometry getGeometryN(int n) {
        return this.geometries[n];
    }

    @Override
    public int getNumPoints() {
        int numPoints = 0;
        int i = 0;
        while (i < this.geometries.length) {
            numPoints += this.geometries[i].getNumPoints();
            ++i;
        }
        return numPoints;
    }

    @Override
    public String getGeometryType() {
        return "GeometryCollection";
    }

    @Override
    public Geometry getBoundary() {
        GeometryCollection.checkNotGeometryCollection(this);
        Assert.shouldNeverReachHere();
        return null;
    }

    @Override
    public double getArea() {
        double area = 0.0;
        int i = 0;
        while (i < this.geometries.length) {
            area += this.geometries[i].getArea();
            ++i;
        }
        return area;
    }

    @Override
    public double getLength() {
        double sum = 0.0;
        int i = 0;
        while (i < this.geometries.length) {
            sum += this.geometries[i].getLength();
            ++i;
        }
        return sum;
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        GeometryCollection otherCollection = (GeometryCollection)other;
        if (this.geometries.length != otherCollection.geometries.length) {
            return false;
        }
        int i = 0;
        while (i < this.geometries.length) {
            if (!this.geometries[i].equalsExact(otherCollection.geometries[i], tolerance)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void apply(CoordinateFilter filter) {
        int i = 0;
        while (i < this.geometries.length) {
            this.geometries[i].apply(filter);
            ++i;
        }
    }

    @Override
    public void apply(CoordinateSequenceFilter filter) {
        if (this.geometries.length == 0) {
            return;
        }
        int i = 0;
        while (i < this.geometries.length) {
            this.geometries[i].apply(filter);
            if (filter.isDone()) break;
            ++i;
        }
        if (filter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    @Override
    public void apply(GeometryFilter filter) {
        filter.filter(this);
        int i = 0;
        while (i < this.geometries.length) {
            this.geometries[i].apply(filter);
            ++i;
        }
    }

    @Override
    public void apply(GeometryComponentFilter filter) {
        filter.filter(this);
        int i = 0;
        while (i < this.geometries.length) {
            this.geometries[i].apply(filter);
            ++i;
        }
    }

    @Override
    public Object clone() {
        return this.copy();
    }

    @Override
    protected GeometryCollection copyInternal() {
        Geometry[] geometries = new Geometry[this.geometries.length];
        int i = 0;
        while (i < geometries.length) {
            geometries[i] = this.geometries[i].copy();
            ++i;
        }
        return new GeometryCollection(geometries, this.factory);
    }

    @Override
    public void normalize() {
        int i = 0;
        while (i < this.geometries.length) {
            this.geometries[i].normalize();
            ++i;
        }
        Arrays.sort(this.geometries);
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        Envelope envelope = new Envelope();
        int i = 0;
        while (i < this.geometries.length) {
            envelope.expandToInclude(this.geometries[i].getEnvelopeInternal());
            ++i;
        }
        return envelope;
    }

    @Override
    protected int compareToSameClass(Object o) {
        TreeSet<Geometry> theseElements = new TreeSet<Geometry>(Arrays.asList(this.geometries));
        TreeSet<Geometry> otherElements = new TreeSet<Geometry>(Arrays.asList(((GeometryCollection)o).geometries));
        return this.compare(theseElements, otherElements);
    }

    @Override
    protected int compareToSameClass(Object o, CoordinateSequenceComparator comp) {
        GeometryCollection gc = (GeometryCollection)o;
        int n1 = this.getNumGeometries();
        int n2 = gc.getNumGeometries();
        int i = 0;
        while (i < n1 && i < n2) {
            Geometry otherGeom;
            Geometry thisGeom = this.getGeometryN(i);
            int holeComp = thisGeom.compareToSameClass(otherGeom = gc.getGeometryN(i), comp);
            if (holeComp != 0) {
                return holeComp;
            }
            ++i;
        }
        if (i < n1) {
            return 1;
        }
        if (i < n2) {
            return -1;
        }
        return 0;
    }

    @Override
    protected int getSortIndex() {
        return 7;
    }

    @Override
    public Geometry reverse() {
        int n = this.geometries.length;
        Geometry[] revGeoms = new Geometry[n];
        int i = 0;
        while (i < this.geometries.length) {
            revGeoms[i] = this.geometries[i].reverse();
            ++i;
        }
        return this.getFactory().createGeometryCollection(revGeoms);
    }
}

