/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.util.ArrayList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.PrecisionModel;

public class MultiPolygon
extends GeometryCollection
implements Polygonal {
    private static final long serialVersionUID = -551033529766975875L;

    public MultiPolygon(Polygon[] polygons, PrecisionModel precisionModel, int SRID) {
        this(polygons, new GeometryFactory(precisionModel, SRID));
    }

    public MultiPolygon(Polygon[] polygons, GeometryFactory factory) {
        super(polygons, factory);
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public int getBoundaryDimension() {
        return 1;
    }

    @Override
    public String getGeometryType() {
        return "MultiPolygon";
    }

    @Override
    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return this.getFactory().createMultiLineString();
        }
        ArrayList<Geometry> allRings = new ArrayList<Geometry>();
        int i = 0;
        while (i < this.geometries.length) {
            Polygon polygon = (Polygon)this.geometries[i];
            Geometry rings = polygon.getBoundary();
            int j = 0;
            while (j < rings.getNumGeometries()) {
                allRings.add(rings.getGeometryN(j));
                ++j;
            }
            ++i;
        }
        LineString[] allRingsArray = new LineString[allRings.size()];
        return this.getFactory().createMultiLineString(allRings.toArray(allRingsArray));
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        return super.equalsExact(other, tolerance);
    }

    @Override
    public Geometry reverse() {
        int n = this.geometries.length;
        Polygon[] revGeoms = new Polygon[n];
        int i = 0;
        while (i < this.geometries.length) {
            revGeoms[i] = (Polygon)this.geometries[i].reverse();
            ++i;
        }
        return this.getFactory().createMultiPolygon(revGeoms);
    }

    @Override
    protected MultiPolygon copyInternal() {
        Polygon[] polygons = new Polygon[this.geometries.length];
        int i = 0;
        while (i < polygons.length) {
            polygons[i] = (Polygon)this.geometries[i].copy();
            ++i;
        }
        return new MultiPolygon(polygons, this.factory);
    }

    @Override
    protected int getSortIndex() {
        return 6;
    }
}

