/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.util.Arrays;
import org.locationtech.jts.algorithm.Area;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.PrecisionModel;

public class Polygon
extends Geometry
implements Polygonal {
    private static final long serialVersionUID = -3494792200821764533L;
    protected LinearRing shell = null;
    protected LinearRing[] holes;

    public Polygon(LinearRing shell, PrecisionModel precisionModel, int SRID) {
        this(shell, new LinearRing[0], new GeometryFactory(precisionModel, SRID));
    }

    public Polygon(LinearRing shell, LinearRing[] holes, PrecisionModel precisionModel, int SRID) {
        this(shell, holes, new GeometryFactory(precisionModel, SRID));
    }

    public Polygon(LinearRing shell, LinearRing[] holes, GeometryFactory factory) {
        super(factory);
        if (shell == null) {
            shell = this.getFactory().createLinearRing();
        }
        if (holes == null) {
            holes = new LinearRing[]{};
        }
        if (Polygon.hasNullElements(holes)) {
            throw new IllegalArgumentException("holes must not contain null elements");
        }
        if (shell.isEmpty() && Polygon.hasNonEmptyElements(holes)) {
            throw new IllegalArgumentException("shell is empty but holes are not");
        }
        this.shell = shell;
        this.holes = holes;
    }

    @Override
    public Coordinate getCoordinate() {
        return this.shell.getCoordinate();
    }

    @Override
    public Coordinate[] getCoordinates() {
        if (this.isEmpty()) {
            return new Coordinate[0];
        }
        Coordinate[] coordinates = new Coordinate[this.getNumPoints()];
        int k = -1;
        Coordinate[] shellCoordinates = this.shell.getCoordinates();
        int x = 0;
        while (x < shellCoordinates.length) {
            coordinates[++k] = shellCoordinates[x];
            ++x;
        }
        int i = 0;
        while (i < this.holes.length) {
            Coordinate[] childCoordinates = this.holes[i].getCoordinates();
            int j = 0;
            while (j < childCoordinates.length) {
                coordinates[++k] = childCoordinates[j];
                ++j;
            }
            ++i;
        }
        return coordinates;
    }

    @Override
    public int getNumPoints() {
        int numPoints = this.shell.getNumPoints();
        int i = 0;
        while (i < this.holes.length) {
            numPoints += this.holes[i].getNumPoints();
            ++i;
        }
        return numPoints;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public int getBoundaryDimension() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return this.shell.isEmpty();
    }

    @Override
    public boolean isRectangle() {
        if (this.getNumInteriorRing() != 0) {
            return false;
        }
        if (this.shell == null) {
            return false;
        }
        if (this.shell.getNumPoints() != 5) {
            return false;
        }
        CoordinateSequence seq = this.shell.getCoordinateSequence();
        Envelope env = this.getEnvelopeInternal();
        int i = 0;
        while (i < 5) {
            double x = seq.getX(i);
            if (x != env.getMinX() && x != env.getMaxX()) {
                return false;
            }
            double y = seq.getY(i);
            if (y != env.getMinY() && y != env.getMaxY()) {
                return false;
            }
            ++i;
        }
        double prevX = seq.getX(0);
        double prevY = seq.getY(0);
        int i2 = 1;
        while (i2 <= 4) {
            boolean yChanged;
            double x = seq.getX(i2);
            double y = seq.getY(i2);
            boolean xChanged = x != prevX;
            boolean bl = yChanged = y != prevY;
            if (xChanged == yChanged) {
                return false;
            }
            prevX = x;
            prevY = y;
            ++i2;
        }
        return true;
    }

    public LinearRing getExteriorRing() {
        return this.shell;
    }

    public int getNumInteriorRing() {
        return this.holes.length;
    }

    public LinearRing getInteriorRingN(int n) {
        return this.holes[n];
    }

    @Override
    public String getGeometryType() {
        return "Polygon";
    }

    @Override
    public double getArea() {
        double area = 0.0;
        area += Area.ofRing(this.shell.getCoordinateSequence());
        int i = 0;
        while (i < this.holes.length) {
            area -= Area.ofRing(this.holes[i].getCoordinateSequence());
            ++i;
        }
        return area;
    }

    @Override
    public double getLength() {
        double len = 0.0;
        len += this.shell.getLength();
        int i = 0;
        while (i < this.holes.length) {
            len += this.holes[i].getLength();
            ++i;
        }
        return len;
    }

    @Override
    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return this.getFactory().createMultiLineString();
        }
        LineString[] rings = new LinearRing[this.holes.length + 1];
        rings[0] = this.shell;
        int i = 0;
        while (i < this.holes.length) {
            rings[i + 1] = this.holes[i];
            ++i;
        }
        if (rings.length <= 1) {
            return this.getFactory().createLinearRing(rings[0].getCoordinateSequence());
        }
        return this.getFactory().createMultiLineString(rings);
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        return this.shell.getEnvelopeInternal();
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        Polygon otherPolygon = (Polygon)other;
        LinearRing thisShell = this.shell;
        LinearRing otherPolygonShell = otherPolygon.shell;
        if (!((Geometry)thisShell).equalsExact(otherPolygonShell, tolerance)) {
            return false;
        }
        if (this.holes.length != otherPolygon.holes.length) {
            return false;
        }
        int i = 0;
        while (i < this.holes.length) {
            if (!((Geometry)this.holes[i]).equalsExact(otherPolygon.holes[i], tolerance)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void apply(CoordinateFilter filter) {
        this.shell.apply(filter);
        int i = 0;
        while (i < this.holes.length) {
            this.holes[i].apply(filter);
            ++i;
        }
    }

    @Override
    public void apply(CoordinateSequenceFilter filter) {
        this.shell.apply(filter);
        if (!filter.isDone()) {
            int i = 0;
            while (i < this.holes.length) {
                this.holes[i].apply(filter);
                if (filter.isDone()) break;
                ++i;
            }
        }
        if (filter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    @Override
    public void apply(GeometryFilter filter) {
        filter.filter(this);
    }

    @Override
    public void apply(GeometryComponentFilter filter) {
        filter.filter(this);
        this.shell.apply(filter);
        int i = 0;
        while (i < this.holes.length) {
            this.holes[i].apply(filter);
            ++i;
        }
    }

    @Override
    public Object clone() {
        return this.copy();
    }

    @Override
    protected Polygon copyInternal() {
        LinearRing shellCopy = (LinearRing)this.shell.copy();
        LinearRing[] holeCopies = new LinearRing[this.holes.length];
        int i = 0;
        while (i < this.holes.length) {
            holeCopies[i] = (LinearRing)this.holes[i].copy();
            ++i;
        }
        return new Polygon(shellCopy, holeCopies, this.factory);
    }

    @Override
    public Geometry convexHull() {
        return this.getExteriorRing().convexHull();
    }

    @Override
    public void normalize() {
        this.shell = this.normalized(this.shell, true);
        int i = 0;
        while (i < this.holes.length) {
            this.holes[i] = this.normalized(this.holes[i], false);
            ++i;
        }
        Arrays.sort(this.holes);
    }

    @Override
    protected int compareToSameClass(Object o) {
        LinearRing thisShell = this.shell;
        LinearRing otherShell = ((Polygon)o).shell;
        return thisShell.compareToSameClass(otherShell);
    }

    @Override
    protected int compareToSameClass(Object o, CoordinateSequenceComparator comp) {
        Polygon poly = (Polygon)o;
        LinearRing thisShell = this.shell;
        LinearRing otherShell = poly.shell;
        int shellComp = thisShell.compareToSameClass(otherShell, comp);
        if (shellComp != 0) {
            return shellComp;
        }
        int nHole1 = this.getNumInteriorRing();
        int nHole2 = poly.getNumInteriorRing();
        int i = 0;
        while (i < nHole1 && i < nHole2) {
            LinearRing otherHole;
            LinearRing thisHole = this.getInteriorRingN(i);
            int holeComp = thisHole.compareToSameClass(otherHole = poly.getInteriorRingN(i), comp);
            if (holeComp != 0) {
                return holeComp;
            }
            ++i;
        }
        if (i < nHole1) {
            return 1;
        }
        if (i < nHole2) {
            return -1;
        }
        return 0;
    }

    @Override
    protected int getSortIndex() {
        return 5;
    }

    private LinearRing normalized(LinearRing ring, boolean clockwise) {
        LinearRing res = (LinearRing)ring.copy();
        this.normalize(res, clockwise);
        return res;
    }

    private void normalize(LinearRing ring, boolean clockwise) {
        if (ring.isEmpty()) {
            return;
        }
        CoordinateSequence seq = ring.getCoordinateSequence();
        int minCoordinateIndex = CoordinateSequences.minCoordinateIndex(seq, 0, seq.size() - 2);
        CoordinateSequences.scroll(seq, minCoordinateIndex, true);
        if (Orientation.isCCW(seq) == clockwise) {
            CoordinateSequences.reverse(seq);
        }
    }

    @Override
    public Geometry reverse() {
        Polygon poly = (Polygon)this.copy();
        poly.shell = (LinearRing)this.shell.copy().reverse();
        poly.holes = new LinearRing[this.holes.length];
        int i = 0;
        while (i < this.holes.length) {
            poly.holes[i] = (LinearRing)this.holes[i].copy().reverse();
            ++i;
        }
        return poly;
    }
}

