/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Coordinates;
import org.locationtech.jts.geom.Envelope;

public class CoordinateArraySequence
implements CoordinateSequence,
Serializable {
    private static final long serialVersionUID = -915438501601840650L;
    private int dimension = 3;
    private int measures = 0;
    private Coordinate[] coordinates;

    public CoordinateArraySequence(Coordinate[] coordinates) {
        this(coordinates, CoordinateArrays.dimension(coordinates), CoordinateArrays.measures(coordinates));
    }

    public CoordinateArraySequence(Coordinate[] coordinates, int dimension) {
        this(coordinates, dimension, CoordinateArrays.measures(coordinates));
    }

    public CoordinateArraySequence(Coordinate[] coordinates, int dimension, int measures) {
        this.dimension = dimension;
        this.measures = measures;
        this.coordinates = coordinates == null ? new Coordinate[0] : this.enforceArrayConsistency(coordinates);
    }

    public CoordinateArraySequence(int size) {
        this.coordinates = new Coordinate[size];
        int i = 0;
        while (i < size) {
            this.coordinates[i] = new Coordinate();
            ++i;
        }
    }

    public CoordinateArraySequence(int size, int dimension) {
        this.coordinates = new Coordinate[size];
        this.dimension = dimension;
        int i = 0;
        while (i < size) {
            this.coordinates[i] = Coordinates.create(dimension);
            ++i;
        }
    }

    public CoordinateArraySequence(int size, int dimension, int measures) {
        this.coordinates = new Coordinate[size];
        this.dimension = dimension;
        this.measures = measures;
        int i = 0;
        while (i < size) {
            this.coordinates[i] = this.createCoordinate();
            ++i;
        }
    }

    public CoordinateArraySequence(CoordinateSequence coordSeq) {
        if (coordSeq == null) {
            this.coordinates = new Coordinate[0];
            return;
        }
        this.dimension = coordSeq.getDimension();
        this.measures = coordSeq.getMeasures();
        this.coordinates = new Coordinate[coordSeq.size()];
        int i = 0;
        while (i < this.coordinates.length) {
            this.coordinates[i] = coordSeq.getCoordinateCopy(i);
            ++i;
        }
    }

    protected Coordinate[] enforceArrayConsistency(Coordinate[] array) {
        Coordinate sample = this.createCoordinate();
        Class<?> type = sample.getClass();
        boolean isConsistent = true;
        int i = 0;
        while (i < array.length) {
            Coordinate coordinate = array[i];
            if (coordinate != null && !coordinate.getClass().equals(type)) {
                isConsistent = false;
                break;
            }
            ++i;
        }
        if (isConsistent) {
            return array;
        }
        Class<?> coordinateType = sample.getClass();
        Coordinate[] copy = (Coordinate[])Array.newInstance(coordinateType, array.length);
        int i2 = 0;
        while (i2 < copy.length) {
            Coordinate coordinate = array[i2];
            if (coordinate != null && !coordinate.getClass().equals(type)) {
                Coordinate duplicate = this.createCoordinate();
                duplicate.setCoordinate(coordinate);
                copy[i2] = duplicate;
            } else {
                copy[i2] = coordinate;
            }
            ++i2;
        }
        return copy;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public int getMeasures() {
        return this.measures;
    }

    @Override
    public Coordinate getCoordinate(int i) {
        return this.coordinates[i];
    }

    @Override
    public Coordinate getCoordinateCopy(int i) {
        Coordinate copy = this.createCoordinate();
        copy.setCoordinate(this.coordinates[i]);
        return copy;
    }

    @Override
    public void getCoordinate(int index, Coordinate coord) {
        coord.setCoordinate(this.coordinates[index]);
    }

    @Override
    public double getX(int index) {
        return this.coordinates[index].x;
    }

    @Override
    public double getY(int index) {
        return this.coordinates[index].y;
    }

    @Override
    public double getZ(int index) {
        if (this.hasZ()) {
            return this.coordinates[index].getZ();
        }
        return Double.NaN;
    }

    @Override
    public double getM(int index) {
        if (this.hasM()) {
            return this.coordinates[index].getM();
        }
        return Double.NaN;
    }

    @Override
    public double getOrdinate(int index, int ordinateIndex) {
        switch (ordinateIndex) {
            case 0: {
                return this.coordinates[index].x;
            }
            case 1: {
                return this.coordinates[index].y;
            }
        }
        return this.coordinates[index].getOrdinate(ordinateIndex);
    }

    @Override
    public Object clone() {
        return this.copy();
    }

    @Override
    public CoordinateArraySequence copy() {
        Coordinate[] cloneCoordinates = new Coordinate[this.size()];
        int i = 0;
        while (i < this.coordinates.length) {
            Coordinate duplicate = this.createCoordinate();
            duplicate.setCoordinate(this.coordinates[i]);
            cloneCoordinates[i] = duplicate;
            ++i;
        }
        return new CoordinateArraySequence(cloneCoordinates, this.dimension, this.measures);
    }

    @Override
    public int size() {
        return this.coordinates.length;
    }

    @Override
    public void setOrdinate(int index, int ordinateIndex, double value) {
        switch (ordinateIndex) {
            case 0: {
                this.coordinates[index].x = value;
                break;
            }
            case 1: {
                this.coordinates[index].y = value;
                break;
            }
            default: {
                this.coordinates[index].setOrdinate(ordinateIndex, value);
            }
        }
    }

    @Override
    public Coordinate[] toCoordinateArray() {
        return this.coordinates;
    }

    @Override
    public Envelope expandEnvelope(Envelope env) {
        int i = 0;
        while (i < this.coordinates.length) {
            env.expandToInclude(this.coordinates[i]);
            ++i;
        }
        return env;
    }

    public String toString() {
        if (this.coordinates.length > 0) {
            StringBuilder strBuilder = new StringBuilder(17 * this.coordinates.length);
            strBuilder.append('(');
            strBuilder.append(this.coordinates[0]);
            int i = 1;
            while (i < this.coordinates.length) {
                strBuilder.append(", ");
                strBuilder.append(this.coordinates[i]);
                ++i;
            }
            strBuilder.append(')');
            return strBuilder.toString();
        }
        return "()";
    }

    @Override
    public boolean hasZ() {
        return this.getDimension() - this.getMeasures() > 2;
    }

    @Override
    public boolean hasM() {
        return this.getMeasures() > 0;
    }

    @Override
    public Coordinate createCoordinate() {
        return Coordinates.create(this.getDimension(), this.getMeasures());
    }
}

