/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import java.util.ArrayList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.util.GeometryMapper;

public class GeometryCollectionMapper {
    private GeometryMapper.MapOp mapOp = null;

    public static GeometryCollection map(GeometryCollection gc, GeometryMapper.MapOp op) {
        GeometryCollectionMapper mapper = new GeometryCollectionMapper(op);
        return mapper.map(gc);
    }

    public GeometryCollectionMapper(GeometryMapper.MapOp mapOp) {
        this.mapOp = mapOp;
    }

    public GeometryCollection map(GeometryCollection gc) {
        ArrayList<Geometry> mapped = new ArrayList<Geometry>();
        int i = 0;
        while (i < gc.getNumGeometries()) {
            Geometry g = this.mapOp.map(gc.getGeometryN(i));
            if (!g.isEmpty()) {
                mapped.add(g);
            }
            ++i;
        }
        return gc.getFactory().createGeometryCollection(GeometryFactory.toGeometryArray(mapped));
    }
}

