/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph.index;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.Quadrant;
import org.locationtech.jts.util.IntArrayList;

public class MonotoneChainIndexer {
    public static int[] toIntArray(List list) {
        int[] array = new int[list.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = (Integer)list.get(i);
            ++i;
        }
        return array;
    }

    public int[] getChainStartIndices(Coordinate[] pts) {
        int last;
        int start = 0;
        IntArrayList startIndexList = new IntArrayList(pts.length / 2);
        startIndexList.add(start);
        do {
            last = this.findChainEnd(pts, start);
            startIndexList.add(last);
        } while ((start = last) < pts.length - 1);
        return startIndexList.toArray();
    }

    public int[] OLDgetChainStartIndices(Coordinate[] pts) {
        int last;
        int start = 0;
        ArrayList<Integer> startIndexList = new ArrayList<Integer>();
        startIndexList.add(start);
        do {
            last = this.findChainEnd(pts, start);
            startIndexList.add(last);
        } while ((start = last) < pts.length - 1);
        int[] startIndex = MonotoneChainIndexer.toIntArray(startIndexList);
        return startIndex;
    }

    private int findChainEnd(Coordinate[] pts, int start) {
        int chainQuad = Quadrant.quadrant(pts[start], pts[start + 1]);
        int last = start + 1;
        while (last < pts.length) {
            int quad = Quadrant.quadrant(pts[last - 1], pts[last]);
            if (quad != chainQuad) break;
            ++last;
        }
        return last - 1;
    }
}

