/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph.index;

import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.index.EdgeSetIntersector;
import org.locationtech.jts.geomgraph.index.SegmentIntersector;

public class SimpleEdgeSetIntersector
extends EdgeSetIntersector {
    int nOverlaps;

    @Override
    public void computeIntersections(List edges, SegmentIntersector si, boolean testAllSegments) {
        this.nOverlaps = 0;
        for (Edge edge0 : edges) {
            for (Edge edge1 : edges) {
                if (!testAllSegments && edge0 == edge1) continue;
                this.computeIntersects(edge0, edge1, si);
            }
        }
    }

    @Override
    public void computeIntersections(List edges0, List edges1, SegmentIntersector si) {
        this.nOverlaps = 0;
        for (Edge edge0 : edges0) {
            for (Edge edge1 : edges1) {
                this.computeIntersects(edge0, edge1, si);
            }
        }
    }

    private void computeIntersects(Edge e0, Edge e1, SegmentIntersector si) {
        Coordinate[] pts0 = e0.getCoordinates();
        Coordinate[] pts1 = e1.getCoordinates();
        int i0 = 0;
        while (i0 < pts0.length - 1) {
            int i1 = 0;
            while (i1 < pts1.length - 1) {
                si.addIntersections(e0, i0, e1, i1);
                ++i1;
            }
            ++i0;
        }
    }
}

