/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.index.EdgeSetIntersector;
import org.locationtech.jts.geomgraph.index.SegmentIntersector;
import org.locationtech.jts.geomgraph.index.SweepLineEvent;
import org.locationtech.jts.geomgraph.index.SweepLineSegment;

public class SimpleSweepLineIntersector
extends EdgeSetIntersector {
    List events = new ArrayList();
    int nOverlaps;

    @Override
    public void computeIntersections(List edges, SegmentIntersector si, boolean testAllSegments) {
        if (testAllSegments) {
            this.add(edges, null);
        } else {
            this.add(edges);
        }
        this.computeIntersections(si);
    }

    @Override
    public void computeIntersections(List edges0, List edges1, SegmentIntersector si) {
        this.add(edges0, (Object)edges0);
        this.add(edges1, (Object)edges1);
        this.computeIntersections(si);
    }

    private void add(List edges) {
        for (Edge edge : edges) {
            this.add(edge, (Object)edge);
        }
    }

    private void add(List edges, Object edgeSet) {
        for (Edge edge : edges) {
            this.add(edge, edgeSet);
        }
    }

    private void add(Edge edge, Object edgeSet) {
        Coordinate[] pts = edge.getCoordinates();
        int i = 0;
        while (i < pts.length - 1) {
            SweepLineSegment ss = new SweepLineSegment(edge, i);
            SweepLineEvent insertEvent = new SweepLineEvent(edgeSet, ss.getMinX(), null);
            this.events.add(insertEvent);
            this.events.add(new SweepLineEvent(ss.getMaxX(), insertEvent));
            ++i;
        }
    }

    private void prepareEvents() {
        Collections.sort(this.events);
        int i = 0;
        while (i < this.events.size()) {
            SweepLineEvent ev = (SweepLineEvent)this.events.get(i);
            if (ev.isDelete()) {
                ev.getInsertEvent().setDeleteEventIndex(i);
            }
            ++i;
        }
    }

    private void computeIntersections(SegmentIntersector si) {
        this.nOverlaps = 0;
        this.prepareEvents();
        int i = 0;
        while (i < this.events.size()) {
            SweepLineEvent ev = (SweepLineEvent)this.events.get(i);
            if (ev.isInsert()) {
                this.processOverlaps(i, ev.getDeleteEventIndex(), ev, si);
            }
            ++i;
        }
    }

    private void processOverlaps(int start, int end, SweepLineEvent ev0, SegmentIntersector si) {
        SweepLineSegment ss0 = (SweepLineSegment)ev0.getObject();
        int i = start;
        while (i < end) {
            SweepLineEvent ev1 = (SweepLineEvent)this.events.get(i);
            if (ev1.isInsert()) {
                SweepLineSegment ss1 = (SweepLineSegment)ev1.getObject();
                if (!ev0.isSameLabel(ev1)) {
                    ss0.computeIntersections(ss1, si);
                    ++this.nOverlaps;
                }
            }
            ++i;
        }
    }
}

