/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.chain;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.Quadrant;
import org.locationtech.jts.index.chain.MonotoneChain;

public class MonotoneChainBuilder {
    public static List getChains(Coordinate[] pts) {
        return MonotoneChainBuilder.getChains(pts, null);
    }

    public static List getChains(Coordinate[] pts, Object context) {
        int chainEnd;
        ArrayList<MonotoneChain> mcList = new ArrayList<MonotoneChain>();
        int chainStart = 0;
        do {
            chainEnd = MonotoneChainBuilder.findChainEnd(pts, chainStart);
            MonotoneChain mc = new MonotoneChain(pts, chainStart, chainEnd, context);
            mcList.add(mc);
        } while ((chainStart = chainEnd) < pts.length - 1);
        return mcList;
    }

    private static int findChainEnd(Coordinate[] pts, int start) {
        int safeStart = start;
        while (safeStart < pts.length - 1 && pts[safeStart].equals2D(pts[safeStart + 1])) {
            ++safeStart;
        }
        if (safeStart >= pts.length - 1) {
            return pts.length - 1;
        }
        int chainQuad = Quadrant.quadrant(pts[safeStart], pts[safeStart + 1]);
        int last = start + 1;
        while (last < pts.length) {
            int quad;
            if (!pts[last - 1].equals2D(pts[last]) && (quad = Quadrant.quadrant(pts[last - 1], pts[last])) != chainQuad) break;
            ++last;
        }
        return last - 1;
    }
}

