/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.kdtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.kdtree.KdNode;
import org.locationtech.jts.index.kdtree.KdNodeVisitor;

public class KdTree {
    private KdNode root = null;
    private long numberOfNodes;
    private double tolerance;

    public static Coordinate[] toCoordinates(Collection kdnodes) {
        return KdTree.toCoordinates(kdnodes, false);
    }

    public static Coordinate[] toCoordinates(Collection kdnodes, boolean includeRepeated) {
        CoordinateList coord = new CoordinateList();
        for (KdNode node : kdnodes) {
            int count = includeRepeated ? node.getCount() : 1;
            int i = 0;
            while (i < count) {
                coord.add(node.getCoordinate(), true);
                ++i;
            }
        }
        return coord.toCoordinateArray();
    }

    public KdTree() {
        this(0.0);
    }

    public KdTree(double tolerance) {
        this.tolerance = tolerance;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public KdNode insert(Coordinate p) {
        return this.insert(p, null);
    }

    public KdNode insert(Coordinate p, Object data) {
        KdNode matchNode;
        if (this.root == null) {
            this.root = new KdNode(p, data);
            return this.root;
        }
        if (this.tolerance > 0.0 && (matchNode = this.findBestMatchNode(p)) != null) {
            matchNode.increment();
            return matchNode;
        }
        return this.insertExact(p, data);
    }

    private KdNode findBestMatchNode(Coordinate p) {
        BestMatchVisitor visitor = new BestMatchVisitor(p, this.tolerance);
        this.query(visitor.queryEnvelope(), visitor);
        return visitor.getNode();
    }

    private KdNode insertExact(Coordinate p, Object data) {
        KdNode currentNode = this.root;
        KdNode leafNode = this.root;
        boolean isOddLevel = true;
        boolean isLessThan = true;
        while (currentNode != null) {
            if (currentNode != null) {
                boolean isInTolerance;
                boolean bl = isInTolerance = p.distance(currentNode.getCoordinate()) <= this.tolerance;
                if (isInTolerance) {
                    currentNode.increment();
                    return currentNode;
                }
            }
            isLessThan = isOddLevel ? p.x < currentNode.getX() : p.y < currentNode.getY();
            leafNode = currentNode;
            currentNode = isLessThan ? currentNode.getLeft() : currentNode.getRight();
            boolean bl = isOddLevel = !isOddLevel;
        }
        ++this.numberOfNodes;
        KdNode node = new KdNode(p, data);
        if (isLessThan) {
            leafNode.setLeft(node);
        } else {
            leafNode.setRight(node);
        }
        return node;
    }

    private void queryNode(KdNode currentNode, Envelope queryEnv, boolean odd, KdNodeVisitor visitor) {
        boolean searchRight;
        double discriminant;
        double max;
        double min;
        if (currentNode == null) {
            return;
        }
        if (odd) {
            min = queryEnv.getMinX();
            max = queryEnv.getMaxX();
            discriminant = currentNode.getX();
        } else {
            min = queryEnv.getMinY();
            max = queryEnv.getMaxY();
            discriminant = currentNode.getY();
        }
        boolean searchLeft = min < discriminant;
        boolean bl = searchRight = discriminant <= max;
        if (searchLeft) {
            this.queryNode(currentNode.getLeft(), queryEnv, !odd, visitor);
        }
        if (queryEnv.contains(currentNode.getCoordinate())) {
            visitor.visit(currentNode);
        }
        if (searchRight) {
            this.queryNode(currentNode.getRight(), queryEnv, !odd, visitor);
        }
    }

    public void query(Envelope queryEnv, KdNodeVisitor visitor) {
        this.queryNode(this.root, queryEnv, true, visitor);
    }

    public List query(Envelope queryEnv) {
        ArrayList result = new ArrayList();
        this.query(queryEnv, result);
        return result;
    }

    public void query(Envelope queryEnv, final List result) {
        this.queryNode(this.root, queryEnv, true, new KdNodeVisitor(){

            @Override
            public void visit(KdNode node) {
                result.add(node);
            }
        });
    }

    private static class BestMatchVisitor
    implements KdNodeVisitor {
        private double tolerance;
        private KdNode matchNode = null;
        private double matchDist = 0.0;
        private Coordinate p;

        public BestMatchVisitor(Coordinate p, double tolerance) {
            this.p = p;
            this.tolerance = tolerance;
        }

        public Envelope queryEnvelope() {
            Envelope queryEnv = new Envelope(this.p);
            queryEnv.expandBy(this.tolerance);
            return queryEnv;
        }

        public KdNode getNode() {
            return this.matchNode;
        }

        @Override
        public void visit(KdNode node) {
            boolean isInTolerance;
            double dist = this.p.distance(node.getCoordinate());
            boolean bl = isInTolerance = dist <= this.tolerance;
            if (!isInTolerance) {
                return;
            }
            boolean update = false;
            if (this.matchNode == null || dist < this.matchDist || this.matchNode != null && dist == this.matchDist && node.getCoordinate().compareTo(this.matchNode.getCoordinate()) < 1) {
                update = true;
            }
            if (update) {
                this.matchNode = node;
                this.matchDist = dist;
            }
        }
    }
}

