/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import org.locationtech.jts.io.InStream;

public class ByteArrayInStream
implements InStream {
    private byte[] buffer;
    private int position;

    public ByteArrayInStream(byte[] buffer) {
        this.setBytes(buffer);
    }

    public void setBytes(byte[] buffer) {
        this.buffer = buffer;
        this.position = 0;
    }

    @Override
    public void read(byte[] buf) {
        int numToRead = buf.length;
        if (this.position + numToRead > this.buffer.length) {
            numToRead = this.buffer.length - this.position;
            System.arraycopy(this.buffer, this.position, buf, 0, numToRead);
            int i = numToRead;
            while (i < buf.length) {
                buf[i] = 0;
                ++i;
            }
        } else {
            System.arraycopy(this.buffer, this.position, buf, 0, numToRead);
        }
        this.position += numToRead;
    }
}

