/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

public class Matrix {
    private static void swapRows(double[][] m, int i, int j) {
        if (i == j) {
            return;
        }
        int col = 0;
        while (col < m[0].length) {
            double temp = m[i][col];
            m[i][col] = m[j][col];
            m[j][col] = temp;
            ++col;
        }
    }

    private static void swapRows(double[] m, int i, int j) {
        if (i == j) {
            return;
        }
        double temp = m[i];
        m[i] = m[j];
        m[j] = temp;
    }

    public static double[] solve(double[][] a, double[] b) {
        int n = b.length;
        if (a.length != n || a[0].length != n) {
            throw new IllegalArgumentException("Matrix A is incorrectly sized");
        }
        int i = 0;
        while (i < n) {
            int maxElementRow = i;
            int j = i + 1;
            while (j < n) {
                if (Math.abs(a[j][i]) > Math.abs(a[maxElementRow][i])) {
                    maxElementRow = j;
                }
                ++j;
            }
            if (a[maxElementRow][i] == 0.0) {
                return null;
            }
            Matrix.swapRows(a, i, maxElementRow);
            Matrix.swapRows(b, i, maxElementRow);
            j = i + 1;
            while (j < n) {
                double rowFactor = a[j][i] / a[i][i];
                int k = n - 1;
                while (k >= i) {
                    double[] dArray = a[j];
                    int n2 = k;
                    dArray[n2] = dArray[n2] - a[i][k] * rowFactor;
                    --k;
                }
                int n3 = j++;
                b[n3] = b[n3] - b[i] * rowFactor;
            }
            ++i;
        }
        double[] solution = new double[n];
        int j = n - 1;
        while (j >= 0) {
            double t = 0.0;
            int k = j + 1;
            while (k < n) {
                t += a[j][k] * solution[k];
                ++k;
            }
            solution[j] = (b[j] - t) / a[j][j];
            --j;
        }
        return solution;
    }
}

