/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentString;

public class InteriorIntersectionFinderAdder
implements SegmentIntersector {
    private LineIntersector li;
    private final List interiorIntersections;

    public InteriorIntersectionFinderAdder(LineIntersector li) {
        this.li = li;
        this.interiorIntersections = new ArrayList();
    }

    public List getInteriorIntersections() {
        return this.interiorIntersections;
    }

    @Override
    public void processIntersections(SegmentString e0, int segIndex0, SegmentString e1, int segIndex1) {
        if (e0 == e1 && segIndex0 == segIndex1) {
            return;
        }
        Coordinate p00 = e0.getCoordinates()[segIndex0];
        Coordinate p01 = e0.getCoordinates()[segIndex0 + 1];
        Coordinate p10 = e1.getCoordinates()[segIndex1];
        Coordinate p11 = e1.getCoordinates()[segIndex1 + 1];
        this.li.computeIntersection(p00, p01, p10, p11);
        if (this.li.hasIntersection() && this.li.isInteriorIntersection()) {
            int intIndex = 0;
            while (intIndex < this.li.getIntersectionNum()) {
                this.interiorIntersections.add(this.li.getIntersection(intIndex));
                ++intIndex;
            }
            ((NodedSegmentString)e0).addIntersections(this.li, segIndex0, 0);
            ((NodedSegmentString)e1).addIntersections(this.li, segIndex1, 1);
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }
}

