/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.noding.NodableSegmentString;
import org.locationtech.jts.noding.Octant;
import org.locationtech.jts.noding.SegmentNode;
import org.locationtech.jts.noding.SegmentNodeList;

public class NodedSegmentString
implements NodableSegmentString {
    private SegmentNodeList nodeList = new SegmentNodeList(this);
    private Coordinate[] pts;
    private Object data;

    public static List getNodedSubstrings(Collection segStrings) {
        ArrayList resultEdgelist = new ArrayList();
        NodedSegmentString.getNodedSubstrings(segStrings, resultEdgelist);
        return resultEdgelist;
    }

    public static void getNodedSubstrings(Collection segStrings, Collection resultEdgelist) {
        for (NodedSegmentString ss : segStrings) {
            ss.getNodeList().addSplitEdges(resultEdgelist);
        }
    }

    public NodedSegmentString(Coordinate[] pts, Object data) {
        this.pts = pts;
        this.data = data;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    public SegmentNodeList getNodeList() {
        return this.nodeList;
    }

    @Override
    public int size() {
        return this.pts.length;
    }

    @Override
    public Coordinate getCoordinate(int i) {
        return this.pts[i];
    }

    @Override
    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    @Override
    public boolean isClosed() {
        return this.pts[0].equals(this.pts[this.pts.length - 1]);
    }

    public int getSegmentOctant(int index) {
        if (index == this.pts.length - 1) {
            return -1;
        }
        return this.safeOctant(this.getCoordinate(index), this.getCoordinate(index + 1));
    }

    private int safeOctant(Coordinate p0, Coordinate p1) {
        if (p0.equals2D(p1)) {
            return 0;
        }
        return Octant.octant(p0, p1);
    }

    public void addIntersections(LineIntersector li, int segmentIndex, int geomIndex) {
        int i = 0;
        while (i < li.getIntersectionNum()) {
            this.addIntersection(li, segmentIndex, geomIndex, i);
            ++i;
        }
    }

    public void addIntersection(LineIntersector li, int segmentIndex, int geomIndex, int intIndex) {
        Coordinate intPt = new Coordinate(li.getIntersection(intIndex));
        this.addIntersection(intPt, segmentIndex);
    }

    @Override
    public void addIntersection(Coordinate intPt, int segmentIndex) {
        this.addIntersectionNode(intPt, segmentIndex);
    }

    public SegmentNode addIntersectionNode(Coordinate intPt, int segmentIndex) {
        Coordinate nextPt;
        int normalizedSegmentIndex = segmentIndex;
        int nextSegIndex = normalizedSegmentIndex + 1;
        if (nextSegIndex < this.pts.length && intPt.equals2D(nextPt = this.pts[nextSegIndex])) {
            normalizedSegmentIndex = nextSegIndex;
        }
        SegmentNode ei = this.nodeList.add(intPt, normalizedSegmentIndex);
        return ei;
    }

    public String toString() {
        return WKTWriter.toLineString(new CoordinateArraySequence(this.pts));
    }
}

