/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.Collection;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentSetMutualIntersector;
import org.locationtech.jts.noding.SegmentString;

public class SimpleSegmentSetMutualIntersector
implements SegmentSetMutualIntersector {
    private final Collection baseSegStrings;

    public SimpleSegmentSetMutualIntersector(Collection segStrings) {
        this.baseSegStrings = segStrings;
    }

    @Override
    public void process(Collection segStrings, SegmentIntersector segInt) {
        for (SegmentString baseSS : this.baseSegStrings) {
            for (SegmentString ss : segStrings) {
                this.intersect(baseSS, ss, segInt);
                if (!segInt.isDone()) continue;
                return;
            }
        }
    }

    private void intersect(SegmentString ss0, SegmentString ss1, SegmentIntersector segInt) {
        Coordinate[] pts0 = ss0.getCoordinates();
        Coordinate[] pts1 = ss1.getCoordinates();
        int i0 = 0;
        while (i0 < pts0.length - 1) {
            int i1 = 0;
            while (i1 < pts1.length - 1) {
                segInt.processIntersections(ss0, i0, ss1, i1);
                if (segInt.isDone()) {
                    return;
                }
                ++i1;
            }
            ++i0;
        }
    }
}

