/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.buffer.BufferInputLineSimplifier;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.OffsetSegmentGenerator;

public class OffsetCurveBuilder {
    private double distance = 0.0;
    private PrecisionModel precisionModel;
    private BufferParameters bufParams;

    public OffsetCurveBuilder(PrecisionModel precisionModel, BufferParameters bufParams) {
        this.precisionModel = precisionModel;
        this.bufParams = bufParams;
    }

    public BufferParameters getBufferParameters() {
        return this.bufParams;
    }

    public Coordinate[] getLineCurve(Coordinate[] inputPts, double distance) {
        this.distance = distance;
        if (distance < 0.0 && !this.bufParams.isSingleSided()) {
            return null;
        }
        if (distance == 0.0) {
            return null;
        }
        double posDistance = Math.abs(distance);
        OffsetSegmentGenerator segGen = this.getSegGen(posDistance);
        if (inputPts.length <= 1) {
            this.computePointCurve(inputPts[0], segGen);
        } else if (this.bufParams.isSingleSided()) {
            boolean isRightSide = distance < 0.0;
            this.computeSingleSidedBufferCurve(inputPts, isRightSide, segGen);
        } else {
            this.computeLineBufferCurve(inputPts, segGen);
        }
        Coordinate[] lineCoord = segGen.getCoordinates();
        return lineCoord;
    }

    public Coordinate[] getRingCurve(Coordinate[] inputPts, int side, double distance) {
        this.distance = distance;
        if (inputPts.length <= 2) {
            return this.getLineCurve(inputPts, distance);
        }
        if (distance == 0.0) {
            return OffsetCurveBuilder.copyCoordinates(inputPts);
        }
        OffsetSegmentGenerator segGen = this.getSegGen(distance);
        this.computeRingBufferCurve(inputPts, side, segGen);
        return segGen.getCoordinates();
    }

    public Coordinate[] getOffsetCurve(Coordinate[] inputPts, double distance) {
        this.distance = distance;
        if (distance == 0.0) {
            return null;
        }
        boolean isRightSide = distance < 0.0;
        double posDistance = Math.abs(distance);
        OffsetSegmentGenerator segGen = this.getSegGen(posDistance);
        if (inputPts.length <= 1) {
            this.computePointCurve(inputPts[0], segGen);
        } else {
            this.computeOffsetCurve(inputPts, isRightSide, segGen);
        }
        Coordinate[] curvePts = segGen.getCoordinates();
        if (isRightSide) {
            CoordinateArrays.reverse(curvePts);
        }
        return curvePts;
    }

    private static Coordinate[] copyCoordinates(Coordinate[] pts) {
        Coordinate[] copy = new Coordinate[pts.length];
        int i = 0;
        while (i < copy.length) {
            copy[i] = new Coordinate(pts[i]);
            ++i;
        }
        return copy;
    }

    private OffsetSegmentGenerator getSegGen(double distance) {
        return new OffsetSegmentGenerator(this.precisionModel, this.bufParams, distance);
    }

    private double simplifyTolerance(double bufDistance) {
        return bufDistance * this.bufParams.getSimplifyFactor();
    }

    private void computePointCurve(Coordinate pt, OffsetSegmentGenerator segGen) {
        switch (this.bufParams.getEndCapStyle()) {
            case 1: {
                segGen.createCircle(pt);
                break;
            }
            case 3: {
                segGen.createSquare(pt);
            }
        }
    }

    private void computeLineBufferCurve(Coordinate[] inputPts, OffsetSegmentGenerator segGen) {
        double distTol = this.simplifyTolerance(this.distance);
        Coordinate[] simp1 = BufferInputLineSimplifier.simplify(inputPts, distTol);
        int n1 = simp1.length - 1;
        segGen.initSideSegments(simp1[0], simp1[1], 1);
        int i = 2;
        while (i <= n1) {
            segGen.addNextSegment(simp1[i], true);
            ++i;
        }
        segGen.addLastSegment();
        segGen.addLineEndCap(simp1[n1 - 1], simp1[n1]);
        Coordinate[] simp2 = BufferInputLineSimplifier.simplify(inputPts, -distTol);
        int n2 = simp2.length - 1;
        segGen.initSideSegments(simp2[n2], simp2[n2 - 1], 1);
        int i2 = n2 - 2;
        while (i2 >= 0) {
            segGen.addNextSegment(simp2[i2], true);
            --i2;
        }
        segGen.addLastSegment();
        segGen.addLineEndCap(simp2[1], simp2[0]);
        segGen.closeRing();
    }

    private void computeSingleSidedBufferCurve(Coordinate[] inputPts, boolean isRightSide, OffsetSegmentGenerator segGen) {
        double distTol = this.simplifyTolerance(this.distance);
        if (isRightSide) {
            segGen.addSegments(inputPts, true);
            Coordinate[] simp2 = BufferInputLineSimplifier.simplify(inputPts, -distTol);
            int n2 = simp2.length - 1;
            segGen.initSideSegments(simp2[n2], simp2[n2 - 1], 1);
            segGen.addFirstSegment();
            int i = n2 - 2;
            while (i >= 0) {
                segGen.addNextSegment(simp2[i], true);
                --i;
            }
        } else {
            segGen.addSegments(inputPts, false);
            Coordinate[] simp1 = BufferInputLineSimplifier.simplify(inputPts, distTol);
            int n1 = simp1.length - 1;
            segGen.initSideSegments(simp1[0], simp1[1], 1);
            segGen.addFirstSegment();
            int i = 2;
            while (i <= n1) {
                segGen.addNextSegment(simp1[i], true);
                ++i;
            }
        }
        segGen.addLastSegment();
        segGen.closeRing();
    }

    private void computeOffsetCurve(Coordinate[] inputPts, boolean isRightSide, OffsetSegmentGenerator segGen) {
        double distTol = this.simplifyTolerance(this.distance);
        if (isRightSide) {
            Coordinate[] simp2 = BufferInputLineSimplifier.simplify(inputPts, -distTol);
            int n2 = simp2.length - 1;
            segGen.initSideSegments(simp2[n2], simp2[n2 - 1], 1);
            segGen.addFirstSegment();
            int i = n2 - 2;
            while (i >= 0) {
                segGen.addNextSegment(simp2[i], true);
                --i;
            }
        } else {
            Coordinate[] simp1 = BufferInputLineSimplifier.simplify(inputPts, distTol);
            int n1 = simp1.length - 1;
            segGen.initSideSegments(simp1[0], simp1[1], 1);
            segGen.addFirstSegment();
            int i = 2;
            while (i <= n1) {
                segGen.addNextSegment(simp1[i], true);
                ++i;
            }
        }
        segGen.addLastSegment();
    }

    private void computeRingBufferCurve(Coordinate[] inputPts, int side, OffsetSegmentGenerator segGen) {
        double distTol = this.simplifyTolerance(this.distance);
        if (side == 2) {
            distTol = -distTol;
        }
        Coordinate[] simp = BufferInputLineSimplifier.simplify(inputPts, distTol);
        int n = simp.length - 1;
        segGen.initSideSegments(simp[n - 1], simp[0], side);
        int i = 1;
        while (i <= n) {
            boolean addStartPoint = i != 1;
            segGen.addNextSegment(simp[i], addStartPoint);
            ++i;
        }
        segGen.closeRing();
    }
}

