/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.PrecisionModel;

class OffsetSegmentString {
    private static final Coordinate[] COORDINATE_ARRAY_TYPE = new Coordinate[0];
    private ArrayList ptList = new ArrayList();
    private PrecisionModel precisionModel = null;
    private double minimimVertexDistance = 0.0;

    public void setPrecisionModel(PrecisionModel precisionModel) {
        this.precisionModel = precisionModel;
    }

    public void setMinimumVertexDistance(double minimimVertexDistance) {
        this.minimimVertexDistance = minimimVertexDistance;
    }

    public void addPt(Coordinate pt) {
        Coordinate bufPt = new Coordinate(pt);
        this.precisionModel.makePrecise(bufPt);
        if (this.isRedundant(bufPt)) {
            return;
        }
        this.ptList.add(bufPt);
    }

    public void addPts(Coordinate[] pt, boolean isForward) {
        if (isForward) {
            int i = 0;
            while (i < pt.length) {
                this.addPt(pt[i]);
                ++i;
            }
        } else {
            int i = pt.length - 1;
            while (i >= 0) {
                this.addPt(pt[i]);
                --i;
            }
        }
    }

    private boolean isRedundant(Coordinate pt) {
        if (this.ptList.size() < 1) {
            return false;
        }
        Coordinate lastPt = (Coordinate)this.ptList.get(this.ptList.size() - 1);
        double ptDist = pt.distance(lastPt);
        return ptDist < this.minimimVertexDistance;
    }

    public void closeRing() {
        Coordinate lastPt;
        if (this.ptList.size() < 1) {
            return;
        }
        Coordinate startPt = new Coordinate((Coordinate)this.ptList.get(0));
        if (startPt.equals(lastPt = (Coordinate)this.ptList.get(this.ptList.size() - 1))) {
            return;
        }
        this.ptList.add(startPt);
    }

    public void reverse() {
    }

    public Coordinate[] getCoordinates() {
        Coordinate[] coord = this.ptList.toArray(COORDINATE_ARRAY_TYPE);
        return coord;
    }

    public String toString() {
        GeometryFactory fact = new GeometryFactory();
        LineString line = fact.createLineString(this.getCoordinates());
        return line.toString();
    }
}

