/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;

public class VariableBuffer {
    private LineString line;
    private double[] distance;
    private GeometryFactory geomFactory;
    private int quadrantSegs = 8;
    private static final double SNAP_TRIG_TOL = 1.0E-6;

    public static Geometry buffer(Geometry line, double startDistance, double endDistance) {
        double[] distance = VariableBuffer.interpolate((LineString)line, startDistance, endDistance);
        VariableBuffer vb = new VariableBuffer(line, distance);
        return vb.getResult();
    }

    public static Geometry buffer(Geometry line, double startDistance, double midDistance, double endDistance) {
        double[] distance = VariableBuffer.interpolate((LineString)line, startDistance, midDistance, endDistance);
        VariableBuffer vb = new VariableBuffer(line, distance);
        return vb.getResult();
    }

    public static Geometry buffer(Geometry line, double[] distance) {
        VariableBuffer vb = new VariableBuffer(line, distance);
        return vb.getResult();
    }

    private static double[] interpolate(LineString line, double startValue, double endValue) {
        startValue = Math.abs(startValue);
        endValue = Math.abs(endValue);
        double[] values = new double[line.getNumPoints()];
        values[0] = startValue;
        values[values.length - 1] = endValue;
        double totalLen = line.getLength();
        Coordinate[] pts = line.getCoordinates();
        double currLen = 0.0;
        int i = 1;
        while (i < values.length - 1) {
            double segLen = pts[i].distance(pts[i - 1]);
            double lenFrac = (currLen += segLen) / totalLen;
            double delta = lenFrac * (endValue - startValue);
            values[i] = startValue + delta;
            ++i;
        }
        return values;
    }

    private static double[] interpolate(LineString line, double startValue, double midValue, double endValue) {
        startValue = Math.abs(startValue);
        midValue = Math.abs(midValue);
        endValue = Math.abs(endValue);
        double[] values = new double[line.getNumPoints()];
        values[0] = startValue;
        values[values.length - 1] = endValue;
        Coordinate[] pts = line.getCoordinates();
        double lineLen = line.getLength();
        int midIndex = VariableBuffer.indexAtLength(pts, lineLen / 2.0);
        double delMidStart = midValue - startValue;
        double delEndMid = endValue - midValue;
        double lenSM = VariableBuffer.length(pts, 0, midIndex);
        double currLen = 0.0;
        int i = 1;
        while (i <= midIndex) {
            double val;
            double segLen = pts[i].distance(pts[i - 1]);
            double lenFrac = (currLen += segLen) / lenSM;
            values[i] = val = startValue + lenFrac * delMidStart;
            ++i;
        }
        double lenME = VariableBuffer.length(pts, midIndex, pts.length - 1);
        currLen = 0.0;
        int i2 = midIndex + 1;
        while (i2 < values.length - 1) {
            double val;
            double segLen = pts[i2].distance(pts[i2 - 1]);
            double lenFrac = (currLen += segLen) / lenME;
            values[i2] = val = midValue + lenFrac * delEndMid;
            ++i2;
        }
        return values;
    }

    private static int indexAtLength(Coordinate[] pts, double targetLen) {
        double len = 0.0;
        int i = 1;
        while (i < pts.length) {
            if ((len += pts[i].distance(pts[i - 1])) > targetLen) {
                return i;
            }
            ++i;
        }
        return pts.length - 1;
    }

    private static double length(Coordinate[] pts, int i1, int i2) {
        double len = 0.0;
        int i = i1 + 1;
        while (i <= i2) {
            len += pts[i].distance(pts[i - 1]);
            ++i;
        }
        return len;
    }

    public VariableBuffer(Geometry line, double[] distance) {
        this.line = (LineString)line;
        this.distance = distance;
        this.geomFactory = line.getFactory();
        if (distance.length != this.line.getNumPoints()) {
            throw new IllegalArgumentException("Number of distances is not equal to number of vertices");
        }
    }

    public Geometry getResult() {
        ArrayList<Polygon> parts = new ArrayList<Polygon>();
        Coordinate[] pts = this.line.getCoordinates();
        int i = 1;
        while (i < pts.length) {
            Polygon poly;
            double dist0 = this.distance[i - 1];
            double dist1 = this.distance[i];
            if ((dist0 > 0.0 || dist1 > 0.0) && (poly = this.segmentBuffer(pts[i - 1], pts[i], dist0, dist1)) != null) {
                parts.add(poly);
            }
            ++i;
        }
        GeometryCollection partsGeom = this.geomFactory.createGeometryCollection(GeometryFactory.toGeometryArray(parts));
        Geometry buffer = partsGeom.union();
        if (buffer.isEmpty()) {
            return this.geomFactory.createPolygon();
        }
        return buffer;
    }

    private Polygon segmentBuffer(Coordinate p0, Coordinate p1, double dist0, double dist1) {
        if (dist0 > dist1) {
            return this.segmentBuffer(p1, p0, dist1, dist0);
        }
        LineSegment tangent = VariableBuffer.outerTangent(p0, dist0, p1, dist1);
        if (tangent == null) {
            Coordinate center = p0;
            double dist = dist0;
            if (dist1 > dist0) {
                center = p1;
                dist = dist1;
            }
            return this.circle(center, dist);
        }
        Coordinate t0 = tangent.getCoordinate(0);
        Coordinate t1 = tangent.getCoordinate(1);
        LineSegment seg = new LineSegment(p0, p1);
        Coordinate tr0 = seg.reflect(t0);
        Coordinate tr1 = seg.reflect(t1);
        CoordinateList coords = new CoordinateList();
        coords.add(t0);
        coords.add(t1);
        this.addCap(p1, dist1, t1, tr1, coords);
        coords.add(tr1);
        coords.add(tr0);
        this.addCap(p0, dist0, tr0, t0, coords);
        coords.add(t0);
        Coordinate[] pts = coords.toCoordinateArray();
        Polygon polygon = this.geomFactory.createPolygon(pts);
        return polygon;
    }

    private Polygon circle(Coordinate center, double radius) {
        if (radius <= 0.0) {
            return null;
        }
        int nPts = 4 * this.quadrantSegs;
        Coordinate[] pts = new Coordinate[nPts + 1];
        double angInc = 1.5707963267948966 / (double)this.quadrantSegs;
        int i = 0;
        while (i < nPts) {
            pts[i] = VariableBuffer.projectPolar(center, radius, (double)i * angInc);
            ++i;
        }
        pts[pts.length - 1] = pts[0].copy();
        return this.geomFactory.createPolygon(pts);
    }

    private void addCap(Coordinate p, double r, Coordinate t1, Coordinate t2, CoordinateList coords) {
        double angEnd;
        double angStart = Angle.angle(p, t1);
        if (angStart < (angEnd = Angle.angle(p, t2))) {
            angStart += Math.PI * 2;
        }
        int indexStart = this.capAngleIndex(angStart);
        int indexEnd = this.capAngleIndex(angEnd);
        int i = indexStart;
        while (i > indexEnd) {
            double ang = this.capAngle(i);
            coords.add(VariableBuffer.projectPolar(p, r, ang));
            --i;
        }
    }

    private double capAngle(int index) {
        double capSegAng = 1.5707963267948966 / (double)this.quadrantSegs;
        return (double)index * capSegAng;
    }

    private int capAngleIndex(double ang) {
        double capSegAng = 1.5707963267948966 / (double)this.quadrantSegs;
        int index = (int)(ang / capSegAng);
        return index;
    }

    private static LineSegment outerTangent(Coordinate c1, double r1, Coordinate c2, double r2) {
        if (r1 > r2) {
            LineSegment seg = VariableBuffer.outerTangent(c2, r2, c1, r1);
            return new LineSegment(seg.p1, seg.p0);
        }
        double x1 = c1.getX();
        double y1 = c1.getY();
        double x2 = c2.getX();
        double y2 = c2.getY();
        double a3 = -Math.atan2(y2 - y1, x2 - x1);
        double dr = r2 - r1;
        double d = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        double a2 = Math.asin(dr / d);
        if (Double.isNaN(a2)) {
            return null;
        }
        double a1 = a3 - a2;
        double aa = 1.5707963267948966 - a1;
        double x3 = x1 + r1 * Math.cos(aa);
        double y3 = y1 + r1 * Math.sin(aa);
        double x4 = x2 + r2 * Math.cos(aa);
        double y4 = y2 + r2 * Math.sin(aa);
        return new LineSegment(x3, y3, x4, y4);
    }

    private static Coordinate projectPolar(Coordinate p, double r, double ang) {
        double x = p.getX() + r * VariableBuffer.snapTrig(Math.cos(ang));
        double y = p.getY() + r * VariableBuffer.snapTrig(Math.sin(ang));
        return new Coordinate(x, y);
    }

    private static double snapTrig(double x) {
        if (x > 0.999999) {
            return 1.0;
        }
        if (x < -0.999999) {
            return -1.0;
        }
        if (Math.abs(x) < 1.0E-6) {
            return 0.0;
        }
        return x;
    }
}

