/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance;

import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.operation.distance.GeometryLocation;

public class FacetSequence {
    private Geometry geom = null;
    private CoordinateSequence pts;
    private int start;
    private int end;

    public FacetSequence(Geometry geom, CoordinateSequence pts, int start, int end) {
        this.geom = geom;
        this.pts = pts;
        this.start = start;
        this.end = end;
    }

    public FacetSequence(CoordinateSequence pts, int start, int end) {
        this.pts = pts;
        this.start = start;
        this.end = end;
    }

    public FacetSequence(CoordinateSequence pts, int start) {
        this.pts = pts;
        this.start = start;
        this.end = start + 1;
    }

    public Envelope getEnvelope() {
        Envelope env = new Envelope();
        int i = this.start;
        while (i < this.end) {
            env.expandToInclude(this.pts.getX(i), this.pts.getY(i));
            ++i;
        }
        return env;
    }

    public int size() {
        return this.end - this.start;
    }

    public Coordinate getCoordinate(int index) {
        return this.pts.getCoordinate(this.start + index);
    }

    public boolean isPoint() {
        return this.end - this.start == 1;
    }

    public double distance(FacetSequence facetSeq) {
        double distance;
        boolean isPoint = this.isPoint();
        boolean isPointOther = facetSeq.isPoint();
        if (isPoint && isPointOther) {
            Coordinate pt = this.pts.getCoordinate(this.start);
            Coordinate seqPt = facetSeq.pts.getCoordinate(facetSeq.start);
            distance = pt.distance(seqPt);
        } else if (isPoint) {
            Coordinate pt = this.pts.getCoordinate(this.start);
            distance = this.computeDistancePointLine(pt, facetSeq, null);
        } else if (isPointOther) {
            Coordinate seqPt = facetSeq.pts.getCoordinate(facetSeq.start);
            distance = this.computeDistancePointLine(seqPt, this, null);
        } else {
            distance = this.computeDistanceLineLine(facetSeq, null);
        }
        return distance;
    }

    public GeometryLocation[] nearestLocations(FacetSequence facetSeq) {
        boolean isPoint = this.isPoint();
        boolean isPointOther = facetSeq.isPoint();
        GeometryLocation[] locs = new GeometryLocation[2];
        if (isPoint && isPointOther) {
            Coordinate pt = this.pts.getCoordinate(this.start);
            Coordinate seqPt = facetSeq.pts.getCoordinate(facetSeq.start);
            locs[0] = new GeometryLocation(this.geom, this.start, new Coordinate(pt));
            locs[1] = new GeometryLocation(facetSeq.geom, facetSeq.start, new Coordinate(seqPt));
        } else if (isPoint) {
            Coordinate pt = this.pts.getCoordinate(this.start);
            this.computeDistancePointLine(pt, facetSeq, locs);
        } else if (isPointOther) {
            Coordinate seqPt = facetSeq.pts.getCoordinate(facetSeq.start);
            this.computeDistancePointLine(seqPt, this, locs);
            GeometryLocation tmp = locs[0];
            locs[0] = locs[1];
            locs[1] = tmp;
        } else {
            this.computeDistanceLineLine(facetSeq, locs);
        }
        return locs;
    }

    private double computeDistanceLineLine(FacetSequence facetSeq, GeometryLocation[] locs) {
        double minDistance = Double.MAX_VALUE;
        int i = this.start;
        while (i < this.end - 1) {
            Coordinate p0 = this.pts.getCoordinate(i);
            Coordinate p1 = this.pts.getCoordinate(i + 1);
            int j = facetSeq.start;
            while (j < facetSeq.end - 1) {
                Coordinate q1;
                Coordinate q0 = facetSeq.pts.getCoordinate(j);
                double dist = Distance.segmentToSegment(p0, p1, q0, q1 = facetSeq.pts.getCoordinate(j + 1));
                if (dist < minDistance) {
                    minDistance = dist;
                    if (locs != null) {
                        this.updateNearestLocationsLineLine(i, p0, p1, facetSeq, j, q0, q1, locs);
                    }
                    if (minDistance <= 0.0) {
                        return minDistance;
                    }
                }
                ++j;
            }
            ++i;
        }
        return minDistance;
    }

    private void updateNearestLocationsLineLine(int i, Coordinate p0, Coordinate p1, FacetSequence facetSeq, int j, Coordinate q0, Coordinate q1, GeometryLocation[] locs) {
        LineSegment seg0 = new LineSegment(p0, p1);
        LineSegment seg1 = new LineSegment(q0, q1);
        Coordinate[] closestPt = seg0.closestPoints(seg1);
        locs[0] = new GeometryLocation(this.geom, i, new Coordinate(closestPt[0]));
        locs[1] = new GeometryLocation(facetSeq.geom, j, new Coordinate(closestPt[1]));
    }

    private double computeDistancePointLine(Coordinate pt, FacetSequence facetSeq, GeometryLocation[] locs) {
        double minDistance = Double.MAX_VALUE;
        int i = facetSeq.start;
        while (i < facetSeq.end - 1) {
            Coordinate q1;
            Coordinate q0 = facetSeq.pts.getCoordinate(i);
            double dist = Distance.pointToSegment(pt, q0, q1 = facetSeq.pts.getCoordinate(i + 1));
            if (dist < minDistance) {
                minDistance = dist;
                if (locs != null) {
                    this.updateNearestLocationsPointLine(pt, facetSeq, i, q0, q1, locs);
                }
                if (minDistance <= 0.0) {
                    return minDistance;
                }
            }
            ++i;
        }
        return minDistance;
    }

    private void updateNearestLocationsPointLine(Coordinate pt, FacetSequence facetSeq, int i, Coordinate q0, Coordinate q1, GeometryLocation[] locs) {
        locs[0] = new GeometryLocation(this.geom, this.start, new Coordinate(pt));
        LineSegment seg = new LineSegment(q0, q1);
        Coordinate segClosestPoint = seg.closestPoint(pt);
        locs[1] = new GeometryLocation(facetSeq.geom, i, new Coordinate(segClosestPoint));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("LINESTRING ( ");
        Coordinate p = new Coordinate();
        int i = this.start;
        while (i < this.end) {
            if (i > this.start) {
                buf.append(", ");
            }
            this.pts.getCoordinate(i, p);
            buf.append(String.valueOf(p.x) + " " + p.y);
            ++i;
        }
        buf.append(" )");
        return buf.toString();
    }
}

