/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance3d;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Coordinates;
import org.locationtech.jts.geom.Envelope;

public class AxisPlaneCoordinateSequence
implements CoordinateSequence {
    private static final int[] XY_INDEX;
    private static final int[] XZ_INDEX;
    private static final int[] YZ_INDEX;
    private CoordinateSequence seq;
    private int[] indexMap;

    static {
        int[] nArray = new int[2];
        nArray[1] = 1;
        XY_INDEX = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        XZ_INDEX = nArray2;
        YZ_INDEX = new int[]{1, 2};
    }

    public static CoordinateSequence projectToXY(CoordinateSequence seq) {
        return new AxisPlaneCoordinateSequence(seq, XY_INDEX);
    }

    public static CoordinateSequence projectToXZ(CoordinateSequence seq) {
        return new AxisPlaneCoordinateSequence(seq, XZ_INDEX);
    }

    public static CoordinateSequence projectToYZ(CoordinateSequence seq) {
        return new AxisPlaneCoordinateSequence(seq, YZ_INDEX);
    }

    private AxisPlaneCoordinateSequence(CoordinateSequence seq, int[] indexMap) {
        this.seq = seq;
        this.indexMap = indexMap;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Coordinate getCoordinate(int i) {
        return this.getCoordinateCopy(i);
    }

    @Override
    public Coordinate getCoordinateCopy(int i) {
        return new Coordinate(this.getX(i), this.getY(i), this.getZ(i));
    }

    @Override
    public void getCoordinate(int index, Coordinate coord) {
        coord.x = this.getOrdinate(index, 0);
        coord.y = this.getOrdinate(index, 1);
        coord.setZ(this.getOrdinate(index, 2));
    }

    @Override
    public double getX(int index) {
        return this.getOrdinate(index, 0);
    }

    @Override
    public double getY(int index) {
        return this.getOrdinate(index, 1);
    }

    @Override
    public double getZ(int index) {
        return this.getOrdinate(index, 2);
    }

    @Override
    public double getOrdinate(int index, int ordinateIndex) {
        if (ordinateIndex > 1) {
            return 0.0;
        }
        return this.seq.getOrdinate(index, this.indexMap[ordinateIndex]);
    }

    @Override
    public int size() {
        return this.seq.size();
    }

    @Override
    public void setOrdinate(int index, int ordinateIndex, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Coordinate[] toCoordinateArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Envelope expandEnvelope(Envelope env) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AxisPlaneCoordinateSequence copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMeasures() {
        return 0;
    }

    @Override
    public double getM(int index) {
        if (this.hasM()) {
            int mIndex = this.getDimension() - this.getMeasures();
            return this.getOrdinate(index, mIndex);
        }
        return Double.NaN;
    }

    @Override
    public boolean hasZ() {
        return this.getDimension() - this.getMeasures() > 2;
    }

    @Override
    public boolean hasM() {
        return this.getMeasures() > 0;
    }

    @Override
    public Coordinate createCoordinate() {
        return Coordinates.create(this.getDimension(), this.getMeasures());
    }
}

