/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.union;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geom.util.GeometryCombiner;

public class OverlapUnion {
    private GeometryFactory geomFactory;
    private Geometry g0;
    private Geometry g1;
    private boolean isUnionSafe;

    public static Geometry union(Geometry g0, Geometry g1) {
        OverlapUnion union = new OverlapUnion(g0, g1);
        return union.union();
    }

    public OverlapUnion(Geometry g0, Geometry g1) {
        this.g0 = g0;
        this.g1 = g1;
        this.geomFactory = g0.getFactory();
    }

    public Geometry union() {
        Envelope overlapEnv = OverlapUnion.overlapEnvelope(this.g0, this.g1);
        if (overlapEnv.isNull()) {
            Geometry g0Copy = this.g0.copy();
            Geometry g1Copy = this.g1.copy();
            return GeometryCombiner.combine(g0Copy, g1Copy);
        }
        ArrayList<Geometry> disjointPolys = new ArrayList<Geometry>();
        Geometry g0Overlap = this.extractByEnvelope(overlapEnv, this.g0, disjointPolys);
        Geometry g1Overlap = this.extractByEnvelope(overlapEnv, this.g1, disjointPolys);
        Geometry unionGeom = this.unionFull(g0Overlap, g1Overlap);
        Geometry result = null;
        this.isUnionSafe = this.isBorderSegmentsSame(unionGeom, overlapEnv);
        result = !this.isUnionSafe ? this.unionFull(this.g0, this.g1) : this.combine(unionGeom, disjointPolys);
        return result;
    }

    boolean isUnionOptimized() {
        return this.isUnionSafe;
    }

    private static Envelope overlapEnvelope(Geometry g0, Geometry g1) {
        Envelope g0Env = g0.getEnvelopeInternal();
        Envelope g1Env = g1.getEnvelopeInternal();
        Envelope overlapEnv = g0Env.intersection(g1Env);
        return overlapEnv;
    }

    private Geometry combine(Geometry unionGeom, List<Geometry> disjointPolys) {
        if (disjointPolys.size() <= 0) {
            return unionGeom;
        }
        disjointPolys.add(unionGeom);
        Geometry result = GeometryCombiner.combine(disjointPolys);
        return result;
    }

    private Geometry extractByEnvelope(Envelope env, Geometry geom, List<Geometry> disjointGeoms) {
        ArrayList<Geometry> intersectingGeoms = new ArrayList<Geometry>();
        int i = 0;
        while (i < geom.getNumGeometries()) {
            Geometry elem = geom.getGeometryN(i);
            if (elem.getEnvelopeInternal().intersects(env)) {
                intersectingGeoms.add(elem);
            } else {
                Geometry copy = elem.copy();
                disjointGeoms.add(copy);
            }
            ++i;
        }
        return this.geomFactory.buildGeometry(intersectingGeoms);
    }

    private Geometry unionFull(Geometry geom0, Geometry geom1) {
        try {
            return geom0.union(geom1);
        }
        catch (TopologyException ex) {
            return OverlapUnion.unionBuffer(geom0, geom1);
        }
    }

    private static Geometry unionBuffer(Geometry g0, Geometry g1) {
        GeometryFactory factory = g0.getFactory();
        GeometryCollection gColl = factory.createGeometryCollection(new Geometry[]{g0, g1});
        Geometry union = gColl.buffer(0.0);
        return union;
    }

    private boolean isBorderSegmentsSame(Geometry result, Envelope env) {
        List<LineSegment> segsBefore = this.extractBorderSegments(this.g0, this.g1, env);
        ArrayList<LineSegment> segsAfter = new ArrayList<LineSegment>();
        OverlapUnion.extractBorderSegments(result, env, segsAfter);
        return this.isEqual(segsBefore, segsAfter);
    }

    private boolean isEqual(List<LineSegment> segs0, List<LineSegment> segs1) {
        if (segs0.size() != segs1.size()) {
            return false;
        }
        HashSet<LineSegment> segIndex = new HashSet<LineSegment>(segs0);
        for (LineSegment seg : segs1) {
            if (segIndex.contains(seg)) continue;
            return false;
        }
        return true;
    }

    private List<LineSegment> extractBorderSegments(Geometry geom0, Geometry geom1, Envelope env) {
        ArrayList<LineSegment> segs = new ArrayList<LineSegment>();
        OverlapUnion.extractBorderSegments(geom0, env, segs);
        if (geom1 != null) {
            OverlapUnion.extractBorderSegments(geom1, env, segs);
        }
        return segs;
    }

    private static boolean intersects(Envelope env, Coordinate p0, Coordinate p1) {
        return env.intersects(p0) || env.intersects(p1);
    }

    private static boolean containsProperly(Envelope env, Coordinate p0, Coordinate p1) {
        return OverlapUnion.containsProperly(env, p0) && OverlapUnion.containsProperly(env, p1);
    }

    private static boolean containsProperly(Envelope env, Coordinate p) {
        if (env.isNull()) {
            return false;
        }
        return p.getX() > env.getMinX() && p.getX() < env.getMaxX() && p.getY() > env.getMinY() && p.getY() < env.getMaxY();
    }

    private static void extractBorderSegments(Geometry geom, final Envelope env, final List<LineSegment> segs) {
        geom.apply(new CoordinateSequenceFilter(){

            @Override
            public void filter(CoordinateSequence seq, int i) {
                Coordinate p1;
                boolean isBorder;
                if (i <= 0) {
                    return;
                }
                Coordinate p0 = seq.getCoordinate(i - 1);
                boolean bl = isBorder = OverlapUnion.intersects(env, p0, p1 = seq.getCoordinate(i)) && !OverlapUnion.containsProperly(env, p0, p1);
                if (isBorder) {
                    LineSegment seg = new LineSegment(p0, p1);
                    segs.add(seg);
                }
            }

            @Override
            public boolean isDone() {
                return false;
            }

            @Override
            public boolean isGeometryChanged() {
                return false;
            }
        });
    }
}

